/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.lua.ObjectLuaTable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IArguments {
    public int count();

    @Nullable
    public Object get(int var1);

    public IArguments drop(int var1);

    default public Object[] getAll() {
        Object[] result = new Object[this.count()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    default public double getDouble(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(index, "number", value);
        }
        Number number = (Number)value;
        return number.doubleValue();
    }

    default public int getInt(int index) throws LuaException {
        return (int)this.getLong(index);
    }

    default public long getLong(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(index, "number", value);
        }
        Number number = (Number)value;
        return LuaValues.checkFiniteNum(index, number).longValue();
    }

    default public double getFiniteDouble(int index) throws LuaException {
        return LuaValues.checkFinite(index, this.getDouble(index));
    }

    default public boolean getBoolean(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Boolean)) {
            throw LuaValues.badArgumentOf(index, "boolean", value);
        }
        Boolean bool = (Boolean)value;
        return bool;
    }

    @Nonnull
    default public String getString(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof String)) {
            throw LuaValues.badArgumentOf(index, "string", value);
        }
        String string = (String)value;
        return string;
    }

    @Nonnull
    default public ByteBuffer getBytes(int index) throws LuaException {
        return LuaValues.encode(this.getString(index));
    }

    @Nonnull
    default public <T extends Enum<T>> T getEnum(int index, Class<T> klass) throws LuaException {
        return LuaValues.checkEnum(index, klass, this.getString(index));
    }

    @Nonnull
    default public Map<?, ?> getTable(int index) throws LuaException {
        Object value = this.get(index);
        if (!(value instanceof Map)) {
            throw LuaValues.badArgumentOf(index, "table", value);
        }
        return (Map)value;
    }

    @Nonnull
    default public LuaTable<?, ?> getTableUnsafe(int index) throws LuaException {
        return new ObjectLuaTable(this.getTable(index));
    }

    @Nonnull
    default public Optional<Double> optDouble(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(index, "number", value);
        }
        Number number = (Number)value;
        return Optional.of(number.doubleValue());
    }

    @Nonnull
    default public Optional<Integer> optInt(int index) throws LuaException {
        return this.optLong(index).map(Long::intValue);
    }

    default public Optional<Long> optLong(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Number)) {
            throw LuaValues.badArgumentOf(index, "number", value);
        }
        Number number = (Number)value;
        return Optional.of(LuaValues.checkFiniteNum(index, number).longValue());
    }

    default public Optional<Double> optFiniteDouble(int index) throws LuaException {
        Optional<Double> value = this.optDouble(index);
        if (value.isPresent()) {
            LuaValues.checkFiniteNum(index, value.get());
        }
        return value;
    }

    default public Optional<Boolean> optBoolean(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw LuaValues.badArgumentOf(index, "boolean", value);
        }
        Boolean bool = (Boolean)value;
        return Optional.of(bool);
    }

    default public Optional<String> optString(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw LuaValues.badArgumentOf(index, "string", value);
        }
        String string = (String)value;
        return Optional.of(string);
    }

    default public Optional<ByteBuffer> optBytes(int index) throws LuaException {
        return this.optString(index).map(LuaValues::encode);
    }

    @Nonnull
    default public <T extends Enum<T>> Optional<T> optEnum(int index, Class<T> klass) throws LuaException {
        Optional<String> str = this.optString(index);
        return str.isPresent() ? Optional.of(LuaValues.checkEnum(index, klass, str.get())) : Optional.empty();
    }

    default public Optional<Map<?, ?>> optTable(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw LuaValues.badArgumentOf(index, "map", value);
        }
        return Optional.of((Map)value);
    }

    @Nonnull
    default public Optional<LuaTable<?, ?>> optTableUnsafe(int index) throws LuaException {
        Object value = this.get(index);
        if (value == null) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw LuaValues.badArgumentOf(index, "map", value);
        }
        return Optional.of(new ObjectLuaTable((Map)value));
    }

    default public double optDouble(int index, double def) throws LuaException {
        return this.optDouble(index).orElse(def);
    }

    default public int optInt(int index, int def) throws LuaException {
        return this.optInt(index).orElse(def);
    }

    default public long optLong(int index, long def) throws LuaException {
        return this.optLong(index).orElse(def);
    }

    default public double optFiniteDouble(int index, double def) throws LuaException {
        return this.optFiniteDouble(index).orElse(def);
    }

    default public boolean optBoolean(int index, boolean def) throws LuaException {
        return this.optBoolean(index).orElse(def);
    }

    default public String optString(int index, String def) throws LuaException {
        return this.optString(index).orElse(def);
    }

    default public Map<?, ?> optTable(int index, Map<Object, Object> def) throws LuaException {
        return this.optTable(index).orElse(def);
    }
}

