/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.function;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaBaseString;
import cc.tweaked.internal.cobalt.LuaDouble;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaNumber;
import cc.tweaked.internal.cobalt.LuaRope;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.Print;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHandler;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import cc.tweaked.internal.cobalt.function.LuaInterpretedFunction;
import cc.tweaked.internal.cobalt.function.Upvalue;

public final class LuaInterpreter {
    static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = new LuaValue[p.maxstacksize];
        System.arraycopy(Constants.NILS, 0, stack, 0, p.maxstacksize);
        return LuaInterpreter.setupCall(state, function, (Varargs)Constants.NONE, stack, flags);
    }

    static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, LuaValue arg, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = new LuaValue[p.maxstacksize];
        System.arraycopy(Constants.NILS, 0, stack, 0, p.maxstacksize);
        switch (p.numparams) {
            case 0: {
                return LuaInterpreter.setupCall(state, function, (Varargs)arg, stack, flags);
            }
        }
        stack[0] = arg;
        return LuaInterpreter.setupCall(state, function, (Varargs)Constants.NONE, stack, flags);
    }

    static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, LuaValue arg1, LuaValue arg2, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = new LuaValue[p.maxstacksize];
        System.arraycopy(Constants.NILS, 0, stack, 0, p.maxstacksize);
        switch (p.numparams) {
            case 0: {
                return LuaInterpreter.setupCall(state, function, p.is_vararg != 0 ? ValueFactory.varargsOf(arg1, (Varargs)arg2) : Constants.NONE, stack, flags);
            }
            case 1: {
                stack[0] = arg1;
                return LuaInterpreter.setupCall(state, function, (Varargs)arg2, stack, flags);
            }
        }
        stack[0] = arg1;
        stack[1] = arg2;
        return LuaInterpreter.setupCall(state, function, (Varargs)Constants.NONE, stack, flags);
    }

    static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, LuaValue arg1, LuaValue arg2, LuaValue arg3, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = new LuaValue[p.maxstacksize];
        System.arraycopy(Constants.NILS, 0, stack, 0, p.maxstacksize);
        switch (p.numparams) {
            case 0: {
                return LuaInterpreter.setupCall(state, function, p.is_vararg != 0 ? ValueFactory.varargsOf(arg1, arg2, (Varargs)arg3) : Constants.NONE, stack, flags);
            }
            case 1: {
                stack[0] = arg1;
                return LuaInterpreter.setupCall(state, function, p.is_vararg != 0 ? ValueFactory.varargsOf(arg2, (Varargs)arg3) : Constants.NONE, stack, flags);
            }
            case 2: {
                stack[0] = arg1;
                stack[1] = arg2;
                return LuaInterpreter.setupCall(state, function, (Varargs)arg3, stack, flags);
            }
        }
        stack[0] = arg1;
        stack[1] = arg2;
        stack[2] = arg3;
        return LuaInterpreter.setupCall(state, function, (Varargs)Constants.NONE, stack, flags);
    }

    static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, Varargs varargs, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = new LuaValue[p.maxstacksize];
        System.arraycopy(Constants.NILS, 0, stack, 0, p.maxstacksize);
        for (int i = 0; i < p.numparams; ++i) {
            stack[i] = varargs.arg(i + 1);
        }
        return LuaInterpreter.setupCall(state, function, p.is_vararg != 0 ? varargs.subargs(p.numparams + 1) : Constants.NONE, stack, flags);
    }

    private static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, LuaValue[] args, int argStart, int argSize, Varargs varargs, int flags) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        LuaValue[] stack = new LuaValue[p.maxstacksize];
        System.arraycopy(Constants.NILS, 0, stack, 0, p.maxstacksize);
        varargs = ValueFactory.varargsOf(args, argStart, argSize, varargs);
        for (int i = 0; i < p.numparams; ++i) {
            stack[i] = varargs.arg(i + 1);
        }
        return LuaInterpreter.setupCall(state, function, p.is_vararg != 0 ? varargs.subargs(p.numparams + 1) : Constants.NONE, stack, flags);
    }

    private static DebugFrame setupCall(LuaState state, LuaInterpretedFunction function, Varargs varargs, LuaValue[] stack, int flags) throws LuaError, UnwindThrowable {
        Upvalue[] upvalues;
        Prototype p = function.p;
        Upvalue[] upvalueArray = upvalues = p.p.length > 0 ? new Upvalue[stack.length] : null;
        if (p.is_vararg >= 4) {
            stack[p.numparams] = new LuaTable(varargs);
        }
        DebugState ds = DebugHandler.getDebugState(state);
        DebugFrame di = (flags & 8) != 0 ? ds.pushJavaInfo() : ds.pushInfo();
        di.setFunction(function, varargs.asImmutable(), stack, upvalues);
        di.flags |= flags;
        di.extras = Constants.NONE;
        di.pc = 0;
        if (!ds.inhook && ds.hookcall) {
            ds.hookCall(di);
        }
        di.top = 0;
        return di;
    }

    static Varargs execute(LuaState state, DebugFrame di, LuaInterpretedFunction function) throws LuaError, UnwindThrowable {
        DebugState ds = DebugHandler.getDebugState(state);
        DebugHandler handler = state.debug;
        block67: while (true) {
            Prototype p = function.p;
            Upvalue[] upvalues = function.upvalues;
            int[] code = p.code;
            LuaValue[] k = p.k;
            LuaValue[] stack = di.stack;
            Upvalue[] openups = di.stackUpvalues;
            Varargs varargs = di.varargs;
            int pc = di.pc;
            block68: while (true) {
                handler.onInstruction(ds, di, pc);
                int i = code[pc++];
                int a = i >> 6 & 0xFF;
                block0 : switch (i >> 0 & 0x3F) {
                    case 0: {
                        stack[a] = stack[i >>> 23 & 0x1FF];
                        break;
                    }
                    case 1: {
                        stack[a] = k[i >>> 14 & 0x3FFFF];
                        break;
                    }
                    case 2: {
                        LuaValue luaValue = stack[a] = (i >>> 23 & 0x1FF) != 0 ? Constants.TRUE : Constants.FALSE;
                        if ((i >>> 14 & 0x1FF) == 0) break;
                        ++pc;
                        break;
                    }
                    case 3: {
                        int b = i >>> 23 & 0x1FF;
                        do {
                            stack[b--] = Constants.NIL;
                        } while (b >= a);
                        break;
                    }
                    case 4: {
                        stack[a] = upvalues[i >>> 23 & 0x1FF].getValue();
                        break;
                    }
                    case 5: {
                        stack[a] = OperationHelper.getTable(state, function.env, k[i >>> 14 & 0x3FFFF]);
                        break;
                    }
                    case 6: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >>> 14 & 0x1FF;
                        stack[a] = OperationHelper.getTable(state, stack[b], c > 255 ? k[c & 0xFF] : stack[c], b);
                        break;
                    }
                    case 7: {
                        OperationHelper.setTable(state, function.env, k[i >>> 14 & 0x3FFFF], stack[a]);
                        break;
                    }
                    case 8: {
                        upvalues[i >>> 23 & 0x1FF].setValue(stack[a]);
                        break;
                    }
                    case 9: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >>> 14 & 0x1FF;
                        OperationHelper.setTable(state, stack[a], b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], a);
                        break;
                    }
                    case 10: {
                        stack[a] = new LuaTable(i >>> 23 & 0x1FF, i >>> 14 & 0x1FF);
                        break;
                    }
                    case 11: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        LuaValue luaValue = stack[b];
                        stack[a + 1] = luaValue;
                        LuaValue o = luaValue;
                        stack[a] = OperationHelper.getTable(state, o, c > 255 ? k[c & 0xFF] : stack[c], b);
                        break;
                    }
                    case 12: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        stack[a] = OperationHelper.add(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], b, c);
                        break;
                    }
                    case 13: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        stack[a] = OperationHelper.sub(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], b, c);
                        break;
                    }
                    case 14: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        stack[a] = OperationHelper.mul(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], b, c);
                        break;
                    }
                    case 15: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        stack[a] = OperationHelper.div(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], b, c);
                        break;
                    }
                    case 16: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        stack[a] = OperationHelper.mod(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], b, c);
                        break;
                    }
                    case 17: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        stack[a] = OperationHelper.pow(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c], b, c);
                        break;
                    }
                    case 18: {
                        int b = i >>> 23 & 0x1FF;
                        stack[a] = OperationHelper.neg(state, b > 255 ? k[b & 0xFF] : stack[b], b);
                        break;
                    }
                    case 19: {
                        stack[a] = stack[i >>> 23 & 0x1FF].toBoolean() ? Constants.FALSE : Constants.TRUE;
                        break;
                    }
                    case 20: {
                        int b = i >>> 23 & 0x1FF;
                        stack[a] = OperationHelper.length(state, stack[b], b);
                        break;
                    }
                    case 21: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        di.top = c + 1;
                        LuaInterpreter.concat(state, di, stack, di.top, c - b + 1);
                        stack[a] = stack[b];
                        di.top = b;
                        break;
                    }
                    case 22: {
                        pc += (i >>> 14 & 0x3FFFF) - 131071;
                        break;
                    }
                    case 23: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        if (OperationHelper.eq(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c]) == (a != 0)) {
                            pc += (code[pc] >> 14 & 0x3FFFF) - 131071;
                        }
                        ++pc;
                        break;
                    }
                    case 24: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        if (OperationHelper.lt(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c]) == (a != 0)) {
                            pc += (code[pc] >> 14 & 0x3FFFF) - 131071;
                        }
                        ++pc;
                        break;
                    }
                    case 25: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        if (OperationHelper.le(state, b > 255 ? k[b & 0xFF] : stack[b], c > 255 ? k[c & 0xFF] : stack[c]) == (a != 0)) {
                            pc += (code[pc] >> 14 & 0x3FFFF) - 131071;
                        }
                        ++pc;
                        break;
                    }
                    case 26: {
                        if (stack[a].toBoolean() == ((i >> 14 & 0x1FF) != 0)) {
                            pc += (code[pc] >> 14 & 0x3FFFF) - 131071;
                        }
                        ++pc;
                        break;
                    }
                    case 27: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        LuaValue val = stack[b];
                        if (val.toBoolean() == (c != 0)) {
                            stack[a] = val;
                            pc += (code[pc] >> 14 & 0x3FFFF) - 131071;
                        }
                        ++pc;
                        break;
                    }
                    case 28: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        LuaValue val = stack[a];
                        if (val instanceof LuaInterpretedFunction) {
                            function = (LuaInterpretedFunction)val;
                            switch (b) {
                                case 1: {
                                    di = LuaInterpreter.setupCall(state, function, 0);
                                    continue block67;
                                }
                                case 2: {
                                    di = LuaInterpreter.setupCall(state, function, stack[a + 1], 0);
                                    continue block67;
                                }
                                case 3: {
                                    di = LuaInterpreter.setupCall(state, function, stack[a + 1], stack[a + 2], 0);
                                    continue block67;
                                }
                                case 4: {
                                    di = LuaInterpreter.setupCall(state, function, stack[a + 1], stack[a + 2], stack[a + 3], 0);
                                    continue block67;
                                }
                            }
                            di = b > 0 ? LuaInterpreter.setupCall(state, function, stack, a + 1, b - 1, Constants.NONE, 0) : LuaInterpreter.setupCall(state, function, stack, a + 1, di.top - di.extras.count() - (a + 1), di.extras, 0);
                            continue block67;
                        }
                        switch (i & 0xFFFFC000) {
                            case 0x800000: {
                                Varargs v = di.extras = OperationHelper.invoke(state, val, Constants.NONE, a);
                                di.top = a + v.count();
                                break block0;
                            }
                            case 0x1000000: {
                                Varargs v = di.extras = OperationHelper.invoke(state, val, stack[a + 1], a);
                                di.top = a + v.count();
                                break block0;
                            }
                            case 0x804000: {
                                OperationHelper.call(state, val, a);
                                break block0;
                            }
                            case 0x1004000: {
                                OperationHelper.call(state, val, stack[a + 1], a);
                                break block0;
                            }
                            case 25182208: {
                                OperationHelper.call(state, val, stack[a + 1], stack[a + 2], a);
                                break block0;
                            }
                            case 0x2004000: {
                                OperationHelper.call(state, val, stack[a + 1], stack[a + 2], stack[a + 3], a);
                                break block0;
                            }
                            case 0x808000: {
                                stack[a] = OperationHelper.call(state, val, a);
                                break block0;
                            }
                            case 0x1008000: {
                                stack[a] = OperationHelper.call(state, val, stack[a + 1], a);
                                break block0;
                            }
                            case 0x1808000: {
                                stack[a] = OperationHelper.call(state, val, stack[a + 1], stack[a + 2], a);
                                break block0;
                            }
                            case 0x2008000: {
                                stack[a] = OperationHelper.call(state, val, stack[a + 1], stack[a + 2], stack[a + 3], a);
                                break block0;
                            }
                        }
                        Varargs args = b > 0 ? ValueFactory.varargsOf(stack, a + 1, b - 1) : ValueFactory.varargsOf(stack, a + 1, di.top - di.extras.count() - (a + 1), di.extras);
                        Varargs v = OperationHelper.invoke(state, val, args.asImmutable(), a);
                        if (c > 0) {
                            while (--c > 0) {
                                stack[a + c - 1] = v.arg(c);
                            }
                            v = Constants.NONE;
                            break;
                        }
                        di.top = a + v.count();
                        di.extras = v;
                        break;
                    }
                    case 29: {
                        LuaFunction functionVal;
                        Varargs args;
                        int b = i >>> 23 & 0x1FF;
                        LuaValue val = stack[a];
                        switch (b) {
                            case 1: {
                                args = Constants.NONE;
                                break;
                            }
                            case 2: {
                                args = stack[a + 1];
                                break;
                            }
                            default: {
                                Varargs v = di.extras;
                                Varargs varargs2 = args = b > 0 ? ValueFactory.varargsOf(stack, a + 1, b - 1) : ValueFactory.varargsOf(stack, a + 1, di.top - v.count() - (a + 1), v);
                            }
                        }
                        if (val.isFunction()) {
                            functionVal = (LuaFunction)val;
                        } else {
                            LuaValue meta = val.metatag(state, Constants.CALL);
                            if (!meta.isFunction()) {
                                throw ErrorFactory.operandError(state, val, "call", a);
                            }
                            functionVal = (LuaFunction)meta;
                            args = ValueFactory.varargsOf(val, args);
                        }
                        if (functionVal instanceof LuaInterpretedFunction) {
                            int flags = di.flags;
                            LuaInterpreter.closeAll(openups);
                            ds.popInfo();
                            function = (LuaInterpretedFunction)functionVal;
                            di = LuaInterpreter.setupCall(state, function, args, flags & 8 | 0x2000);
                            continue block67;
                        }
                        Varargs v = functionVal.invoke(state, args.asImmutable());
                        di.top = a + v.count();
                        di.extras = v;
                        break;
                    }
                    case 30: {
                        Varargs ret;
                        int b = i >>> 23 & 0x1FF;
                        int flags = di.flags;
                        int top = di.top;
                        Varargs v = di.extras;
                        LuaInterpreter.closeAll(openups);
                        handler.onReturn(ds, di);
                        switch (b) {
                            case 0: {
                                ret = ValueFactory.varargsOf(stack, a, top - v.count() - a, v).asImmutable();
                                break;
                            }
                            case 1: {
                                ret = Constants.NONE;
                                break;
                            }
                            case 2: {
                                ret = stack[a];
                                break;
                            }
                            default: {
                                ret = ValueFactory.varargsOf(stack, a, b - 1).asImmutable();
                            }
                        }
                        if ((flags & 8) != 0) {
                            return ret;
                        }
                        di = ds.getStackUnsafe();
                        function = (LuaInterpretedFunction)di.closure;
                        LuaInterpreter.resume(state, di, function, ret);
                        continue block67;
                    }
                    case 31: {
                        double limit = stack[a + 1].checkDouble();
                        double step = stack[a + 2].checkDouble();
                        double value = stack[a].checkDouble();
                        double idx = step + value;
                        if (!(0.0 < step ? idx <= limit : limit <= idx)) continue block68;
                        stack[a + 3] = stack[a] = LuaDouble.valueOf(idx);
                        pc += (i >>> 14 & 0x3FFFF) - 131071;
                        break;
                    }
                    case 32: {
                        LuaNumber init = stack[a].checkNumber("'for' initial value must be a number");
                        LuaNumber limit = stack[a + 1].checkNumber("'for' limit must be a number");
                        LuaNumber step = stack[a + 2].checkNumber("'for' step must be a number");
                        stack[a] = LuaDouble.valueOf(init.toDouble() - step.toDouble());
                        stack[a + 1] = limit;
                        stack[a + 2] = step;
                        pc += (i >>> 14 & 0x3FFFF) - 131071;
                        break;
                    }
                    case 33: {
                        Varargs v = di.extras = OperationHelper.invoke(state, stack[a], ValueFactory.varargsOf(stack[a + 1], (Varargs)stack[a + 2]), a);
                        LuaValue val = v.first();
                        if (val.isNil()) {
                            ++pc;
                            break;
                        }
                        LuaValue luaValue = val;
                        stack[a + 3] = luaValue;
                        stack[a + 2] = luaValue;
                        for (int c = i >> 14 & 0x1FF; c > 1; --c) {
                            stack[a + 2 + c] = v.arg(c);
                        }
                        di.extras = Constants.NONE;
                        break;
                    }
                    case 34: {
                        int b = i >>> 23 & 0x1FF;
                        int c = i >> 14 & 0x1FF;
                        if (c == 0) {
                            c = code[pc++];
                        }
                        int offset = (c - 1) * 50;
                        LuaTable tbl = stack[a].checkTable();
                        if (b == 0) {
                            int j;
                            b = di.top - a - 1;
                            int m = b - di.extras.count();
                            for (j = 1; j <= m; ++j) {
                                tbl.rawset(offset + j, stack[a + j]);
                            }
                            while (true) {
                                if (j > b) continue block68;
                                tbl.rawset(offset + j, di.extras.arg(j - m));
                                ++j;
                            }
                        }
                        tbl.presize(offset + b);
                        int j = 1;
                        while (true) {
                            if (j > b) continue block68;
                            tbl.rawset(offset + j, stack[a + j]);
                            ++j;
                        }
                    }
                    case 35: {
                        int x = openups.length;
                        while (true) {
                            if (--x < a) continue block68;
                            Upvalue upvalue = openups[x];
                            if (upvalue == null) continue;
                            upvalue.close();
                            openups[x] = null;
                        }
                    }
                    case 36: {
                        Prototype newp = p.p[i >>> 14 & 0x3FFFF];
                        LuaInterpretedFunction newcl = new LuaInterpretedFunction(newp, function.env);
                        int nup = newp.nups;
                        for (int j = 0; j < nup; ++j) {
                            i = code[pc++];
                            int b = i >>> 23 & 0x1FF;
                            newcl.upvalues[j] = (i & 4) != 0 ? upvalues[b] : (openups[b] != null ? openups[b] : new Upvalue(stack, b));
                        }
                        stack[a] = newcl;
                        break;
                    }
                    case 37: {
                        int b = i >>> 23 & 0x1FF;
                        if (b == 0) {
                            di.top = a + varargs.count();
                            di.extras = varargs;
                            break;
                        }
                        for (int j = 1; j < b; ++j) {
                            stack[a + j - 1] = varargs.arg(j);
                        }
                        continue block68;
                    }
                }
            }
            break;
        }
    }

    private static void concat(LuaState state, DebugFrame frame, LuaValue[] stack, int top, int total) throws LuaError, UnwindThrowable {
        try {
            int n;
            do {
                LuaValue left = stack[top - 2];
                LuaValue right = stack[top - 1];
                if (!left.isString() || !right.isString()) {
                    stack[top - 2] = OperationHelper.concatNonStrings(state, left, right, top - 2, top - 1);
                } else {
                    LuaBaseString rString = right.checkLuaBaseString();
                    if (rString.length() == 0) {
                        stack[top - 2] = left.checkLuaString();
                    } else {
                        LuaBaseString lString = left.checkLuaBaseString();
                        if (lString.length() == 0) {
                            stack[top - 2] = rString;
                        } else {
                            LuaValue value;
                            int length = rString.length() + lString.length();
                            stack[top - 2] = lString;
                            stack[top - 1] = rString;
                            for (n = 2; n < total && (value = stack[top - n - 1]).isString(); ++n) {
                                LuaBaseString string = value.checkLuaBaseString();
                                int strLen = string.length();
                                if (strLen > Integer.MAX_VALUE - length) {
                                    throw new LuaError("string length overflow");
                                }
                                stack[top - n - 1] = string;
                                length += strLen;
                            }
                            stack[top - n] = LuaRope.valueOf(stack, top - n, n, length);
                        }
                    }
                }
                top -= n - 1;
            } while ((total -= n - 1) > 1);
        }
        catch (UnwindThrowable e) {
            frame.top = top;
            throw e;
        }
    }

    public static void closeAll(Upvalue[] upvalues) {
        if (upvalues == null) {
            return;
        }
        for (Upvalue upvalue : upvalues) {
            if (upvalue == null) continue;
            upvalue.close();
        }
    }

    public static void resume(LuaState state, DebugFrame di, LuaInterpretedFunction function, Varargs varargs) throws LuaError, UnwindThrowable {
        Prototype p = function.p;
        int i = p.code[di.pc++];
        switch (i >> 0 & 0x3F) {
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                di.stack[i >> 6 & 0xFF] = varargs.first();
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                boolean res = varargs.first().toBoolean();
                if ((di.flags & 0x80) != 0) {
                    res = !res;
                    di.flags ^= 0x80;
                }
                if (res == ((i >> 6 & 0xFF) != 0)) {
                    di.pc += (p.code[di.pc] >> 14 & 0x3FFFF) - 131071;
                }
                ++di.pc;
                break;
            }
            case 28: 
            case 29: {
                int a = i >>> 6 & 0xFF;
                int c = i >>> 14 & 0x1FF;
                if (c > 0) {
                    LuaValue[] stack = di.stack;
                    while (--c > 0) {
                        stack[a + c - 1] = varargs.arg(c);
                    }
                    di.extras = Constants.NONE;
                    break;
                }
                di.extras = varargs;
                di.top = a + varargs.count();
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 33: {
                LuaValue o = varargs.first();
                if (o.isNil()) {
                    ++di.pc;
                    break;
                }
                int a = i >>> 6 & 0xFF;
                LuaValue[] stack = di.stack;
                LuaValue luaValue = o;
                stack[a + 3] = luaValue;
                stack[a + 2] = luaValue;
                for (int c = i >>> 14 & 0x1FF; c > 1; --c) {
                    stack[a + 2 + c] = varargs.arg(c);
                }
                di.extras = Constants.NONE;
                break;
            }
            case 21: {
                int a = i >>> 6 & 0xFF;
                int b = i >>> 23 & 0x1FF;
                LuaValue[] stack = di.stack;
                int top = di.top - 1;
                stack[top - 1] = varargs.first();
                int total = top - b;
                if (total > 1) {
                    --di.pc;
                    LuaInterpreter.concat(state, di, stack, top, total);
                    ++di.pc;
                }
                stack[a] = stack[b];
                di.top = top;
                break;
            }
            default: {
                throw new IllegalStateException("Resuming from unknown instruction");
            }
        }
    }

    public static Varargs resumeReturn(LuaState state, DebugState ds, DebugFrame di, LuaInterpretedFunction function) throws LuaError, UnwindThrowable {
        int i = function.p.code[di.pc];
        DebugHandler handler = state.debug;
        switch (i >> 0 & 0x3F) {
            case 30: {
                Varargs ret;
                int a = i >>> 6 & 0xFF;
                int b = i >>> 23 & 0x1FF;
                switch (b) {
                    case 0: {
                        ret = ValueFactory.varargsOf(di.stack, a, di.top - di.extras.count() - a, di.extras).asImmutable();
                        break;
                    }
                    case 1: {
                        ret = Constants.NONE;
                        break;
                    }
                    case 2: {
                        ret = di.stack[a];
                        break;
                    }
                    default: {
                        ret = ValueFactory.varargsOf(di.stack, a, b - 1).asImmutable();
                    }
                }
                int flags = di.flags;
                handler.onReturnError(ds);
                if ((flags & 8) != 0) {
                    return ret;
                }
                di = ds.getStackUnsafe();
                function = (LuaInterpretedFunction)di.closure;
                LuaInterpreter.resume(state, di, function, ret);
                return LuaInterpreter.execute(state, di, function);
            }
        }
        Print.printCode(System.out, function.p);
        throw new IllegalStateException("Cannot resume on this opcode (pc=" + di.pc + ")");
    }
}

