/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdeserttemples.module.StructureTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class BetterDesertTempleStructure
extends Structure {
    public static final Codec<BetterDesertTempleStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BetterDesertTempleStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)IntProvider.m_146545_((int)0, (int)15).optionalFieldOf("x_offset_in_chunk", (Object)ConstantInt.m_146483_((int)0)).forGetter(structure -> structure.xOffsetInChunk), (App)IntProvider.m_146545_((int)0, (int)15).optionalFieldOf("z_offset_in_chunk", (Object)ConstantInt.m_146483_((int)0)).forGetter(structure -> structure.zOffsetInChunk), (App)Codec.INT.optionalFieldOf("min_y").forGetter(structure -> structure.minY), (App)Codec.INT.optionalFieldOf("max_y").forGetter(structure -> structure.maxY), (App)Codec.INT.optionalFieldOf("min_possible_start_y").forGetter(structure -> structure.minPossibleStartY), (App)Codec.INT.optionalFieldOf("max_possible_start_y").forGetter(structure -> structure.maxPossibleStartY)).apply((Applicative)builder, BetterDesertTempleStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    public final IntProvider xOffsetInChunk;
    public final IntProvider zOffsetInChunk;
    public final Optional<Integer> minY;
    public final Optional<Integer> maxY;
    public final Optional<Integer> minPossibleStartY;
    public final Optional<Integer> maxPossibleStartY;

    public BetterDesertTempleStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, IntProvider xOffsetInChunk, IntProvider zOffsetInChunk, Optional<Integer> minY, Optional<Integer> maxY, Optional<Integer> minPossibleStartY, Optional<Integer> maxPossibleStartY) {
        super(structureSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.xOffsetInChunk = xOffsetInChunk;
        this.zOffsetInChunk = zOffsetInChunk;
        this.minY = minY;
        this.maxY = maxY;
        this.minPossibleStartY = minPossibleStartY;
        this.maxPossibleStartY = maxPossibleStartY;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom randomSource = context.f_226626_();
        int xOffset = this.xOffsetInChunk.m_214085_((RandomSource)randomSource);
        int zOffset = this.zOffsetInChunk.m_214085_((RandomSource)randomSource);
        int lowestPossibleY = this.minPossibleStartY.orElse(context.f_226629_().m_141937_());
        int highestPossibleY = this.maxPossibleStartY.orElse(context.f_226629_().m_151558_());
        int lowestSurfaceYInChunk = BetterDesertTempleStructure.m_226572_((Structure.GenerationContext)context, (int)15, (int)15);
        int y = Mth.m_14045_((int)lowestSurfaceYInChunk, (int)lowestPossibleY, (int)highestPossibleY);
        BlockPos startPos = new BlockPos(chunkPos.m_151382_(xOffset), y -= Mth.m_216271_((RandomSource)context.f_226626_(), (int)0, (int)24), chunkPos.m_151391_(zOffset));
        return YungJigsawManager.assembleJigsawStructure((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)20, (BlockPos)startPos, (boolean)false, Optional.empty(), (int)128, this.maxY, this.minY);
    }

    public StructureType<?> m_213658_() {
        return StructureTypeModule.BETTER_DESERT_TEMPLE;
    }
}

