/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import mekanism.common.tile.prefab.TileEntityInternalMultiblock;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityTurbineRotor
extends TileEntityInternalMultiblock
implements Clearable {
    public int blades = 0;
    private int position = -1;
    private int radius = -1;
    public float rotationLower;
    public float rotationUpper;

    public TileEntityTurbineRotor(BlockPos pos, BlockState state) {
        super(GeneratorsBlocks.TURBINE_ROTOR, pos, state);
    }

    public void onNeighborChange(Block block, BlockPos neighborPos) {
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote()) {
            this.updateRotors();
        }
    }

    public void updateRotors() {
        TileEntityTurbineRotor rotor = this.getRotor(this.m_58899_().m_7495_());
        if (rotor == null) {
            this.scanRotors(0);
        } else {
            rotor.updateRotors();
        }
    }

    private void scanRotors(int index) {
        TileEntityTurbineRotor rotor;
        if (index != this.position) {
            this.position = index;
            this.updateRadius();
            if (this.blades > 0) {
                this.sendUpdatePacket();
            }
        }
        if ((rotor = this.getRotor(this.m_58899_().m_7494_())) != null) {
            rotor.scanRotors(index + 1);
        }
    }

    public boolean addBlade(boolean checkBelow) {
        TileEntityTurbineRotor previous;
        if (checkBelow && (previous = this.getRotor(this.m_58899_().m_7495_())) != null && previous.blades < 2) {
            return previous.addBlade(true);
        }
        if (this.blades < 2) {
            ++this.blades;
            if (this.position == -1) {
                this.scanRotors(0);
            } else {
                this.sendUpdatePacket();
            }
            return true;
        }
        TileEntityTurbineRotor next = this.getRotor(this.m_58899_().m_7494_());
        return next != null && next.addBlade(false);
    }

    public boolean removeBlade() {
        TileEntityTurbineRotor next = this.getRotor(this.m_58899_().m_7494_());
        if (next != null && next.blades > 0) {
            return next.removeBlade();
        }
        if (this.blades > 0) {
            --this.blades;
            this.sendUpdatePacket();
            return true;
        }
        next = this.getRotor(this.m_58899_().m_7495_());
        return next != null && next.removeBlade();
    }

    public void m_6211_() {
        this.blades = 0;
    }

    public int getHousedBlades() {
        return this.blades;
    }

    public int getPosition() {
        return this.position;
    }

    private void updateRadius() {
        this.radius = 1 + this.position / 4;
    }

    @Nullable
    private TileEntityTurbineRotor getRotor(BlockPos pos) {
        return (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (BlockGetter)this.m_58904_(), (BlockPos)pos);
    }

    public void blockRemoved() {
        int amount;
        super.blockRemoved();
        if (!this.isRemote() && (amount = this.getHousedBlades()) > 0) {
            Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)GeneratorsItems.TURBINE_BLADE.getItemStack(amount));
        }
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.blades = nbt.m_128451_("blades");
        this.position = nbt.m_128451_("position");
        this.updateRadius();
    }

    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("blades", this.getHousedBlades());
        nbtTags.m_128405_("position", this.getPosition());
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        if (this.blades == 0 || this.radius == -1) {
            return super.getRenderBoundingBox();
        }
        return new AABB(this.f_58858_.m_7918_(-this.radius, 0, -this.radius), this.f_58858_.m_7918_(1 + this.radius, 1, 1 + this.radius));
    }

    @NotNull
    public CompoundTag getReducedUpdateTag() {
        CompoundTag updateTag = super.getReducedUpdateTag();
        updateTag.m_128405_("blades", this.blades);
        updateTag.m_128405_("position", this.position);
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        int prevBlades = this.blades;
        int prevPosition = this.position;
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"blades", value -> {
            this.blades = value;
        });
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"position", value -> {
            this.position = value;
            this.updateRadius();
        });
        if (prevBlades != this.blades || prevPosition != prevBlades) {
            this.rotationLower = 0.0f;
            this.rotationUpper = 0.0f;
        }
    }
}

