/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fission;

import java.util.Set;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.block.attribute.AttributeStateFissionPortMode;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFissionReactorPort
extends TileEntityFissionReactorCasing {
    public TileEntityFissionReactorPort(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FISSION_REACTOR_PORT, pos, state);
    }

    @Override
    protected boolean onUpdateServer(FissionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer(multiblock);
        if (multiblock.isFormed()) {
            AttributeStateFissionPortMode.FissionPortMode mode = this.getMode();
            if (mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_COOLANT) {
                ChemicalUtil.emit((Set)multiblock.getDirectionsToEmit(this.m_58899_()), (IChemicalTank)multiblock.heatedCoolantTank, (BlockEntity)this);
            } else if (mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_WASTE) {
                ChemicalUtil.emit((Set)multiblock.getDirectionsToEmit(this.m_58899_()), (IChemicalTank)multiblock.wasteTank, (BlockEntity)this);
            }
        }
        return needsPacket;
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        BlockEntity adj;
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0 && !((adj = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.m_58899_().m_121945_(side))) instanceof TileEntityFissionReactorPort)) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER, (Direction)side.m_122424_()).resolve().orElse(null);
        }
        return null;
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return side -> ((FissionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.HEAT || type == SubstanceType.GAS || type == SubstanceType.FLUID) {
            return false;
        }
        return super.persists(type);
    }

    @ComputerMethod
    private AttributeStateFissionPortMode.FissionPortMode getMode() {
        return (AttributeStateFissionPortMode.FissionPortMode)((Object)this.m_58900_().m_61143_(AttributeStateFissionPortMode.modeProperty));
    }

    @ComputerMethod
    private void setMode(AttributeStateFissionPortMode.FissionPortMode mode) {
        if (mode != this.getMode()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(AttributeStateFissionPortMode.modeProperty, (Comparable)((Object)mode)));
        }
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            AttributeStateFissionPortMode.FissionPortMode mode = (AttributeStateFissionPortMode.FissionPortMode)this.getMode().getNext();
            this.setMode(mode);
            player.m_213846_(MekanismUtils.logFormat((Object)MekanismLang.BOILER_VALVE_MODE_CHANGE.translate(new Object[]{mode})));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, Direction side, @NotNull Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute()) {
            ((FissionReactorMultiblockData)this.getMultiblock()).triggerValveTransfer((IMultiblock)this);
        }
        return ret;
    }

    public boolean insertGasCheck(int tank, @Nullable Direction side) {
        if (this.getMode() != AttributeStateFissionPortMode.FissionPortMode.INPUT) {
            return false;
        }
        return super.insertGasCheck(tank, side);
    }

    public boolean extractGasCheck(int tank, @Nullable Direction side) {
        AttributeStateFissionPortMode.FissionPortMode mode = this.getMode();
        if (mode == AttributeStateFissionPortMode.FissionPortMode.INPUT || tank == 2 && mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_COOLANT || tank == 1 && mode == AttributeStateFissionPortMode.FissionPortMode.OUTPUT_WASTE) {
            return false;
        }
        return super.extractGasCheck(tank, side);
    }

    public int getRedstoneLevel() {
        return ((FissionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    public boolean exposesMultiblockToComputer() {
        return false;
    }

    @ComputerMethod
    private void incrementMode() {
        this.setMode((AttributeStateFissionPortMode.FissionPortMode)this.getMode().getNext());
    }

    @ComputerMethod
    private void decrementMode() {
        this.setMode((AttributeStateFissionPortMode.FissionPortMode)this.getMode().getPrevious());
    }
}

