/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.DoubleSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.listener.ConfigBasedCachedFLSupplier;
import mekanism.common.config.value.CachedValue;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.slot.FluidFuelInventorySlot;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityHeatGenerator
extends TileEntityGenerator {
    public static final int MAX_FLUID = 24000;
    private static final double THERMAL_EFFICIENCY = 0.5;
    private static final ConfigBasedCachedFLSupplier MAX_PRODUCTION = new ConfigBasedCachedFLSupplier(() -> {
        FloatingLong passiveMax = ((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationLava.get()).multiply((long)(EnumUtils.DIRECTIONS.length + 1));
        passiveMax = passiveMax.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationNether.get());
        return passiveMax.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get());
    }, new CachedValue[]{MekanismGeneratorsConfig.generators.heatGeneration, MekanismGeneratorsConfig.generators.heatGenerationLava, MekanismGeneratorsConfig.generators.heatGenerationNether});
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getLava", "getLavaCapacity", "getLavaNeeded", "getLavaFilledPercentage"})
    public BasicFluidTank lavaTank;
    private FloatingLong producingEnergy = FloatingLong.ZERO;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"})
    private BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFuelItem"})
    private FluidFuelInventorySlot fuelSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityHeatGenerator(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.HEAT_GENERATOR, pos, state, (FloatingLongSupplier)MAX_PRODUCTION);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.lavaTank = BasicFluidTank.create((int)24000, fluidStack -> MekanismTags.Fluids.LAVA_LOOKUP.contains((Object)fluidStack.getFluid()), (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.lavaTank, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.fuelSlot = FluidFuelInventorySlot.forFuel((IExtendedFluidTank)this.lavaTank, stack -> ForgeHooks.getBurnTime((ItemStack)stack, null) / 20, (Int2ObjectFunction<FluidStack>)((Int2ObjectFunction)size -> new FluidStack((Fluid)Fluids.f_76195_, size)), listener, 17, 35);
        builder.addSlot((IInventorySlot)this.fuelSlot, new RelativeSide[]{RelativeSide.FRONT, RelativeSide.LEFT, RelativeSide.BACK, RelativeSide.TOP, RelativeSide.BOTTOM});
        this.energySlot = EnergyInventorySlot.drain((IEnergyContainer)this.getEnergyContainer(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.RIGHT});
        return builder.build();
    }

    @NotNull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(() -> ((TileEntityHeatGenerator)this).getDirection());
        this.heatCapacitor = BasicHeatCapacitor.create((double)10.0, (double)5.0, (double)100.0, (DoubleSupplier)ambientTemperature, (IContentsListener)listener);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.drainContainer();
        this.fuelSlot.fillOrBurn();
        FloatingLong prev = this.getEnergyContainer().getEnergy().copyAsConst();
        this.heatCapacitor.handleHeat(this.getBoost().doubleValue());
        if (MekanismUtils.canFunction((TileEntityMekanism)this) && !this.getEnergyContainer().getNeeded().isZero()) {
            int fluidRate = MekanismGeneratorsConfig.generators.heatGenerationFluidRate.get();
            if (this.lavaTank.extract(fluidRate, Action.SIMULATE, AutomationType.INTERNAL).getAmount() == fluidRate) {
                this.setActive(true);
                this.lavaTank.extract(fluidRate, Action.EXECUTE, AutomationType.INTERNAL);
                this.heatCapacitor.handleHeat(((FloatingLong)MekanismGeneratorsConfig.generators.heatGeneration.get()).doubleValue());
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.adjacentTransfer();
        this.lastEnvironmentLoss = loss.environmentTransfer();
        this.producingEnergy = this.getEnergyContainer().getEnergy().subtract(prev);
    }

    private FloatingLong getBoost() {
        FloatingLong boost;
        if (this.f_58857_ == null) {
            return FloatingLong.ZERO;
        }
        FloatingLong passiveLavaAmount = (FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationLava.get();
        if (passiveLavaAmount.isZero()) {
            boost = FloatingLong.ZERO;
        } else {
            long lavaSides = Arrays.stream(EnumUtils.DIRECTIONS).filter(side -> {
                Optional fluidState = WorldUtils.getFluidState((BlockGetter)this.f_58857_, (BlockPos)this.f_58858_.m_121945_(side));
                return fluidState.isPresent() && ((FluidState)fluidState.get()).m_205070_(FluidTags.f_13132_);
            }).count();
            if (this.m_58900_().m_60819_().m_205070_(FluidTags.f_13132_)) {
                ++lavaSides;
            }
            boost = passiveLavaAmount.multiply(lavaSides);
        }
        if (this.f_58857_.m_6042_().f_63857_()) {
            boost = boost.plusEqual((FloatingLong)MekanismGeneratorsConfig.generators.heatGenerationNether.get());
        }
        return boost;
    }

    public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        return side == Direction.DOWN ? 0.0 : super.getInverseInsulation(capacitor, side);
    }

    @NotNull
    public HeatAPI.HeatTransfer simulate() {
        double ambientTemp = this.ambientTemperature.getAsDouble();
        double temp = this.getTotalTemperature();
        double carnotEfficiency = 1.0 - Math.min(ambientTemp, temp) / Math.max(ambientTemp, temp);
        double heatLost = 0.5 * (temp - ambientTemp);
        this.heatCapacitor.handleHeat(-heatLost);
        FloatingLong energyFromHeat = FloatingLong.create((double)(Math.abs(heatLost) * carnotEfficiency));
        this.getEnergyContainer().insert(energyFromHeat.min((FloatingLong)MAX_PRODUCTION.get()), Action.EXECUTE, AutomationType.INTERNAL);
        return super.simulate();
    }

    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (side == Direction.DOWN) {
            BlockEntity adj = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.f_58858_.m_7495_());
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER, (Direction)side.m_122424_()).resolve().orElse(null);
        }
        return null;
    }

    @ComputerMethod(nameOverride="getProductionRate")
    public FloatingLong getProducingEnergy() {
        return this.producingEnergy;
    }

    @ComputerMethod(nameOverride="getTransferLoss")
    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.lavaTank.getFluidAmount(), (long)this.lavaTank.getCapacity());
    }

    protected boolean makesComparatorDirty(@Nullable SubstanceType type) {
        return type == SubstanceType.FLUID;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableFloatingLong.create(this::getProducingEnergy, value -> {
            this.producingEnergy = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }
}

