/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CClient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlacementHelpers {
    private static final List<IPlacementHelper> helpers = new ArrayList<IPlacementHelper>();
    private static int animationTick = 0;
    private static final LerpedFloat angle = LerpedFloat.angular().chase(0.0, 0.25, LerpedFloat.Chaser.EXP);
    private static BlockPos target = null;
    private static BlockPos lastTarget = null;

    public static int register(IPlacementHelper helper) {
        helpers.add(helper);
        return helpers.size() - 1;
    }

    public static IPlacementHelper get(int id) {
        if (id < 0 || id >= helpers.size()) {
            throw new ArrayIndexOutOfBoundsException("id " + id + " for placement helper not known");
        }
        return helpers.get(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        PlacementHelpers.setTarget(null);
        PlacementHelpers.checkHelpers();
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void checkHelpers() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        if (world == null) {
            return;
        }
        if (!(mc.f_91077_ instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult ray = (BlockHitResult)mc.f_91077_;
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91074_.m_6144_()) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack heldItem = mc.f_91074_.m_21120_(hand);
            List filteredForHeldItem = helpers.stream().filter(helper -> helper.matchesItem(heldItem)).collect(Collectors.toList());
            if (filteredForHeldItem.isEmpty()) continue;
            BlockPos pos = ray.m_82425_();
            BlockState state = world.m_8055_(pos);
            List filteredForState = filteredForHeldItem.stream().filter(helper -> helper.matchesState(state)).collect(Collectors.toList());
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((Player)mc.f_91074_, (Level)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                h.renderAt(pos, state, ray, offset);
                PlacementHelpers.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(BlockPos target) {
        PlacementHelpers.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void afterRenderOverlayLayer(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.CROSSHAIR.type()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && animationTick > 0) {
            Window res = event.getWindow();
            float screenY = (float)res.m_85446_() / 2.0f;
            float screenX = (float)res.m_85445_() / 2.0f;
            float progress = PlacementHelpers.getCurrentAlpha();
            PlacementHelpers.drawDirectionIndicator(event.getPoseStack(), event.getPartialTick(), screenX, screenY, progress);
        }
    }

    public static float getCurrentAlpha() {
        return Math.min((float)animationTick / 10.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawDirectionIndicator(PoseStack ms, float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        Vec3 projTarget = VecHelper.projectToPlayerView(VecHelper.getCenterOf((Vec3i)lastTarget), partialTicks);
        Vec3 target = new Vec3(projTarget.f_82479_, projTarget.f_82480_, 0.0);
        if (projTarget.f_82481_ > 0.0) {
            target = target.m_82548_();
        }
        Vec3 norm = target.m_82541_();
        Vec3 ref = new Vec3(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(Math.acos(norm.m_82526_(ref)));
        if (norm.f_82479_ < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.setValue(targetAngle);
        }
        angle.chase(targetAngle, 0.25, LerpedFloat.Chaser.EXP);
        angle.tickChaser();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.getValue(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)AllConfigs.CLIENT.placementIndicator.get());
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementHelpers.fadedArrow(ms, centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementHelpers.textured(ms, centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(PoseStack ms, float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        ms.m_85836_();
        ms.m_85837_((double)centerX, (double)centerY, 5.0);
        ms.m_85845_(Vector3f.f_122227_.m_122240_(angle.getValue(0.0f)));
        double scale = (Double)AllConfigs.CLIENT.indicatorScale.get();
        ms.m_85841_((float)scale, (float)scale, 1.0f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        Matrix4f mat = ms.m_85850_().m_85861_();
        bufferbuilder.m_85982_(mat, 0.0f, -(10.0f + length), 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(mat, -9.0f, -3.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_85982_(mat, -6.0f, -6.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_85982_(mat, -3.0f, -8.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_85982_(mat, 0.0f, -8.5f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_85982_(mat, 3.0f, -8.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_85982_(mat, 6.0f, -6.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        bufferbuilder.m_85982_(mat, 9.0f, -3.0f, 0.0f).m_85950_(r, g, b, 0.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void textured(PoseStack ms, float centerX, float centerY, float alpha, float snappedAngle) {
        RenderSystem.m_69493_();
        AllGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        ms.m_85836_();
        ms.m_85837_((double)centerX, (double)centerY, 50.0);
        float scale = ((Double)AllConfigs.CLIENT.indicatorScale.get()).floatValue() * 0.75f;
        ms.m_85841_(scale, scale, 1.0f);
        ms.m_85841_(12.0f, 12.0f, 1.0f);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        Matrix4f mat = ms.m_85850_().m_85861_();
        buffer.m_85982_(mat, -1.0f, -1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx, ty).m_5752_();
        buffer.m_85982_(mat, -1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx, ty + th).m_5752_();
        buffer.m_85982_(mat, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx + tw, ty + th).m_5752_();
        buffer.m_85982_(mat, 1.0f, -1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, alpha).m_7421_(tx + tw, ty).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        ms.m_85849_();
    }
}

