/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin;

import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationMarker;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientboundMapItemDataPacket.class}, priority=826)
public class ClientboundMapItemDataPacketMixin {
    @Shadow
    @Final
    private List<MapDecoration> f_132419_;
    @Unique
    private int[] stationIndices;

    @Inject(method={"<init>(IBZLjava/util/Collection;Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData$MapPatch;)V"}, at={@At(value="RETURN")})
    private void onInit(int mapId, byte scale, boolean locked, @Nullable Collection<MapDecoration> decorations, @Nullable MapItemSavedData.MapPatch colorPatch, CallbackInfo ci) {
        this.stationIndices = ClientboundMapItemDataPacketMixin.getStationIndices(this.f_132419_);
    }

    private static int[] getStationIndices(List<MapDecoration> decorations) {
        if (decorations == null) {
            return new int[0];
        }
        IntArrayList indices = new IntArrayList();
        for (int i = 0; i < decorations.size(); ++i) {
            MapDecoration decoration = decorations.get(i);
            if (!(decoration instanceof StationMarker.Decoration)) continue;
            indices.add(i);
        }
        return indices.toIntArray();
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void onInit(FriendlyByteBuf buf, CallbackInfo ci) {
        this.stationIndices = buf.m_130100_();
        if (this.f_132419_ != null) {
            for (int i : this.stationIndices) {
                if (i < 0 || i >= this.f_132419_.size()) continue;
                MapDecoration decoration = this.f_132419_.get(i);
                this.f_132419_.set(i, StationMarker.Decoration.from(decoration));
            }
        }
    }

    @Inject(method={"write(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void onWrite(FriendlyByteBuf buf, CallbackInfo ci) {
        buf.m_130089_(this.stationIndices);
    }
}

