/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.GraphLocation;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageBogey;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Navigation;
import com.simibubi.create.content.logistics.trains.entity.TrainIconType;
import com.simibubi.create.content.logistics.trains.entity.TrainMigration;
import com.simibubi.create.content.logistics.trains.entity.TrainPacket;
import com.simibubi.create.content.logistics.trains.entity.TrainStatus;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.observer.TrackObserver;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBoundary;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroup;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleRuntime;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class Train {
    public double speed = 0.0;
    public double targetSpeed = 0.0;
    public Double speedBeforeStall = null;
    public int carriageWaitingForChunks = -1;
    public double throttle = 1.0;
    public boolean honk = false;
    public UUID id;
    public UUID owner;
    public TrackGraph graph;
    public Navigation navigation;
    public ScheduleRuntime runtime;
    public TrainIconType icon;
    public Component name;
    public TrainStatus status;
    public boolean invalid;
    public TravellingPoint.SteerDirection manualSteer;
    public boolean manualTick;
    public UUID currentStation;
    public boolean currentlyBackwards;
    public boolean doubleEnded;
    public List<Carriage> carriages;
    public List<Integer> carriageSpacing;
    public boolean updateSignalBlocks;
    public Map<UUID, UUID> occupiedSignalBlocks;
    public Set<UUID> reservedSignalBlocks;
    public Set<UUID> occupiedObservers;
    public Map<UUID, Pair<Integer, Boolean>> cachedObserverFiltering;
    List<TrainMigration> migratingPoints;
    public int migrationCooldown;
    public boolean derailed;
    public int fuelTicks;
    public int honkTicks;
    public Boolean lowHonk;
    public int honkPitch;
    public float accumulatedSteamRelease;
    int tickOffset;
    double[] stress;
    public Player backwardsDriver;

    public Train(UUID id, UUID owner, TrackGraph graph, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded) {
        this.id = id;
        this.owner = owner;
        this.graph = graph;
        this.carriages = carriages;
        this.carriageSpacing = carriageSpacing;
        this.icon = TrainIconType.getDefault();
        this.stress = new double[carriageSpacing.size()];
        this.name = Lang.translateDirect("train.unnamed", new Object[0]);
        this.status = new TrainStatus(this);
        this.doubleEnded = doubleEnded;
        carriages.forEach(c -> c.setTrain(this));
        this.navigation = new Navigation(this);
        this.runtime = new ScheduleRuntime(this);
        this.migratingPoints = new ArrayList<TrainMigration>();
        this.currentStation = null;
        this.manualSteer = TravellingPoint.SteerDirection.NONE;
        this.occupiedSignalBlocks = new HashMap<UUID, UUID>();
        this.reservedSignalBlocks = new HashSet<UUID>();
        this.occupiedObservers = new HashSet<UUID>();
        this.cachedObserverFiltering = new HashMap<UUID, Pair<Integer, Boolean>>();
        this.tickOffset = Create.RANDOM.nextInt(100);
    }

    public void earlyTick(Level level) {
        this.status.tick(level);
        if (this.graph == null && !this.migratingPoints.isEmpty()) {
            this.reattachToTracks(level);
        }
        if (this.graph == null) {
            this.addToSignalGroups(this.occupiedSignalBlocks.keySet());
            return;
        }
        if (this.updateSignalBlocks) {
            this.updateSignalBlocks = false;
            this.collectInitiallyOccupiedSignalBlocks();
        }
        this.addToSignalGroups(this.occupiedSignalBlocks.keySet());
        this.addToSignalGroups(this.reservedSignalBlocks);
        if (this.occupiedObservers.isEmpty()) {
            return;
        }
        this.tickOccupiedObservers(level);
    }

    private void tickOccupiedObservers(Level level) {
        int storageVersion = 0;
        for (Carriage carriage : this.carriages) {
            storageVersion += carriage.storage.getVersion();
        }
        for (UUID uuid : this.occupiedObservers) {
            TrackObserver observer = this.graph.getPoint(EdgePointType.OBSERVER, uuid);
            if (observer == null) continue;
            ItemStack filter = observer.getFilter();
            if (filter.m_41619_()) {
                observer.keepAlive(this);
                continue;
            }
            Pair cachedMatch = this.cachedObserverFiltering.computeIfAbsent(uuid, $ -> Pair.of(-1, false));
            boolean shouldActivate = (Boolean)cachedMatch.getSecond();
            if ((Integer)cachedMatch.getFirst() == storageVersion) {
                if (!shouldActivate) continue;
                observer.keepAlive(this);
                continue;
            }
            shouldActivate = false;
            for (Carriage carriage : this.carriages) {
                IFluidHandler tank;
                if (shouldActivate) break;
                IItemHandlerModifiable inv = carriage.storage.getItems();
                if (inv != null) {
                    for (int slot = 0; slot < inv.getSlots() && !shouldActivate; ++slot) {
                        ItemStack extractItem = inv.extractItem(slot, 1, true);
                        if (extractItem.m_41619_()) continue;
                        shouldActivate |= FilterItem.test(level, extractItem, filter);
                    }
                }
                if ((tank = carriage.storage.getFluids()) == null) continue;
                for (int slot = 0; slot < tank.getTanks() && !shouldActivate; ++slot) {
                    FluidStack drain = tank.drain(1, IFluidHandler.FluidAction.SIMULATE);
                    if (drain.isEmpty()) continue;
                    shouldActivate |= FilterItem.test(level, drain, filter);
                }
            }
            this.cachedObserverFiltering.put(uuid, Pair.of(storageVersion, shouldActivate));
            if (!shouldActivate) continue;
            observer.keepAlive(this);
        }
    }

    private void addToSignalGroups(Collection<UUID> groups) {
        Map<UUID, SignalEdgeGroup> groupMap = Create.RAILWAYS.signalEdgeGroups;
        Iterator<UUID> iterator = groups.iterator();
        while (iterator.hasNext()) {
            SignalEdgeGroup signalEdgeGroup = groupMap.get(iterator.next());
            if (signalEdgeGroup == null) {
                iterator.remove();
                continue;
            }
            signalEdgeGroup.trains.add(this);
        }
    }

    public void tick(Level level) {
        Create.RAILWAYS.markTracksDirty();
        if (this.graph == null) {
            this.carriages.forEach(c -> c.manageEntities(level));
            this.updateConductors();
            return;
        }
        this.updateConductors();
        this.runtime.tick(level);
        this.navigation.tick(level);
        this.tickPassiveSlowdown();
        if (this.derailed) {
            this.tickDerailedSlowdown();
        }
        double distance = this.speed;
        Carriage previousCarriage = null;
        int carriageCount = this.carriages.size();
        boolean stalled = false;
        double maxStress = 0.0;
        if (this.carriageWaitingForChunks != -1) {
            distance = 0.0;
        }
        for (int i = 0; i < carriageCount; ++i) {
            Carriage carriage = this.carriages.get(i);
            if (previousCarriage != null) {
                int target = this.carriageSpacing.get(i - 1);
                double actual = target;
                TravellingPoint leadingPoint = carriage.getLeadingPoint();
                TravellingPoint trailingPoint = previousCarriage.getTrailingPoint();
                int entries = 0;
                double total = 0.0;
                if (leadingPoint.node1 != null && trailingPoint.node1 != null) {
                    ResourceKey<Level> d1 = leadingPoint.node1.getLocation().dimension;
                    ResourceKey<Level> d2 = trailingPoint.node1.getLocation().dimension;
                    for (boolean b : Iterate.trueAndFalse) {
                        ResourceKey<Level> d;
                        ResourceKey<Level> resourceKey = d = b ? d1 : d2;
                        if (!b && d1.equals(d2) || !d1.equals(d2)) continue;
                        Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensionalIfPresent(d);
                        Carriage.DimensionalCarriageEntity dimensional2 = previousCarriage.getDimensionalIfPresent(d);
                        if (dimensional == null || dimensional2 == null) continue;
                        Vec3 leadingAnchor = dimensional.leadingAnchor();
                        Vec3 trailingAnchor = dimensional2.trailingAnchor();
                        if (leadingAnchor == null || trailingAnchor == null) continue;
                        total += leadingAnchor.m_82554_(trailingAnchor);
                        ++entries;
                    }
                }
                if (entries > 0) {
                    actual = total / (double)entries;
                }
                this.stress[i - 1] = (double)target - actual;
                maxStress = Math.max(maxStress, Math.abs((double)target - actual));
            }
            previousCarriage = carriage;
            if (!carriage.stalled) continue;
            if (this.speedBeforeStall == null) {
                this.speedBeforeStall = this.speed;
            }
            distance = 0.0;
            this.speed = 0.0;
            stalled = true;
        }
        if (!stalled && this.speedBeforeStall != null) {
            this.speed = Mth.m_14008_((double)this.speedBeforeStall, (double)-1.0, (double)1.0);
            this.speedBeforeStall = null;
        }
        boolean approachingStation = this.navigation.distanceToDestination < 5.0;
        double leadingModifier = approachingStation ? 0.75 : 0.5;
        double trailingModifier = approachingStation ? 0.0 : 0.125;
        boolean blocked = false;
        boolean iterateFromBack = this.speed < 0.0;
        for (int index = 0; index < carriageCount; ++index) {
            boolean last;
            double leadingStress;
            int i;
            int n = i = iterateFromBack ? carriageCount - 1 - index : index;
            double d = i == 0 ? 0.0 : (leadingStress = this.stress[i - 1] * -(iterateFromBack ? trailingModifier : leadingModifier));
            double trailingStress = i == this.stress.length ? 0.0 : this.stress[i] * (iterateFromBack ? leadingModifier : trailingModifier);
            Carriage carriage = this.carriages.get(i);
            TravellingPoint toFollowForward = i == 0 ? null : this.carriages.get(i - 1).getTrailingPoint();
            TravellingPoint toFollowBackward = i == carriageCount - 1 ? null : this.carriages.get(i + 1).getLeadingPoint();
            double totalStress = this.derailed ? 0.0 : leadingStress + trailingStress;
            boolean first = i == 0;
            boolean bl = last = i == carriageCount - 1;
            int carriageType = first ? (last ? 3 : 0) : (last ? 2 : 1);
            double actualDistance = carriage.travel(level, this.graph, distance + totalStress, toFollowForward, toFollowBackward, carriageType);
            blocked |= carriage.blocked;
            boolean onTwoBogeys = carriage.isOnTwoBogeys();
            maxStress = Math.max(maxStress, onTwoBogeys ? (double)carriage.bogeySpacing - carriage.getAnchorDiff() : 0.0);
            maxStress = Math.max(maxStress, carriage.leadingBogey().getStress());
            if (onTwoBogeys) {
                maxStress = Math.max(maxStress, carriage.trailingBogey().getStress());
            }
            if (index != 0) continue;
            distance = actualDistance;
            this.collideWithOtherTrains(level, carriage);
            this.backwardsDriver = null;
            if (this.graph != null) continue;
            return;
        }
        if (blocked) {
            this.speed = 0.0;
            this.navigation.cancelNavigation();
            this.runtime.tick(level);
            this.status.endOfTrack();
        } else if (maxStress > 4.0) {
            this.speed = 0.0;
            this.navigation.cancelNavigation();
            this.runtime.tick(level);
            this.derailed = true;
            this.status.highStress();
        } else if (this.speed != 0.0) {
            this.status.trackOK();
        }
        this.updateNavigationTarget(distance);
    }

    public TravellingPoint.IEdgePointListener frontSignalListener() {
        return (distance, couple) -> {
            Object patt13842$temp = couple.getFirst();
            if (patt13842$temp instanceof GlobalStation) {
                GlobalStation station = (GlobalStation)patt13842$temp;
                if (!station.canApproachFrom((TrackNode)((Couple)couple.getSecond()).getSecond()) || this.navigation.destination != station) {
                    return false;
                }
                this.speed = 0.0;
                this.navigation.distanceToDestination = 0.0;
                this.navigation.currentPath.clear();
                this.arriveAt(this.navigation.destination);
                this.navigation.destination = null;
                return true;
            }
            Object patt14231$temp = couple.getFirst();
            if (patt14231$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt14231$temp;
                this.occupiedObservers.add(observer.getId());
                return false;
            }
            Object patt14368$temp = couple.getFirst();
            if (!(patt14368$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt14368$temp;
            if (this.navigation.waitingForSignal != null && this.navigation.waitingForSignal.getFirst().equals(signal.getId())) {
                this.speed = 0.0;
                this.navigation.distanceToSignal = 0.0;
                return true;
            }
            UUID groupId = signal.getGroup((TrackNode)((Couple)couple.getSecond()).getSecond());
            SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
            if (signalEdgeGroup == null) {
                return false;
            }
            if ((this.runtime.getSchedule() == null || this.runtime.paused) && signalEdgeGroup.isOccupiedUnless(this)) {
                this.carriages.forEach(c -> c.forEachPresentEntity(cce -> cce.getControllingPlayer().ifPresent(uuid -> AllAdvancements.RED_SIGNAL.awardTo(cce.f_19853_.m_46003_(uuid)))));
            }
            signalEdgeGroup.reserved = signal;
            this.occupy(groupId, signal.id);
            return false;
        };
    }

    public void cancelStall() {
        this.speedBeforeStall = null;
        this.carriages.forEach(c -> {
            c.stalled = false;
            c.forEachPresentEntity(cce -> cce.getContraption().getActors().forEach(pair -> {
                MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((StructureTemplate.StructureBlockInfo)pair.getKey()).f_74676_);
                if (behaviour != null) {
                    behaviour.cancelStall((MovementContext)pair.getValue());
                }
            }));
        });
    }

    private boolean occupy(UUID groupId, @Nullable UUID boundaryId) {
        this.reservedSignalBlocks.remove(groupId);
        if (boundaryId != null && this.occupiedSignalBlocks.containsKey(groupId) && boundaryId.equals(this.occupiedSignalBlocks.get(groupId))) {
            return false;
        }
        return this.occupiedSignalBlocks.put(groupId, boundaryId) == null;
    }

    public TravellingPoint.IEdgePointListener backSignalListener() {
        return (distance, couple) -> {
            Object patt16062$temp = couple.getFirst();
            if (patt16062$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt16062$temp;
                this.occupiedObservers.remove(observer.getId());
                this.cachedObserverFiltering.remove(observer.getId());
                return false;
            }
            Object patt16255$temp = couple.getFirst();
            if (!(patt16255$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt16255$temp;
            UUID groupId = signal.getGroup((TrackNode)((Couple)couple.getSecond()).getFirst());
            this.occupiedSignalBlocks.remove(groupId);
            return false;
        };
    }

    private void updateNavigationTarget(double distance) {
        GlobalStation preferredDestination;
        if (this.navigation.destination == null) {
            return;
        }
        Pair<UUID, Boolean> blockingSignal = this.navigation.waitingForSignal;
        boolean fullRefresh = this.navigation.distanceToDestination > 100.0 && this.navigation.distanceToDestination % 100.0 > 20.0;
        boolean signalRefresh = blockingSignal != null && this.navigation.distanceToSignal % 50.0 > 5.0;
        boolean partialRefresh = this.navigation.distanceToDestination < 100.0 && this.navigation.distanceToDestination % 50.0 > 5.0;
        double toSubstract = this.navigation.destinationBehindTrain ? -distance : distance;
        boolean navigatingManually = this.runtime.paused;
        this.navigation.distanceToDestination -= toSubstract;
        if (blockingSignal != null) {
            this.navigation.distanceToSignal -= toSubstract;
            signalRefresh &= this.navigation.distanceToSignal % 50.0 < 5.0;
        }
        fullRefresh &= this.navigation.distanceToDestination % 100.0 <= 20.0;
        partialRefresh &= this.navigation.distanceToDestination % 50.0 <= 5.0;
        if (blockingSignal != null && this.navigation.ticksWaitingForSignal % 100 == 50) {
            SignalBoundary signal = this.graph.getPoint(EdgePointType.SIGNAL, blockingSignal.getFirst());
            fullRefresh |= signal != null && signal.types.get(blockingSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL;
        }
        if (signalRefresh) {
            this.navigation.waitingForSignal = null;
        }
        if (!fullRefresh && !partialRefresh) {
            return;
        }
        if (!this.reservedSignalBlocks.isEmpty()) {
            return;
        }
        GlobalStation destination = this.navigation.destination;
        if (!navigatingManually && fullRefresh && (preferredDestination = this.runtime.startCurrentInstruction()) != null) {
            destination = preferredDestination;
        }
        this.navigation.startNavigation(destination, navigatingManually ? -1.0 : Double.MAX_VALUE, false);
    }

    private void tickDerailedSlowdown() {
        this.speed /= 3.0;
        if (Mth.m_14082_((double)this.speed, (double)0.0)) {
            this.speed = 0.0;
        }
    }

    private void tickPassiveSlowdown() {
        if (!this.manualTick && this.navigation.destination == null && this.speed != 0.0) {
            double acceleration = this.acceleration();
            this.speed = this.speed > 0.0 ? Math.max(this.speed - acceleration, 0.0) : Math.min(this.speed + acceleration, 0.0);
        }
        this.manualTick = false;
    }

    private void updateConductors() {
        for (Carriage carriage : this.carriages) {
            carriage.updateConductors();
        }
    }

    public boolean hasForwardConductor() {
        for (Carriage carriage : this.carriages) {
            if (!((Boolean)carriage.presentConductors.getFirst()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBackwardConductor() {
        for (Carriage carriage : this.carriages) {
            if (!((Boolean)carriage.presentConductors.getSecond()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void collideWithOtherTrains(Level level, Carriage carriage) {
        Vec3 end;
        if (this.derailed) {
            return;
        }
        TravellingPoint trailingPoint = carriage.getTrailingPoint();
        TravellingPoint leadingPoint = carriage.getLeadingPoint();
        if (leadingPoint.node1 == null || trailingPoint.node1 == null) {
            return;
        }
        ResourceKey<Level> dimension = leadingPoint.node1.getLocation().dimension;
        if (!dimension.equals(trailingPoint.node1.getLocation().dimension)) {
            return;
        }
        Vec3 start = (this.speed < 0.0 ? trailingPoint : leadingPoint).getPosition();
        Pair<Train, Vec3> collision = Train.findCollidingTrain(level, start, end = (this.speed < 0.0 ? leadingPoint : trailingPoint).getPosition(), this, dimension);
        if (collision == null) {
            return;
        }
        Train train = collision.getFirst();
        double combinedSpeed = Math.abs(this.speed) + Math.abs(train.speed);
        if (combinedSpeed > (double)0.2f) {
            Vec3 v = collision.getSecond();
            level.m_46511_(null, v.f_82479_, v.f_82480_, v.f_82481_, (float)Math.min(3.0 * combinedSpeed, 5.0), Explosion.BlockInteraction.NONE);
        }
        this.crash();
        train.crash();
    }

    public static Pair<Train, Vec3> findCollidingTrain(Level level, Vec3 start, Vec3 end, Train ignore, ResourceKey<Level> dimension) {
        for (Train train : Create.RAILWAYS.sided((LevelAccessor)level).trains.values()) {
            if (train == ignore) continue;
            Vec3 diff = end.m_82546_(start);
            Vec3 lastPoint = null;
            for (Carriage otherCarriage : train.carriages) {
                for (boolean betweenBits : Iterate.trueAndFalse) {
                    Vec3 normedDiff2;
                    ResourceKey<Level> otherDimension;
                    if (betweenBits && lastPoint == null) continue;
                    TravellingPoint otherLeading = otherCarriage.getLeadingPoint();
                    TravellingPoint otherTrailing = otherCarriage.getTrailingPoint();
                    if (otherLeading.edge == null || otherTrailing.edge == null || !(otherDimension = otherLeading.node1.getLocation().dimension).equals(otherTrailing.node1.getLocation().dimension) || !otherDimension.equals(dimension)) continue;
                    Vec3 start2 = otherLeading.getPosition();
                    Vec3 end2 = otherTrailing.getPosition();
                    if (betweenBits) {
                        end2 = start2;
                        start2 = lastPoint;
                    }
                    lastPoint = end2;
                    if ((end.f_82480_ < end2.f_82480_ - 3.0 || end2.f_82480_ < end.f_82480_ - 3.0) && (start.f_82480_ < start2.f_82480_ - 3.0 || start2.f_82480_ < start.f_82480_ - 3.0)) continue;
                    Vec3 diff2 = end2.m_82546_(start2);
                    Vec3 normedDiff = diff.m_82541_();
                    double[] intersect = VecHelper.intersect(start, start2, normedDiff, normedDiff2 = diff2.m_82541_(), Direction.Axis.Y);
                    if (intersect == null) {
                        Vec3 intersectSphere = VecHelper.intersectSphere(start2, normedDiff2, start, 0.125);
                        if (intersectSphere == null || !Mth.m_14082_((double)normedDiff2.m_82526_(intersectSphere.m_82546_(start2).m_82541_()), (double)1.0)) continue;
                        intersect = new double[]{intersectSphere.m_82554_(start) - 0.125, intersectSphere.m_82554_(start2) - 0.125};
                    }
                    if (intersect[0] > diff.m_82553_() || intersect[1] > diff2.m_82553_() || intersect[0] < 0.0 || intersect[1] < 0.0) continue;
                    return Pair.of(train, start.m_82549_(normedDiff.m_82490_(intersect[0])));
                }
            }
        }
        return null;
    }

    public void crash() {
        this.navigation.cancelNavigation();
        if (this.derailed) {
            return;
        }
        this.speed = -Mth.m_14008_((double)this.speed, (double)-0.5, (double)0.5);
        this.derailed = true;
        this.graph = null;
        this.status.crash();
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.m_146897_().forEach(entity -> {
                if (!(entity instanceof Player)) {
                    return;
                }
                Player p = (Player)entity;
                Optional<UUID> controllingPlayer = e.getControllingPlayer();
                if (controllingPlayer.isPresent() && controllingPlayer.get().equals(p.m_20148_())) {
                    return;
                }
                AllAdvancements.TRAIN_CRASH.awardTo(p);
            }));
        }
        if (this.backwardsDriver != null) {
            AllAdvancements.TRAIN_CRASH_BACKWARDS.awardTo(this.backwardsDriver);
        }
    }

    public boolean disassemble(Direction assemblyDirection, BlockPos pos) {
        if (!this.canDisassemble()) {
            return false;
        }
        int offset = 1;
        boolean backwards = this.currentlyBackwards;
        Level level = null;
        for (int i = 0; i < this.carriages.size(); ++i) {
            Carriage carriage = this.carriages.get(backwards ? this.carriages.size() - i - 1 : i);
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) {
                return false;
            }
            level = entity.f_19853_;
            Contraption contraption = entity.getContraption();
            if (contraption instanceof CarriageContraption) {
                CarriageContraption cc = (CarriageContraption)contraption;
                cc.returnStorageForDisassembly(carriage.storage);
            }
            entity.m_146884_(Vec3.m_82528_((Vec3i)pos.m_5484_(assemblyDirection, backwards ? offset + carriage.bogeySpacing : offset)));
            entity.disassemble();
            offset += carriage.bogeySpacing;
            if (i >= this.carriageSpacing.size()) continue;
            offset += this.carriageSpacing.get(backwards ? this.carriageSpacing.size() - i - 1 : i).intValue();
        }
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            currentStation.cancelReservation(this);
            BlockPos tilePos = currentStation.getTilePos();
            BlockEntity blockEntity = level.m_7702_(tilePos);
            if (blockEntity instanceof StationTileEntity) {
                StationTileEntity ste = (StationTileEntity)blockEntity;
                ste.lastDisassembledTrainName = this.name.m_6881_();
            }
        }
        Create.RAILWAYS.removeTrain(this.id);
        AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new TrainPacket(this, false));
        return true;
    }

    public boolean canDisassemble() {
        for (Carriage carriage : this.carriages) {
            if (carriage.presentInMultipleDimensions()) {
                return false;
            }
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) {
                return false;
            }
            if (!Mth.m_14033_((float)entity.pitch, (float)0.0f)) {
                return false;
            }
            if (Mth.m_14033_((float)((entity.yaw % 90.0f + 360.0f) % 90.0f), (float)0.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean isTravellingOn(TrackNode node) {
        MutableBoolean affected = new MutableBoolean(false);
        this.forEachTravellingPoint(tp -> {
            if (tp.node1 == node || tp.node2 == node) {
                affected.setTrue();
            }
        });
        return affected.booleanValue();
    }

    public void detachFromTracks() {
        this.migratingPoints.clear();
        this.navigation.cancelNavigation();
        this.forEachTravellingPoint(tp -> this.migratingPoints.add(new TrainMigration((TravellingPoint)tp)));
        this.graph = null;
    }

    public void forEachTravellingPoint(Consumer<TravellingPoint> callback) {
        for (Carriage c : this.carriages) {
            c.leadingBogey().points.forEach(callback::accept);
            if (!c.isOnTwoBogeys()) continue;
            c.trailingBogey().points.forEach(callback::accept);
        }
    }

    public void forEachTravellingPointBackwards(BiConsumer<TravellingPoint, Double> callback) {
        double lastWheelOffset = 0.0;
        for (int i = 0; i < this.carriages.size(); ++i) {
            int index = this.carriages.size() - i - 1;
            Carriage carriage = this.carriages.get(index);
            CarriageBogey trailingBogey = carriage.trailingBogey();
            double trailSpacing = trailingBogey.type.getWheelPointSpacing();
            callback.accept(trailingBogey.trailing(), i == 0 ? 0.0 : (double)this.carriageSpacing.get(index).intValue() - lastWheelOffset - trailSpacing / 2.0);
            callback.accept(trailingBogey.leading(), trailSpacing);
            lastWheelOffset = trailSpacing / 2.0;
            if (!carriage.isOnTwoBogeys()) continue;
            CarriageBogey leadingBogey = carriage.leadingBogey();
            double leadSpacing = carriage.leadingBogey().type.getWheelPointSpacing();
            callback.accept(leadingBogey.trailing(), (double)carriage.bogeySpacing - lastWheelOffset - leadSpacing / 2.0);
            callback.accept(trailingBogey.leading(), leadSpacing);
            lastWheelOffset = leadSpacing / 2.0;
        }
    }

    public void reattachToTracks(Level level) {
        if (this.migrationCooldown > 0) {
            --this.migrationCooldown;
            return;
        }
        HashSet<Map.Entry<UUID, TrackGraph>> entrySet = new HashSet<Map.Entry<UUID, TrackGraph>>(Create.RAILWAYS.trackNetworks.entrySet());
        HashMap<UUID, List> successfulMigrations = new HashMap<UUID, List>();
        for (TrainMigration md : this.migratingPoints) {
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                GraphLocation gl = md.tryMigratingTo((TrackGraph)entry.getValue());
                if (gl == null) {
                    iterator.remove();
                    continue;
                }
                successfulMigrations.computeIfAbsent((UUID)entry.getKey(), uuid -> new ArrayList()).add(gl);
            }
        }
        if (entrySet.isEmpty()) {
            this.migrationCooldown = 40;
            this.status.failedMigration();
            this.derailed = true;
            return;
        }
        Iterator<TrainMigration> iterator = entrySet.iterator();
        if (iterator.hasNext()) {
            GlobalStation currentStation;
            Map.Entry entry = (Map.Entry)((Object)iterator.next());
            this.graph = (TrackGraph)entry.getValue();
            List locations = (List)successfulMigrations.get(entry.getKey());
            this.forEachTravellingPoint(tp -> tp.migrateTo(locations));
            this.migratingPoints.clear();
            if (this.derailed) {
                this.status.successfulMigration();
            }
            this.derailed = false;
            if (this.runtime.getSchedule() != null && this.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                this.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
            }
            if ((currentStation = this.getCurrentStation()) != null) {
                currentStation.reserveFor(this);
            }
            this.updateSignalBlocks = true;
            this.migrationCooldown = 0;
            return;
        }
    }

    public int getTotalLength() {
        int length = 0;
        for (int i = 0; i < this.carriages.size(); ++i) {
            Carriage carriage = this.carriages.get(i);
            if (i == 0) {
                length = (int)((double)length + carriage.leadingBogey().type.getWheelPointSpacing() / 2.0);
            }
            if (i == this.carriages.size() - 1) {
                length = (int)((double)length + carriage.trailingBogey().type.getWheelPointSpacing() / 2.0);
            }
            length += carriage.bogeySpacing;
            if (i >= this.carriageSpacing.size()) continue;
            length += this.carriageSpacing.get(i).intValue();
        }
        return length;
    }

    public void leaveStation() {
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            currentStation.trainDeparted(this);
        }
        this.currentStation = null;
    }

    public void arriveAt(GlobalStation station) {
        this.setCurrentStation(station);
        this.reservedSignalBlocks.clear();
        this.runtime.destinationReached();
    }

    public void setCurrentStation(GlobalStation station) {
        this.currentStation = station.id;
    }

    public GlobalStation getCurrentStation() {
        if (this.currentStation == null) {
            return null;
        }
        if (this.graph == null) {
            return null;
        }
        return this.graph.getPoint(EdgePointType.STATION, this.currentStation);
    }

    @Nullable
    public LivingEntity getOwner(Level level) {
        try {
            UUID uuid = this.owner;
            return uuid == null ? null : level.m_7654_().m_6846_().m_11259_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void approachTargetSpeed(float accelerationMod) {
        double actualTarget = this.targetSpeed;
        if (Mth.m_14082_((double)actualTarget, (double)this.speed)) {
            return;
        }
        if (this.manualTick) {
            this.leaveStation();
        }
        double acceleration = this.acceleration();
        if (this.speed < actualTarget) {
            this.speed = Math.min(this.speed + acceleration * (double)accelerationMod, actualTarget);
        } else if (this.speed > actualTarget) {
            this.speed = Math.max(this.speed - acceleration * (double)accelerationMod, actualTarget);
        }
    }

    public void collectInitiallyOccupiedSignalBlocks() {
        TravellingPoint trailingPoint = this.carriages.get(this.carriages.size() - 1).getTrailingPoint();
        TrackNode node1 = trailingPoint.node1;
        TrackNode node2 = trailingPoint.node2;
        TrackEdge edge = trailingPoint.edge;
        double position = trailingPoint.position;
        EdgeData signalData = edge.getEdgeData();
        this.occupiedSignalBlocks.clear();
        this.reservedSignalBlocks.clear();
        this.occupiedObservers.clear();
        this.cachedObserverFiltering.clear();
        TravellingPoint signalScout = new TravellingPoint(node1, node2, edge, position);
        Map<UUID, SignalEdgeGroup> allGroups = Create.RAILWAYS.signalEdgeGroups;
        MutableObject prevGroup = new MutableObject(null);
        if (signalData.hasSignalBoundaries()) {
            SignalBoundary nextBoundary = signalData.next(EdgePointType.SIGNAL, position);
            if (nextBoundary == null) {
                UUID group;
                double d2 = 0.0;
                SignalBoundary prev = null;
                SignalBoundary current = signalData.next(EdgePointType.SIGNAL, 0.0);
                while (current != null) {
                    prev = current;
                    d2 = current.getLocationOn(edge);
                    current = signalData.next(EdgePointType.SIGNAL, d2);
                }
                if (prev != null && Create.RAILWAYS.signalEdgeGroups.containsKey(group = prev.getGroup(node2))) {
                    this.occupy(group, null);
                    prevGroup.setValue((Object)group);
                }
            } else {
                UUID group = nextBoundary.getGroup(node1);
                if (Create.RAILWAYS.signalEdgeGroups.containsKey(group)) {
                    this.occupy(group, null);
                    prevGroup.setValue((Object)group);
                }
            }
        } else {
            UUID groupId = signalData.getEffectiveEdgeGroupId(this.graph);
            if (allGroups.containsKey(groupId)) {
                this.occupy(groupId, null);
                prevGroup.setValue((Object)groupId);
            }
        }
        this.forEachTravellingPointBackwards((tp, d) -> signalScout.travel(this.graph, (double)d, signalScout.follow((TravellingPoint)tp), (distance, couple) -> {
            Object patt32131$temp = couple.getFirst();
            if (patt32131$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt32131$temp;
                this.occupiedObservers.add(observer.getId());
                return false;
            }
            Object patt32270$temp = couple.getFirst();
            if (!(patt32270$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt32270$temp;
            ((Couple)couple.getSecond()).map(signal::getGroup).forEach(id -> {
                if (!Create.RAILWAYS.signalEdgeGroups.containsKey(id)) {
                    return;
                }
                if (id.equals(prevGroup.getValue())) {
                    return;
                }
                this.occupy((UUID)id, null);
                prevGroup.setValue(id);
            });
            return false;
        }, signalScout.ignoreTurns()));
    }

    public boolean shouldCarriageSyncThisTick(long gameTicks, int updateInterval) {
        return (gameTicks + (long)this.tickOffset) % (long)updateInterval == 0L;
    }

    public Couple<Couple<TrackNode>> getEndpointEdges() {
        return Couple.create(this.carriages.get(0).getLeadingPoint(), this.carriages.get(this.carriages.size() - 1).getTrailingPoint()).map(tp -> Couple.create(tp.node1, tp.node2));
    }

    public int getNavigationPenalty() {
        if (this.manualTick) {
            return 200;
        }
        if (this.runtime.getSchedule() == null || this.runtime.paused) {
            return 700;
        }
        if (this.navigation.waitingForSignal != null && this.navigation.ticksWaitingForSignal > 0) {
            return 50 + Math.min(this.navigation.ticksWaitingForSignal / 20, 1000);
        }
        if (this.navigation.destination != null && this.navigation.distanceToDestination < 50.0 || this.navigation.distanceToSignal < 20.0) {
            return 50;
        }
        return 25;
    }

    public void burnFuel() {
        if (this.fuelTicks > 0) {
            --this.fuelTicks;
            return;
        }
        boolean iterateFromBack = this.speed < 0.0;
        int carriageCount = this.carriages.size();
        for (int index = 0; index < carriageCount; ++index) {
            int i = iterateFromBack ? carriageCount - 1 - index : index;
            Carriage carriage = this.carriages.get(i);
            IItemHandlerModifiable fuelItems = carriage.storage.getFuelItems();
            if (fuelItems == null) continue;
            for (int slot = 0; slot < fuelItems.getSlots(); ++slot) {
                ItemStack stack = fuelItems.extractItem(slot, 1, true);
                int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, null);
                if (burnTime <= 0) continue;
                stack = fuelItems.extractItem(slot, 1, false);
                this.fuelTicks += burnTime * stack.m_41613_();
                ItemStack containerItem = stack.getCraftingRemainingItem();
                if (!containerItem.m_41619_()) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)fuelItems, (ItemStack)containerItem, (boolean)false);
                }
                return;
            }
        }
    }

    public float maxSpeed() {
        return (this.fuelTicks > 0 ? AllConfigs.SERVER.trains.poweredTrainTopSpeed.getF() : AllConfigs.SERVER.trains.trainTopSpeed.getF()) / 20.0f;
    }

    public float maxTurnSpeed() {
        return (this.fuelTicks > 0 ? AllConfigs.SERVER.trains.poweredTrainTurningTopSpeed.getF() : AllConfigs.SERVER.trains.trainTurningTopSpeed.getF()) / 20.0f;
    }

    public float acceleration() {
        return (this.fuelTicks > 0 ? AllConfigs.SERVER.trains.poweredTrainAcceleration.getF() : AllConfigs.SERVER.trains.trainAcceleration.getF()) / 400.0f;
    }

    public CompoundTag write(DimensionPalette dimensions) {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("Id", this.id);
        tag.m_128362_("Owner", this.owner);
        if (this.graph != null) {
            tag.m_128362_("Graph", this.graph.id);
        }
        tag.m_128365_("Carriages", (Tag)NBTHelper.writeCompoundList(this.carriages, c -> c.write(dimensions)));
        tag.m_128408_("CarriageSpacing", this.carriageSpacing);
        tag.m_128379_("DoubleEnded", this.doubleEnded);
        tag.m_128347_("Speed", this.speed);
        tag.m_128347_("Throttle", this.throttle);
        if (this.speedBeforeStall != null) {
            tag.m_128347_("SpeedBeforeStall", this.speedBeforeStall.doubleValue());
        }
        tag.m_128405_("Fuel", this.fuelTicks);
        tag.m_128347_("TargetSpeed", this.targetSpeed);
        tag.m_128359_("IconType", this.icon.id.toString());
        tag.m_128359_("Name", Component.Serializer.m_130703_((Component)this.name));
        if (this.currentStation != null) {
            tag.m_128362_("Station", this.currentStation);
        }
        tag.m_128379_("Backwards", this.currentlyBackwards);
        tag.m_128379_("Derailed", this.derailed);
        tag.m_128379_("UpdateSignals", this.updateSignalBlocks);
        tag.m_128365_("SignalBlocks", (Tag)NBTHelper.writeCompoundList(this.occupiedSignalBlocks.entrySet(), e -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("Id", (UUID)e.getKey());
            if (e.getValue() != null) {
                compoundTag.m_128362_("Boundary", (UUID)e.getValue());
            }
            return compoundTag;
        }));
        tag.m_128365_("ReservedSignalBlocks", (Tag)NBTHelper.writeCompoundList(this.reservedSignalBlocks, uid -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("Id", uid);
            return compoundTag;
        }));
        tag.m_128365_("OccupiedObservers", (Tag)NBTHelper.writeCompoundList(this.occupiedObservers, uid -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("Id", uid);
            return compoundTag;
        }));
        tag.m_128365_("MigratingPoints", (Tag)NBTHelper.writeCompoundList(this.migratingPoints, tm -> tm.write(dimensions)));
        tag.m_128365_("Runtime", (Tag)this.runtime.write());
        tag.m_128365_("Navigation", (Tag)this.navigation.write(dimensions));
        return tag;
    }

    public static Train read(CompoundTag tag, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions) {
        UUID id = tag.m_128342_("Id");
        UUID owner = tag.m_128342_("Owner");
        UUID graphId = tag.m_128441_("Graph") ? tag.m_128342_("Graph") : null;
        TrackGraph graph = graphId == null ? null : trackNetworks.get(graphId);
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        NBTHelper.iterateCompoundList(tag.m_128437_("Carriages", 10), c -> carriages.add(Carriage.read(c, graph, dimensions)));
        ArrayList<Integer> carriageSpacing = new ArrayList<Integer>();
        for (int i : tag.m_128465_("CarriageSpacing")) {
            carriageSpacing.add(i);
        }
        boolean doubleEnded = tag.m_128471_("DoubleEnded");
        Train train = new Train(id, owner, graph, carriages, carriageSpacing, doubleEnded);
        train.speed = tag.m_128459_("Speed");
        train.throttle = tag.m_128459_("Throttle");
        if (tag.m_128441_("SpeedBeforeStall")) {
            train.speedBeforeStall = tag.m_128459_("SpeedBeforeStall");
        }
        train.targetSpeed = tag.m_128459_("TargetSpeed");
        train.icon = TrainIconType.byId(new ResourceLocation(tag.m_128461_("IconType")));
        train.name = Component.Serializer.m_130701_((String)tag.m_128461_("Name"));
        train.currentStation = tag.m_128441_("Station") ? tag.m_128342_("Station") : null;
        train.currentlyBackwards = tag.m_128471_("Backwards");
        train.derailed = tag.m_128471_("Derailed");
        train.updateSignalBlocks = tag.m_128471_("UpdateSignals");
        train.fuelTicks = tag.m_128451_("Fuel");
        NBTHelper.iterateCompoundList(tag.m_128437_("SignalBlocks", 10), c -> train.occupiedSignalBlocks.put(c.m_128342_("Id"), c.m_128441_("Boundary") ? c.m_128342_("Boundary") : null));
        NBTHelper.iterateCompoundList(tag.m_128437_("ReservedSignalBlocks", 10), c -> train.reservedSignalBlocks.add(c.m_128342_("Id")));
        NBTHelper.iterateCompoundList(tag.m_128437_("OccupiedObservers", 10), c -> train.occupiedObservers.add(c.m_128342_("Id")));
        NBTHelper.iterateCompoundList(tag.m_128437_("MigratingPoints", 10), c -> train.migratingPoints.add(TrainMigration.read(c, dimensions)));
        train.runtime.read(tag.m_128469_("Runtime"));
        train.navigation.read(tag.m_128469_("Navigation"), graph, dimensions);
        if (train.getCurrentStation() != null) {
            train.getCurrentStation().reserveFor(train);
        }
        return train;
    }

    public int countPlayerPassengers() {
        AtomicInteger count = new AtomicInteger();
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.m_146897_().forEach(p -> {
                if (p instanceof Player) {
                    count.incrementAndGet();
                }
            }));
        }
        return count.intValue();
    }

    public void determineHonk(Level level) {
        if (this.lowHonk != null) {
            return;
        }
        for (int index = 0; index < this.carriages.size(); ++index) {
            Contraption contraption;
            Carriage carriage = this.carriages.get(index);
            Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensionalIfPresent((ResourceKey<Level>)level.m_46472_());
            if (dimensional == null) {
                return;
            }
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensional.entity.get());
            if (entity == null || !((contraption = entity.getContraption()) instanceof CarriageContraption)) break;
            CarriageContraption otherCC = (CarriageContraption)contraption;
            Pair<Boolean, Integer> first = otherCC.soundQueue.getFirstWhistle(entity);
            if (first == null) continue;
            this.lowHonk = first.getFirst();
            this.honkPitch = first.getSecond();
        }
    }

    public float distanceToLocationSqr(Level level, Vec3 location) {
        float distance = Float.MAX_VALUE;
        for (Carriage carriage : this.carriages) {
            Carriage.DimensionalCarriageEntity dce = carriage.getDimensionalIfPresent((ResourceKey<Level>)level.m_46472_());
            if (dce == null || dce.positionAnchor == null) continue;
            distance = Math.min(distance, (float)dce.positionAnchor.m_82557_(location));
        }
        return distance;
    }

    public static class Penalties {
        static final int STATION = 200;
        static final int STATION_WITH_TRAIN = 300;
        static final int MANUAL_TRAIN = 200;
        static final int IDLE_TRAIN = 700;
        static final int ARRIVING_TRAIN = 50;
        static final int WAITING_TRAIN = 50;
        static final int ANY_TRAIN = 25;
        static final int RED_SIGNAL = 25;
        static final int REDSTONE_RED_SIGNAL = 400;
    }
}

