/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.block.display.AllDisplayBehaviours;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DisplayLinkBlockItem
extends BlockItem {
    private static BlockPos lastShownPos = null;
    private static AABB lastShownAABB = null;

    public DisplayLinkBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @SubscribeEvent
    public static void gathererItemAlwaysPlacesWhenUsed(PlayerInteractEvent.RightClickBlock event) {
        ItemStack usedItem = event.getItemStack();
        if (usedItem.m_41720_() instanceof DisplayLinkBlockItem) {
            if (AllBlocks.DISPLAY_LINK.has(event.getLevel().m_8055_(event.getPos()))) {
                return;
            }
            event.setUseBlock(Event.Result.DENY);
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos placedPos;
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_20161_() && stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)Lang.translateDirect("display_link.clear", new Object[0]), true);
            stack.m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        if (!stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            player.m_5661_((Component)Lang.translateDirect("display_link.set", new Object[0]), true);
            stack.m_41751_(stackTag);
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag teTag = new CompoundTag();
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("SelectedPos"));
        if (!selectedPos.m_123314_((Vec3i)(placedPos = pos.m_5484_(pContext.m_43719_(), state.m_60767_().m_76336_() ? 0 : 1)), (double)((Integer)AllConfigs.SERVER.logistics.displayLinkRange.get()).intValue())) {
            player.m_5661_((Component)Lang.translateDirect("display_link.too_far", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        teTag.m_128365_("TargetOffset", (Tag)NbtUtils.m_129224_((BlockPos)selectedPos.m_121996_((Vec3i)placedPos)));
        tag.m_128365_("BlockEntityTag", (Tag)teTag);
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        ItemStack itemInHand = player.m_21120_(pContext.m_43724_());
        if (!itemInHand.m_41619_()) {
            itemInHand.m_41751_(null);
        }
        player.m_5661_((Component)Lang.translateDirect("display_link.success", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
        return useOn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.m_21205_();
        if (!(heldItemMainhand.m_41720_() instanceof DisplayLinkBlockItem)) {
            return;
        }
        if (!heldItemMainhand.m_41782_()) {
            return;
        }
        CompoundTag stackTag = heldItemMainhand.m_41784_();
        if (!stackTag.m_128441_("SelectedPos")) {
            return;
        }
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)stackTag.m_128469_("SelectedPos"));
        if (!selectedPos.equals((Object)lastShownPos)) {
            lastShownAABB = DisplayLinkBlockItem.getBounds(selectedPos);
            lastShownPos = selectedPos;
        }
        CreateClient.OUTLINER.showAABB("target", lastShownAABB).colored(16763764).lineWidth(0.0625f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static AABB getBounds(BlockPos pos) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        DisplayTarget target = AllDisplayBehaviours.targetOf((LevelAccessor)world, pos);
        if (target != null) {
            return target.getMultiblockBounds((LevelAccessor)world, pos);
        }
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        return shape.m_83281_() ? new AABB(BlockPos.f_121853_) : shape.m_83215_().m_82338_(pos);
    }
}

