/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.container.ReprocessorContainer;
import com.blakebr0.mysticalagriculture.crafting.recipe.ReprocessorRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.ReprocessorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ReprocessorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    private final BaseItemStackHandler inventory;
    private final EnergyStorage energy;
    private final LazyOptional<IItemHandlerModifiable>[] inventoryCapabilities;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private final ReprocessorTier tier;
    private ReprocessorRecipe recipe;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private int oldEnergy;

    public ReprocessorTileEntity(BlockEntityType<?> type, ReprocessorTier tier, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = ReprocessorTileEntity.createInventoryHandler(() -> ((ReprocessorTileEntity)this).markDirtyAndDispatch());
        this.energy = new EnergyStorage(tier.getFuelCapacity());
        this.inventoryCapabilities = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
        this.tier = tier;
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128365_("Energy", this.energy.serializeNBT());
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.reprocessor").build();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return ReprocessorContainer.create(id, playerInventory, arg_0 -> ((ReprocessorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, this.m_58899_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_()) {
            if (cap == CapabilityEnergy.ENERGY) {
                return CapabilityEnergy.ENERGY.orEmpty(cap, this.energyCapability);
            }
            if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (side == Direction.UP) {
                    return this.inventoryCapabilities[0].cast();
                }
                if (side == Direction.DOWN) {
                    return this.inventoryCapabilities[1].cast();
                }
                return this.inventoryCapabilities[2].cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ReprocessorTileEntity tile) {
        boolean mark = false;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.extractItemSuper(1, 1, false);
                    mark = true;
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.tier.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        if (tile.energy.getEnergyStored() >= tile.tier.getFuelUsage()) {
            ItemStack input = tile.inventory.getStackInSlot(0);
            ItemStack output = tile.inventory.getStackInSlot(2);
            if (!input.m_41619_()) {
                ItemStack recipeOutput;
                if (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.inventory)) {
                    IReprocessorRecipe recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.REPROCESSOR.get(), tile.inventory.toIInventory(), level).orElse(null);
                    ReprocessorRecipe reprocessorRecipe = tile.recipe = recipe instanceof ReprocessorRecipe ? (ReprocessorRecipe)recipe : null;
                }
                if (tile.recipe != null && !(recipeOutput = tile.recipe.assemble((IItemHandler)tile.inventory)).m_41619_() && (output.m_41619_() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)recipeOutput))) {
                    ++tile.progress;
                    tile.energy.extractEnergy(tile.tier.getFuelUsage(), false);
                    if (tile.progress >= tile.tier.getOperationTime()) {
                        tile.inventory.extractItemSuper(0, 1, false);
                        ItemStack result = StackHelper.combineStacks((ItemStack)output, (ItemStack)recipeOutput);
                        tile.inventory.setStackInSlot(2, result);
                        tile.progress = 0;
                    }
                    mark = true;
                }
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.recipe = null;
                mark = true;
            }
        }
        if (tile.oldEnergy != tile.energy.getEnergyStored()) {
            tile.oldEnergy = tile.energy.getEnergyStored();
            mark = true;
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(3, onContentsChanged);
        inventory.setOutputSlots(new int[]{2});
        return inventory;
    }

    public ReprocessorTier getTier() {
        return this.tier;
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return true;
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.m_58399_((ItemStack)stack);
        }
        return false;
    }

    public static class AwakenedSupremium
    extends ReprocessorTileEntity {
        public AwakenedSupremium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.AWAKENED_SUPREMIUM_REPROCESSOR.get(), ReprocessorTier.AWAKENED_SUPREMIUM, pos, state);
        }
    }

    public static class Supremium
    extends ReprocessorTileEntity {
        public Supremium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.SUPREMIUM_REPROCESSOR.get(), ReprocessorTier.SUPREMIUM, pos, state);
        }
    }

    public static class Imperium
    extends ReprocessorTileEntity {
        public Imperium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.IMPERIUM_REPROCESSOR.get(), ReprocessorTier.IMPERIUM, pos, state);
        }
    }

    public static class Tertium
    extends ReprocessorTileEntity {
        public Tertium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.TERTIUM_REPROCESSOR.get(), ReprocessorTier.TERTIUM, pos, state);
        }
    }

    public static class Prudentium
    extends ReprocessorTileEntity {
        public Prudentium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.PRUDENTIUM_REPROCESSOR.get(), ReprocessorTier.PRUDENTIUM, pos, state);
        }
    }

    public static class Inferium
    extends ReprocessorTileEntity {
        public Inferium(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.INFERIUM_REPROCESSOR.get(), ReprocessorTier.INFERIUM, pos, state);
        }
    }

    public static class Basic
    extends ReprocessorTileEntity {
        public Basic(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.BASIC_REPROCESSOR.get(), ReprocessorTier.BASIC, pos, state);
        }
    }
}

