/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item.armor;

import com.blakebr0.cucumber.item.BaseArmorItem;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.api.util.AugmentUtils;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class EssenceChestplateItem
extends BaseArmorItem
implements ITinkerable {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private static final EnumSet<AugmentType> TYPES = EnumSet.of(AugmentType.ARMOR, AugmentType.CHESTPLATE);
    private final int tinkerableTier;
    private final int slots;

    public EssenceChestplateItem(ArmorMaterial material, int tinkerableTier, int slots, Function<Item.Properties, Item.Properties> properties) {
        super(material, EquipmentSlot.CHEST, properties);
        this.tinkerableTier = tinkerableTier;
        this.slots = slots;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        AugmentUtils.getAugments(stack).forEach(a -> a.onArmorTick(stack, level, player));
        if (!level.m_5776_() && level.m_46467_() % 20L == 0L && EssenceChestplateItem.hasAwakenedSupremiumSet(player)) {
            EssenceChestplateItem.handleGrowthTicks(level, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(ModTooltips.getTooltipForTier(this.tinkerableTier));
        if (stack.m_150930_((Item)ModItems.AWAKENED_SUPREMIUM_CHESTPLATE.get())) {
            tooltip.add((Component)ModTooltips.SET_BONUS.args(new Object[]{ModTooltips.AWAKENED_SUPREMIUM_SET_BONUS.build()}).build());
        }
        AugmentUtils.getAugments(stack).forEach(a -> tooltip.add((Component)a.getDisplayName().m_130940_(ChatFormatting.GRAY)));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == this.m_40402_()) {
            ArmorMaterial material = this.m_40401_();
            modifiers.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.m_20749_()], "Armor modifier", (double)material.m_7365_(slot), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.m_20749_()], "Armor toughness", (double)material.m_6651_(), AttributeModifier.Operation.ADDITION));
            if (material.m_6649_() > 0.0f) {
                modifiers.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(ARMOR_MODIFIERS[slot.m_20749_()], "Armor knockback resistance", (double)material.m_6649_(), AttributeModifier.Operation.ADDITION));
            }
            AugmentUtils.getAugments(stack).forEach(arg_0 -> EssenceChestplateItem.lambda$getAttributeModifiers$2((Multimap)modifiers, slot, stack, arg_0));
        }
        return modifiers;
    }

    @Override
    public int getAugmentSlots() {
        return this.slots;
    }

    @Override
    public EnumSet<AugmentType> getAugmentTypes() {
        return TYPES;
    }

    @Override
    public int getTinkerableTier() {
        return this.tinkerableTier;
    }

    private static boolean hasAwakenedSupremiumSet(Player player) {
        boolean helmet = player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.AWAKENED_SUPREMIUM_HELMET.get());
        boolean chestplate = player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ModItems.AWAKENED_SUPREMIUM_CHESTPLATE.get());
        boolean leggings = player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ModItems.AWAKENED_SUPREMIUM_LEGGINGS.get());
        boolean boots = player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ModItems.AWAKENED_SUPREMIUM_BOOTS.get());
        return helmet && chestplate && leggings && boots;
    }

    private static void handleGrowthTicks(Level level, Player player) {
        BlockPos pos = player.m_20097_();
        int range = 5;
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(aoePos -> {
            BlockState state = level.m_8055_(aoePos);
            Block plantBlock = state.m_60734_();
            if (plantBlock instanceof BonemealableBlock || plantBlock instanceof IPlantable || plantBlock == Blocks.f_50195_ || plantBlock == Blocks.f_50491_) {
                state.m_222972_((ServerLevel)level, aoePos, Utils.RANDOM);
                double d0 = (float)aoePos.m_123341_() + level.m_213780_().m_188501_();
                double d1 = aoePos.m_123342_();
                double d2 = (float)aoePos.m_123343_() + level.m_213780_().m_188501_();
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123748_, d0, d1, d2, 3, 0.0, 0.0, 0.0, 0.1);
            }
        });
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$2(Multimap modifiers, EquipmentSlot slot, ItemStack stack, Augment a) {
        a.addArmorAttributeModifiers((Multimap<Attribute, AttributeModifier>)modifiers, slot, stack);
    }
}

