/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class RegistryUtils {
    private RegistryUtils() {
    }

    public static ResourceLocation getName(MenuType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.MENU_TYPES, element);
    }

    public static ResourceLocation getName(ParticleType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.PARTICLE_TYPES, element);
    }

    public static ResourceLocation getName(Item element) {
        return RegistryUtils.getName(ForgeRegistries.ITEMS, element);
    }

    public static String getPath(Item element) {
        return RegistryUtils.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Block element) {
        return RegistryUtils.getName(ForgeRegistries.BLOCKS, element);
    }

    public static String getNamespace(Block element) {
        return RegistryUtils.getName(element).m_135827_();
    }

    public static String getPath(Block element) {
        return RegistryUtils.getName(element).m_135815_();
    }

    public static ResourceLocation getName(Fluid element) {
        return RegistryUtils.getName(ForgeRegistries.FLUIDS, element);
    }

    public static ResourceLocation getName(BlockEntityType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.BLOCK_ENTITY_TYPES, element);
    }

    public static ResourceLocation getName(EntityType<?> element) {
        return RegistryUtils.getName(ForgeRegistries.ENTITY_TYPES, element);
    }

    public static ResourceLocation getName(RecipeSerializer<?> element) {
        return RegistryUtils.getName(ForgeRegistries.RECIPE_SERIALIZERS, element);
    }

    private static <T> ResourceLocation getName(IForgeRegistry<T> registry, T element) {
        return registry.getKey(element);
    }

    @Nullable
    public static ResourceLocation getName(Object element) {
        ResourceLocation registryName = RegistryUtils.getName(Registry.f_122897_, element);
        return registryName == null ? RegistryUtils.getName(BuiltinRegistries.f_123858_, element) : registryName;
    }

    @Nullable
    private static ResourceLocation getName(Registry<? extends Registry<?>> registries, Object element) {
        for (Registry registry : registries) {
            ResourceLocation registryName = registry.m_7981_(element);
            if (registryName == null) continue;
            return registryName;
        }
        return null;
    }
}

