/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.network.distribution.ChemicalHandlerTarget;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ChemicalUtil {
    private ChemicalUtil() {
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, ?>> Capability<HANDLER> getCapabilityForChemical(CHEMICAL chemical) {
        if (chemical instanceof Gas) {
            return Capabilities.GAS_HANDLER;
        }
        if (chemical instanceof InfuseType) {
            return Capabilities.INFUSION_HANDLER;
        }
        if (chemical instanceof Pigment) {
            return Capabilities.PIGMENT_HANDLER;
        }
        if (chemical instanceof Slurry) {
            return Capabilities.SLURRY_HANDLER;
        }
        throw new IllegalStateException("Unknown Chemical Type: " + chemical.getClass().getName());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> Capability<HANDLER> getCapabilityForChemical(STACK stack) {
        return ChemicalUtil.getCapabilityForChemical(stack.getType());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> Capability<HANDLER> getCapabilityForChemical(IChemicalTank<CHEMICAL, STACK> tank) {
        return ChemicalUtil.getCapabilityForChemical(tank.getEmptyStack());
    }

    public static ChemicalStack<?> getEmptyStack(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> GasStack.EMPTY;
            case ChemicalType.INFUSION -> InfusionStack.EMPTY;
            case ChemicalType.PIGMENT -> PigmentStack.EMPTY;
            case ChemicalType.SLURRY -> SlurryStack.EMPTY;
        };
    }

    public static <STACK extends ChemicalStack<?>> STACK getEmptyStack(STACK stack) {
        if (stack instanceof GasStack) {
            return (STACK)GasStack.EMPTY;
        }
        if (stack instanceof InfusionStack) {
            return (STACK)InfusionStack.EMPTY;
        }
        if (stack instanceof PigmentStack) {
            return (STACK)PigmentStack.EMPTY;
        }
        if (stack instanceof SlurryStack) {
            return (STACK)SlurryStack.EMPTY;
        }
        throw new IllegalStateException("Unknown Chemical Type: " + stack.getType().getClass().getName());
    }

    public static boolean compareTypes(ChemicalType chemicalType, MergedChemicalTank.Current current) {
        return current == (switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> MergedChemicalTank.Current.GAS;
            case ChemicalType.INFUSION -> MergedChemicalTank.Current.INFUSION;
            case ChemicalType.PIGMENT -> MergedChemicalTank.Current.PIGMENT;
            case ChemicalType.SLURRY -> MergedChemicalTank.Current.SLURRY;
        });
    }

    public static <STACK extends ChemicalStack<?>> STACK copy(STACK stack) {
        return (STACK)stack.copy();
    }

    public static <STACK extends ChemicalStack<?>> STACK copyWithAmount(STACK stack, long amount) {
        if (stack.isEmpty() || amount <= 0L) {
            return ChemicalUtil.getEmptyStack(stack);
        }
        STACK result = ChemicalUtil.copy(stack);
        result.setAmount(amount);
        return result;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK withAmount(IChemicalProvider<CHEMICAL> provider, long amount) {
        return (STACK)provider.getStack(amount);
    }

    public static ItemStack getFullChemicalTank(ChemicalTankTier tier, @NotNull Chemical<?> chemical) {
        return ChemicalUtil.getFilledVariant(ChemicalUtil.getEmptyChemicalTank(tier), tier.getStorage(), chemical);
    }

    private static ItemStack getEmptyChemicalTank(ChemicalTankTier tier) {
        return (switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalTankTier.BASIC -> MekanismBlocks.BASIC_CHEMICAL_TANK;
            case ChemicalTankTier.ADVANCED -> MekanismBlocks.ADVANCED_CHEMICAL_TANK;
            case ChemicalTankTier.ELITE -> MekanismBlocks.ELITE_CHEMICAL_TANK;
            case ChemicalTankTier.ULTIMATE -> MekanismBlocks.ULTIMATE_CHEMICAL_TANK;
            case ChemicalTankTier.CREATIVE -> MekanismBlocks.CREATIVE_CHEMICAL_TANK;
        }).getItemStack();
    }

    public static ItemStack getFilledVariant(ItemStack toFill, long capacity, IChemicalProvider<?> provider) {
        if (provider instanceof IGasProvider) {
            IGasProvider gasProvider = (IGasProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.GAS, capacity, gasProvider, "GasTanks");
        }
        if (provider instanceof IInfuseTypeProvider) {
            IInfuseTypeProvider infuseTypeProvider = (IInfuseTypeProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.INFUSION, capacity, infuseTypeProvider, "InfusionTanks");
        }
        if (provider instanceof IPigmentProvider) {
            IPigmentProvider pigmentProvider = (IPigmentProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.PIGMENT, capacity, pigmentProvider, "PigmentTanks");
        }
        if (provider instanceof ISlurryProvider) {
            ISlurryProvider slurryProvider = (ISlurryProvider)provider;
            return ChemicalUtil.getFilledVariant(toFill, ChemicalTankBuilder.SLURRY, capacity, slurryProvider, "SlurryTanks");
        }
        throw new IllegalStateException("Unknown Chemical Type: " + provider.getChemical().getClass().getName());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> ItemStack getFilledVariant(ItemStack toFill, ChemicalTankBuilder<CHEMICAL, STACK, TANK> tankBuilder, long capacity, IChemicalProvider<CHEMICAL> provider, String key) {
        TANK dummyTank = tankBuilder.createDummy(capacity);
        dummyTank.setStack(ChemicalUtil.withAmount(provider, dummyTank.getCapacity()));
        ItemDataUtils.writeContainers(toFill, key, Collections.singletonList(dummyTank));
        return toFill;
    }

    public static int getRGBDurabilityForDisplay(ItemStack stack) {
        GasStack gasStack = StorageUtils.getStoredGasFromNBT(stack);
        if (!gasStack.isEmpty()) {
            return gasStack.getChemicalColorRepresentation();
        }
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT(stack);
        if (!infusionStack.isEmpty()) {
            return infusionStack.getChemicalColorRepresentation();
        }
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromNBT(stack);
        if (!pigmentStack.isEmpty()) {
            return pigmentStack.getChemicalColorRepresentation();
        }
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromNBT(stack);
        if (!slurryStack.isEmpty()) {
            return slurryStack.getChemicalColorRepresentation();
        }
        return 0;
    }

    public static boolean hasGas(ItemStack stack) {
        return ChemicalUtil.hasChemical(stack, ConstantPredicates.alwaysTrue(), Capabilities.GAS_HANDLER);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean hasChemical(ItemStack stack, CHEMICAL type) {
        Capability capability = ChemicalUtil.getCapabilityForChemical(type);
        return ChemicalUtil.hasChemical(stack, s -> s.isTypeEqual(type), capability);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean hasChemical(ItemStack stack, Predicate<STACK> validityCheck, Capability<HANDLER> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            for (int tank = 0; tank < handler.getTanks(); ++tank) {
                Object chemicalStack = handler.getChemicalInTank(tank);
                if (((ChemicalStack)chemicalStack).isEmpty() || !validityCheck.test(chemicalStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAttributeTooltips(List<Component> tooltips, Chemical<?> chemical) {
        chemical.getAttributes().forEach(attr -> attr.addTooltipText(tooltips));
    }

    public static void addChemicalDataToTooltip(List<Component> tooltips, Chemical<?> chemical, boolean advanced) {
        if (!chemical.isEmptyType()) {
            Gas gas;
            ChemicalUtil.addAttributeTooltips(tooltips, chemical);
            if (chemical instanceof Gas && MekanismTags.Gases.WASTE_BARREL_DECAY_LOOKUP.contains(gas = (Gas)chemical)) {
                tooltips.add((Component)MekanismLang.DECAY_IMMUNE.translateColored(EnumColor.AQUA, new Object[0]));
            }
            if (advanced) {
                tooltips.add((Component)TextComponentUtil.build(ChatFormatting.DARK_GRAY, chemical.getRegistryName()));
            }
        }
    }

    public static void emit(IChemicalTank<?, ?> tank, BlockEntity from) {
        ChemicalUtil.emit(EnumSet.allOf(Direction.class), tank, from);
    }

    public static void emit(Set<Direction> outputSides, IChemicalTank<?, ?> tank, BlockEntity from) {
        ChemicalUtil.emit(outputSides, tank, from, tank.getCapacity());
    }

    public static void emit(Set<Direction> outputSides, IChemicalTank<?, ?> tank, BlockEntity from, long maxOutput) {
        if (!tank.isEmpty() && maxOutput > 0L) {
            tank.extract(ChemicalUtil.emit(outputSides, tank.extract(maxOutput, Action.SIMULATE, AutomationType.INTERNAL), from), Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> long emit(Set<Direction> sides, @NotNull STACK stack, BlockEntity from) {
        if (stack.isEmpty() || sides.isEmpty()) {
            return 0L;
        }
        Capability capability = ChemicalUtil.getCapabilityForChemical(stack);
        ChemicalHandlerTarget target = new ChemicalHandlerTarget(stack, 6);
        EmitUtils.forEachSide(from.m_58904_(), from.m_58899_(), sides, (acceptor, side) -> CapabilityUtils.getCapability((ICapabilityProvider)acceptor, capability, side.m_122424_()).ifPresent(handler -> {
            if (ChemicalUtil.canInsert(handler, stack)) {
                target.addHandler(handler);
            }
        }));
        if (target.getHandlerCount() > 0) {
            return EmitUtils.sendToAcceptors(target, stack.getAmount(), ChemicalUtil.copy(stack));
        }
        return 0L;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, HANDLER extends IChemicalHandler<CHEMICAL, STACK>> boolean canInsert(HANDLER handler, @NotNull STACK stack) {
        return ((ChemicalStack)handler.insertChemical(stack, Action.SIMULATE)).getAmount() < stack.getAmount();
    }
}

