/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.AttributeStateBoilerValveMode;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing {
    public TileEntityBoilerValve(BlockPos pos, BlockState state) {
        super(MekanismBlocks.BOILER_VALVE, pos, state);
    }

    @Override
    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return side -> ((BoilerMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> ((BoilerMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Override
    protected boolean onUpdateServer(BoilerMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer(multiblock);
        if (multiblock.isFormed()) {
            AttributeStateBoilerValveMode.BoilerValveMode mode = this.getMode();
            if (mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_STEAM) {
                ChemicalUtil.emit(multiblock.getDirectionsToEmit(this.m_58899_()), multiblock.steamTank, (BlockEntity)this);
            } else if (mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_COOLANT) {
                ChemicalUtil.emit(multiblock.getDirectionsToEmit(this.m_58899_()), multiblock.cooledCoolantTank, (BlockEntity)this);
            }
        }
        return needsPacket;
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.FLUID || type == SubstanceType.GAS) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public int getRedstoneLevel() {
        return ((BoilerMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    @ComputerMethod
    private AttributeStateBoilerValveMode.BoilerValveMode getMode() {
        return (AttributeStateBoilerValveMode.BoilerValveMode)((Object)this.m_58900_().m_61143_(AttributeStateBoilerValveMode.modeProperty));
    }

    @ComputerMethod
    private void setMode(AttributeStateBoilerValveMode.BoilerValveMode mode) {
        if (mode != this.getMode()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(AttributeStateBoilerValveMode.modeProperty, (Comparable)((Object)mode)));
        }
    }

    @Override
    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            AttributeStateBoilerValveMode.BoilerValveMode mode = (AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getNext();
            this.setMode(mode);
            player.m_213846_(MekanismUtils.logFormat(MekanismLang.BOILER_VALVE_MODE_CHANGE.translate(mode)));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, Direction side, @NotNull Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute()) {
            ((BoilerMultiblockData)this.getMultiblock()).triggerValveTransfer(this);
        }
        return ret;
    }

    @Override
    public boolean insertGasCheck(int tank, @Nullable Direction side) {
        if (this.getMode() != AttributeStateBoilerValveMode.BoilerValveMode.INPUT) {
            return false;
        }
        return super.insertGasCheck(tank, side);
    }

    @Override
    public boolean extractGasCheck(int tank, @Nullable Direction side) {
        AttributeStateBoilerValveMode.BoilerValveMode mode = this.getMode();
        if (mode == AttributeStateBoilerValveMode.BoilerValveMode.INPUT || tank == 2 && mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_STEAM || tank == 0 && mode == AttributeStateBoilerValveMode.BoilerValveMode.OUTPUT_COOLANT) {
            return false;
        }
        return super.extractGasCheck(tank, side);
    }

    @ComputerMethod
    private void incrementMode() {
        this.setMode((AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getNext());
    }

    @ComputerMethod
    private void decrementMode() {
        this.setMode((AttributeStateBoilerValveMode.BoilerValveMode)this.getMode().getPrevious());
    }
}

