/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGameEvents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class TileEntitySeismicVibrator
extends TileEntityMekanism
implements IBoundingBlock {
    public int clientPiston;
    private MachineEnergyContainer<TileEntitySeismicVibrator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntitySeismicVibrator(BlockPos pos, BlockState state) {
        super(MekanismBlocks.SEISMIC_VIBRATOR, pos, state);
        this.cacheCoord();
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD, this));
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer, RelativeSide.BACK);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntitySeismicVibrator)this).m_58904_(), listener, 143, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        if (this.getActive()) {
            ++this.clientPiston;
        }
        this.updateActiveVibrators();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (MekanismUtils.canFunction(this)) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.ticker % 40 == 0) {
                    this.f_58857_.m_142346_(null, (GameEvent)MekanismGameEvents.SEISMIC_VIBRATION.get(), this.f_58858_);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.updateActiveVibrators();
    }

    private void updateActiveVibrators() {
        if (this.getActive()) {
            Mekanism.activeVibrators.add(this.getTileCoord());
        } else {
            Mekanism.activeVibrators.remove(this.getTileCoord());
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        Mekanism.activeVibrators.remove(this.getTileCoord());
    }

    @NotNull
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 2, 1));
    }

    public MachineEnergyContainer<TileEntitySeismicVibrator> getEnergyContainer() {
        return this.energyContainer;
    }
}

