/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.Upgrade;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.assemblicator.RecipeFormula;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FormulaicCraftingSlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityFormulaicAssemblicator
extends TileEntityConfigurableMachine
implements IHasMode {
    private static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.m_122779_();
    private static final Predicate<@NotNull ItemStack> formulaSlotValidator = stack -> stack.m_41720_() instanceof ItemCraftingFormula;
    private static final int BASE_TICKS_REQUIRED = 40;
    private final CraftingContainer dummyInv = MekanismUtils.getDummyCraftingInv();
    private int ticksRequired = 40;
    private int operatingTicks;
    private boolean autoMode = false;
    private boolean isRecipe = false;
    private boolean stockControl = false;
    private boolean needsOrganize = true;
    private final HashedItem[] stockControlMap = new HashedItem[18];
    private int pulseOperations;
    public RecipeFormula formula;
    @Nullable
    private CraftingRecipe cachedRecipe = null;
    @SyntheticComputerMethod(getter="getExcessRemainingItems")
    private NonNullList<ItemStack> lastRemainingItems = EMPTY_LIST;
    private ItemStack lastFormulaStack = ItemStack.f_41583_;
    private ItemStack lastOutputStack = ItemStack.f_41583_;
    private MachineEnergyContainer<TileEntityFormulaicAssemblicator> energyContainer;
    private List<IInventorySlot> craftingGridSlots;
    private List<IInventorySlot> inputSlots;
    private List<IInventorySlot> outputSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFormulaItem"})
    private BasicInventorySlot formulaSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityFormulaicAssemblicator(BlockPos pos, BlockState state) {
        super(MekanismBlocks.FORMULAIC_ASSEMBLICATOR, pos, state);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(this.inputSlots, this.outputSlots, this.energySlot, false);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, new InventorySlotInfo(true, true, this.formulaSlot));
            itemConfig.setDefaults();
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
    }

    @Override
    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this, listener);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        int slotX;
        int slotY;
        this.craftingGridSlots = new ArrayList<IInventorySlot>();
        this.inputSlots = new ArrayList<IInventorySlot>();
        this.outputSlots = new ArrayList<IInventorySlot>();
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.formulaSlot = BasicInventorySlot.at(formulaSlotValidator, listener, 6, 26);
        builder.addSlot(this.formulaSlot).setSlotOverlay(SlotOverlay.FORMULA);
        for (slotY = 0; slotY < 2; ++slotY) {
            for (slotX = 0; slotX < 9; ++slotX) {
                int index = slotY * 9 + slotX;
                InputInventorySlot inputSlot = InputInventorySlot.at(stack -> {
                    if (this.formula == null) {
                        return true;
                    }
                    IntList indices = this.formula.getIngredientIndices(this.f_58857_, (ItemStack)stack);
                    if (!indices.isEmpty()) {
                        HashedItem stockItem = this.stockControlMap[index];
                        if (!this.stockControl || stockItem == null) {
                            return true;
                        }
                        return ItemHandlerHelper.canItemStacksStack((ItemStack)stockItem.getStack(), (ItemStack)stack);
                    }
                    return false;
                }, BasicInventorySlot.alwaysTrue, listener, 8 + slotX * 18, 98 + slotY * 18);
                builder.addSlot(inputSlot);
                this.inputSlots.add(inputSlot);
            }
        }
        for (slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 3; ++slotX) {
                FormulaicCraftingSlot craftingSlot = FormulaicCraftingSlot.at(this::getAutoMode, listener, 26 + slotX * 18, 17 + slotY * 18);
                builder.addSlot(craftingSlot);
                this.craftingGridSlots.add(craftingSlot);
            }
        }
        for (slotY = 0; slotY < 3; ++slotY) {
            for (slotX = 0; slotX < 2; ++slotX) {
                OutputInventorySlot outputSlot = OutputInventorySlot.at(listener, 116 + slotX * 18, 17 + slotY * 18);
                builder.addSlot(outputSlot);
                this.outputSlots.add(outputSlot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityFormulaicAssemblicator)this).m_58904_(), listener, 152, 76);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    public BasicInventorySlot getFormulaSlot() {
        return this.formulaSlot;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.checkFormula();
            this.recalculateRecipe();
            if (this.formula != null && this.stockControl) {
                this.buildStockControlMap();
            }
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            this.cachedRecipe = null;
            this.recalculateRecipe();
        }
        if (this.formula != null && this.stockControl && this.needsOrganize) {
            this.needsOrganize = false;
            this.buildStockControlMap();
            this.organizeStock();
        }
        this.energySlot.fillContainerOrConvert();
        if (this.getControlType() != IRedstoneControl.RedstoneControl.PULSE) {
            this.pulseOperations = 0;
        } else if (MekanismUtils.canFunction(this)) {
            ++this.pulseOperations;
        }
        this.checkFormula();
        if (this.autoMode && this.formula == null) {
            this.nextMode();
        }
        if (this.autoMode && this.formula != null && (this.getControlType() == IRedstoneControl.RedstoneControl.PULSE && this.pulseOperations > 0 || MekanismUtils.canFunction(this))) {
            boolean canOperate = true;
            if (!this.isRecipe) {
                canOperate = this.moveItemsToGrid();
            }
            if (canOperate) {
                this.isRecipe = true;
                if (this.operatingTicks >= this.ticksRequired) {
                    if (this.doSingleCraft()) {
                        this.operatingTicks = 0;
                        if (this.pulseOperations > 0) {
                            --this.pulseOperations;
                        }
                    }
                } else {
                    FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
                    if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                        this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                        ++this.operatingTicks;
                    }
                }
            } else {
                this.operatingTicks = 0;
            }
        } else {
            this.operatingTicks = 0;
        }
    }

    private void checkFormula() {
        ItemStack formulaStack = this.formulaSlot.getStack();
        if (!formulaStack.m_41619_() && formulaStack.m_41720_() instanceof ItemCraftingFormula) {
            if (this.formula == null || this.lastFormulaStack != formulaStack) {
                this.loadFormula();
            }
        } else {
            this.formula = null;
        }
        this.lastFormulaStack = formulaStack;
    }

    private void loadFormula() {
        ItemStack formulaStack = this.formulaSlot.getStack();
        ItemCraftingFormula formulaItem = (ItemCraftingFormula)formulaStack.m_41720_();
        if (formulaItem.isInvalid(formulaStack)) {
            this.formula = null;
            return;
        }
        NonNullList<ItemStack> formulaInventory = formulaItem.getInventory(formulaStack);
        if (formulaInventory == null) {
            this.formula = null;
        } else {
            RecipeFormula recipe = new RecipeFormula(this.f_58857_, formulaInventory);
            if (recipe.isValidFormula()) {
                if (this.formula == null) {
                    this.formula = recipe;
                } else if (!this.formula.isFormulaEqual(recipe)) {
                    this.formula = recipe;
                    this.operatingTicks = 0;
                }
            } else {
                this.formula = null;
                formulaItem.setInvalid(formulaStack, true);
            }
        }
    }

    @Override
    protected void setChanged(boolean updateComparator) {
        super.setChanged(updateComparator);
        this.recalculateRecipe();
    }

    private void recalculateRecipe() {
        if (this.f_58857_ != null && !this.isRemote()) {
            if (this.formula == null || !this.formula.isValidFormula()) {
                for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
                    this.dummyInv.m_6836_(i, StackUtils.size(this.craftingGridSlots.get(i).getStack(), 1));
                }
                this.lastRemainingItems = EMPTY_LIST;
                if (this.cachedRecipe == null || !this.cachedRecipe.m_5818_((Container)this.dummyInv, this.f_58857_)) {
                    this.cachedRecipe = MekanismRecipeType.getRecipeFor(RecipeType.f_44107_, this.dummyInv, this.f_58857_).orElse(null);
                }
                if (this.cachedRecipe == null) {
                    this.lastOutputStack = ItemStack.f_41583_;
                } else {
                    this.lastOutputStack = this.cachedRecipe.m_5874_((Container)this.dummyInv);
                    this.lastRemainingItems = this.cachedRecipe.m_7457_((Container)this.dummyInv);
                }
                this.isRecipe = !this.lastOutputStack.m_41619_();
            } else {
                this.isRecipe = this.formula.matches(this.f_58857_, this.craftingGridSlots);
                if (this.isRecipe) {
                    this.lastOutputStack = this.formula.assemble();
                    this.lastRemainingItems = this.formula.getRemainingItems();
                } else {
                    this.lastOutputStack = ItemStack.f_41583_;
                }
            }
            this.needsOrganize = true;
        }
    }

    private boolean doSingleCraft() {
        this.recalculateRecipe();
        ItemStack output = this.lastOutputStack;
        if (!output.m_41619_() && this.tryMoveToOutput(output, Action.SIMULATE) && (this.lastRemainingItems.isEmpty() || this.lastRemainingItems.stream().allMatch(it -> it.m_41619_() || this.tryMoveToOutput((ItemStack)it, Action.SIMULATE)))) {
            this.tryMoveToOutput(output, Action.EXECUTE);
            for (ItemStack remainingItem : this.lastRemainingItems) {
                if (remainingItem.m_41619_()) continue;
                this.tryMoveToOutput(remainingItem, Action.EXECUTE);
            }
            for (IInventorySlot craftingSlot : this.craftingGridSlots) {
                if (craftingSlot.isEmpty()) continue;
                MekanismUtils.logMismatchedStackSize(craftingSlot.shrinkStack(1, Action.EXECUTE), 1L);
            }
            if (this.formula != null) {
                this.moveItemsToGrid();
            }
            this.markForSave();
            return true;
        }
        return false;
    }

    public boolean craftSingle() {
        if (this.formula == null) {
            return this.doSingleCraft();
        }
        boolean canOperate = true;
        if (!this.formula.matches(this.m_58904_(), this.craftingGridSlots)) {
            canOperate = this.moveItemsToGrid();
        }
        if (canOperate) {
            return this.doSingleCraft();
        }
        return false;
    }

    private boolean moveItemsToGrid() {
        boolean ret = true;
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            IInventorySlot recipeSlot = this.craftingGridSlots.get(i);
            ItemStack recipeStack = recipeSlot.getStack();
            if (this.formula.isIngredientInPos(this.f_58857_, recipeStack, i)) continue;
            if (recipeStack.m_41619_()) {
                boolean found = false;
                for (int j = this.inputSlots.size() - 1; j >= 0; --j) {
                    ItemStack stockStack;
                    IInventorySlot stockSlot = this.inputSlots.get(j);
                    if (stockSlot.isEmpty() || !this.formula.isIngredientInPos(this.f_58857_, stockStack = stockSlot.getStack(), i)) continue;
                    recipeSlot.setStack(StackUtils.size(stockStack, 1));
                    MekanismUtils.logMismatchedStackSize(stockSlot.shrinkStack(1, Action.EXECUTE), 1L);
                    this.markForSave();
                    found = true;
                    break;
                }
                if (found) continue;
                ret = false;
                continue;
            }
            recipeStack = this.tryMoveToInput(recipeStack);
            recipeSlot.setStack(recipeStack);
            this.markForSave();
            if (recipeStack.m_41619_()) continue;
            ret = false;
        }
        return ret;
    }

    public void craftAll() {
        while (this.craftSingle()) {
        }
    }

    public void moveItems() {
        if (this.formula == null) {
            this.moveItemsToInput(true);
        } else {
            this.moveItemsToGrid();
        }
    }

    private void moveItemsToInput(boolean forcePush) {
        for (int i = 0; i < this.craftingGridSlots.size(); ++i) {
            IInventorySlot recipeSlot = this.craftingGridSlots.get(i);
            ItemStack recipeStack = recipeSlot.getStack();
            if (recipeStack.m_41619_() || !forcePush && (this.formula == null || this.formula.isIngredientInPos(this.m_58904_(), recipeStack, i))) continue;
            recipeSlot.setStack(this.tryMoveToInput(recipeStack));
        }
        this.markForSave();
    }

    @Override
    public void nextMode() {
        if (this.autoMode) {
            this.operatingTicks = 0;
            this.autoMode = false;
            this.markForSave();
        } else if (this.formula != null) {
            this.moveItemsToInput(false);
            this.autoMode = true;
            this.markForSave();
        }
    }

    @ComputerMethod
    public boolean hasRecipe() {
        return this.isRecipe;
    }

    @ComputerMethod(nameOverride="getRecipeProgress")
    public int getOperatingTicks() {
        return this.operatingTicks;
    }

    @ComputerMethod
    public int getTicksRequired() {
        return this.ticksRequired;
    }

    public boolean getStockControl() {
        return this.stockControl;
    }

    public boolean getAutoMode() {
        return this.autoMode;
    }

    public void toggleStockControl() {
        if (!this.isRemote() && this.formula != null) {
            boolean bl = this.stockControl = !this.stockControl;
            if (this.stockControl) {
                this.organizeStock();
            }
        }
    }

    private void organizeStock() {
        if (this.formula == null) {
            return;
        }
        Object2IntOpenHashMap storedMap = new Object2IntOpenHashMap();
        for (IInventorySlot inputSlot : this.inputSlots) {
            ItemStack stack = inputSlot.getStack();
            if (stack.m_41619_()) continue;
            HashedItem hashed = HashedItem.create(stack);
            storedMap.put((Object)hashed, storedMap.getOrDefault((Object)hashed, 0) + stack.m_41613_());
        }
        IntOpenHashSet unused = new IntOpenHashSet();
        for (int i = 0; i < this.inputSlots.size(); ++i) {
            HashedItem hashedItem = this.stockControlMap[i];
            if (hashedItem == null) {
                unused.add(i);
                continue;
            }
            if (storedMap.containsKey((Object)hashedItem)) {
                int stored = storedMap.getInt((Object)hashedItem);
                int count = Math.min(hashedItem.getStack().m_41741_(), stored);
                if (count == stored) {
                    storedMap.removeInt((Object)hashedItem);
                } else {
                    storedMap.put((Object)hashedItem, stored - count);
                }
                TileEntityFormulaicAssemblicator.setSlotIfChanged(this.inputSlots.get(i), hashedItem, count);
                continue;
            }
            IInventorySlot slot = this.inputSlots.get(i);
            if (slot.isEmpty()) continue;
            slot.setEmpty();
        }
        boolean empty = storedMap.isEmpty();
        IntIterator intIterator = unused.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            IInventorySlot slot = this.inputSlots.get(i);
            if (empty) {
                if (slot.isEmpty()) continue;
                slot.setEmpty();
                continue;
            }
            empty = this.setSlotIfChanged((Object2IntMap<HashedItem>)storedMap, slot);
        }
        if (empty) {
            return;
        }
        for (IInventorySlot inputSlot : this.inputSlots) {
            if (!inputSlot.isEmpty() || !this.setSlotIfChanged((Object2IntMap<HashedItem>)storedMap, inputSlot)) continue;
            return;
        }
        if (!storedMap.isEmpty()) {
            Mekanism.logger.error("Critical error: Formulaic Assemblicator had items left over after organizing stock. Impossible!");
        }
    }

    private boolean setSlotIfChanged(Object2IntMap<HashedItem> storedMap, IInventorySlot inputSlot) {
        boolean empty = false;
        Object2IntMap.Entry next = (Object2IntMap.Entry)storedMap.object2IntEntrySet().iterator().next();
        HashedItem item = (HashedItem)next.getKey();
        int stored = next.getIntValue();
        int count = Math.min(item.getStack().m_41741_(), stored);
        if (count == stored) {
            storedMap.removeInt((Object)item);
            empty = storedMap.isEmpty();
        } else {
            next.setValue(stored - count);
        }
        TileEntityFormulaicAssemblicator.setSlotIfChanged(inputSlot, item, count);
        return empty;
    }

    private static void setSlotIfChanged(IInventorySlot slot, HashedItem item, int count) {
        ItemStack stack = item.createStack(count);
        if (!ItemStack.m_41728_((ItemStack)slot.getStack(), (ItemStack)stack)) {
            slot.setStack(stack);
        }
    }

    private void buildStockControlMap() {
        if (this.formula == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            HashedItem hashedItem;
            int j = i * 2;
            ItemStack stack = this.formula.getInputStack(i);
            if (stack.m_41619_()) {
                this.stockControlMap[j] = null;
                this.stockControlMap[j + 1] = null;
                continue;
            }
            this.stockControlMap[j] = hashedItem = HashedItem.create(stack);
            this.stockControlMap[j + 1] = hashedItem;
        }
    }

    private ItemStack tryMoveToInput(ItemStack stack) {
        IInventorySlot stockSlot;
        Iterator<IInventorySlot> iterator = this.inputSlots.iterator();
        while (iterator.hasNext() && !(stack = (stockSlot = iterator.next()).insertItem(stack, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) {
        }
        return stack;
    }

    private boolean tryMoveToOutput(ItemStack stack, Action action) {
        IInventorySlot outputSlot;
        Iterator<IInventorySlot> iterator = this.outputSlots.iterator();
        while (iterator.hasNext() && !(stack = (outputSlot = iterator.next()).insertItem(stack, action, AutomationType.INTERNAL)).m_41619_()) {
        }
        return stack.m_41619_();
    }

    public void encodeFormula() {
        RecipeFormula formula;
        ItemCraftingFormula item;
        ItemStack formulaStack;
        Item item2;
        if (!this.formulaSlot.isEmpty() && (item2 = (formulaStack = this.formulaSlot.getStack()).m_41720_()) instanceof ItemCraftingFormula && (item = (ItemCraftingFormula)item2).getInventory(formulaStack) == null && (formula = new RecipeFormula(this.f_58857_, this.craftingGridSlots)).isValidFormula()) {
            item.setInventory(formulaStack, formula.input);
            this.markForSave();
        }
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.autoMode = nbt.m_128471_("auto");
        this.operatingTicks = nbt.m_128451_("progress");
        this.pulseOperations = nbt.m_128451_("pulse");
        this.stockControl = nbt.m_128471_("stockControl");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128379_("auto", this.autoMode);
        nbtTags.m_128405_("progress", this.operatingTicks);
        nbtTags.m_128405_("pulse", this.pulseOperations);
        nbtTags.m_128379_("stockControl", this.stockControl);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.ticksRequired = MekanismUtils.getTicks(this, 40);
        }
    }

    @Override
    @NotNull
    public List<Component> getInfo(@NotNull Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    public MachineEnergyContainer<TileEntityFormulaicAssemblicator> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getAutoMode, value -> {
            this.autoMode = value;
        }));
        container.track(SyncableInt.create(this::getOperatingTicks, value -> {
            this.operatingTicks = value;
        }));
        container.track(SyncableInt.create(this::getTicksRequired, value -> {
            this.ticksRequired = value;
        }));
        container.track(SyncableBoolean.create(this::hasRecipe, value -> {
            this.isRecipe = value;
        }));
        container.track(SyncableBoolean.create(this::getStockControl, value -> {
            this.stockControl = value;
        }));
        container.track(SyncableBoolean.create(() -> this.formula != null, hasFormula -> {
            if (hasFormula) {
                if (this.formula == null && this.isRemote()) {
                    this.formula = new RecipeFormula(this.m_58904_(), (NonNullList<ItemStack>)NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
                }
            } else {
                this.formula = null;
            }
        }));
        int i = 0;
        while (i < 9) {
            int index = i++;
            container.track(SyncableItemStack.create(() -> this.formula == null ? ItemStack.f_41583_ : (ItemStack)this.formula.input.get(index), stack -> {
                if (!stack.m_41619_() && this.formula == null && this.isRemote()) {
                    this.formula = new RecipeFormula(this.m_58904_(), (NonNullList<ItemStack>)NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
                }
                if (this.formula != null) {
                    this.formula.setStack(this.m_58904_(), index, (ItemStack)stack);
                }
            }));
        }
    }

    @ComputerMethod
    private ItemStack getCraftingInputSlot(int slot) throws ComputerException {
        if (slot < 0 || slot >= this.craftingGridSlots.size()) {
            throw new ComputerException("Crafting Input Slot '%d' is out of bounds, must be between 0 and %d.", slot, this.craftingGridSlots.size());
        }
        return this.craftingGridSlots.get(slot).getStack();
    }

    @ComputerMethod
    private int getCraftingOutputSlots() {
        return this.outputSlots.size();
    }

    @ComputerMethod
    private ItemStack getCraftingOutputSlot(int slot) throws ComputerException {
        int size = this.getCraftingOutputSlots();
        if (slot < 0 || slot >= size) {
            throw new ComputerException("Crafting Output Slot '%d' is out of bounds, must be between 0 and %d.", slot, size);
        }
        return this.outputSlots.get(slot).getStack();
    }

    @ComputerMethod
    private boolean hasValidFormula() {
        return this.formula != null && this.formula.isValidFormula();
    }

    @ComputerMethod(nameOverride="getSlots")
    private int computerGetSlots() {
        return this.inputSlots.size();
    }

    @ComputerMethod
    private ItemStack getItemInSlot(int slot) throws ComputerException {
        int size = this.computerGetSlots();
        if (slot < 0 || slot >= size) {
            throw new ComputerException("Slot '%d' is out of bounds, must be between 0 and %d.", slot, size);
        }
        return this.inputSlots.get(slot).getStack();
    }

    @ComputerMethod(nameOverride="encodeFormula")
    private void computerEncodeFormula() throws ComputerException {
        Item item;
        this.validateSecurityIsPublic();
        ItemStack formulaStack = this.formulaSlot.getStack();
        if (formulaStack.m_41619_() || !((item = formulaStack.m_41720_()) instanceof ItemCraftingFormula)) {
            throw new ComputerException("No formula found.");
        }
        ItemCraftingFormula craftingFormula = (ItemCraftingFormula)item;
        if (this.formula != null && this.formula.isValidFormula() || craftingFormula.getInventory(formulaStack) != null) {
            throw new ComputerException("Formula has already been encoded.");
        }
        if (!this.hasRecipe()) {
            throw new ComputerException("Encoding formulas require that there is a valid recipe to actually encode.");
        }
        this.encodeFormula();
    }

    @ComputerMethod
    private void fillOrEmptyGrid() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.autoMode) {
            throw new ComputerException("Filling/Emptying the grid requires Auto-Mode to be disabled.");
        }
        this.moveItems();
    }

    private void validateCanCraft() throws ComputerException {
        this.validateSecurityIsPublic();
        if (!this.hasRecipe()) {
            throw new ComputerException("Unable to perform craft as there is currently no matching recipe in the grid.");
        }
        if (this.autoMode) {
            throw new ComputerException("Unable to perform craft as Auto-Mode is enabled.");
        }
    }

    @ComputerMethod
    private void craftSingleItem() throws ComputerException {
        this.validateCanCraft();
        this.craftSingle();
    }

    @ComputerMethod
    private void craftAvailableItems() throws ComputerException {
        this.validateCanCraft();
        this.craftAll();
    }

    private void validateHasValidFormula(String operation) throws ComputerException {
        this.validateSecurityIsPublic();
        if (!this.hasValidFormula()) {
            throw new ComputerException("%s requires a valid formula.", operation);
        }
    }

    @ComputerMethod(nameOverride="getStockControl")
    private boolean computerGetStockControl() throws ComputerException {
        this.validateHasValidFormula("Stock Control");
        return this.getStockControl();
    }

    @ComputerMethod
    private void setStockControl(boolean mode) throws ComputerException {
        this.validateHasValidFormula("Stock Control");
        if (this.stockControl != mode) {
            this.toggleStockControl();
        }
    }

    @ComputerMethod(nameOverride="getAutoMode")
    private boolean computerGetAutoMode() throws ComputerException {
        this.validateHasValidFormula("Auto-Mode");
        return this.getAutoMode();
    }

    @ComputerMethod
    private void setAutoMode(boolean mode) throws ComputerException {
        this.validateHasValidFormula("Auto-Mode");
        if (this.autoMode != mode) {
            this.nextMode();
        }
    }
}

