/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.SecurityMode;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class SecurityRecipeData
implements RecipeUpgradeData<SecurityRecipeData> {
    private final UUID owner;
    private final SecurityMode mode;

    SecurityRecipeData(UUID owner, SecurityMode mode) {
        this.owner = owner;
        this.mode = mode;
    }

    @Override
    @Nullable
    public SecurityRecipeData merge(SecurityRecipeData other) {
        if (this.owner.equals(other.owner)) {
            return MekanismAPI.getSecurityUtils().moreRestrictive(this.mode, other.mode) ? other : this;
        }
        return null;
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        return true;
    }
}

