/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class TransitRequest {
    private final TransitResponse EMPTY = new TransitResponse(ItemStack.f_41583_, null);

    public static SimpleTransitRequest simple(ItemStack stack) {
        return new SimpleTransitRequest(stack);
    }

    public static TransitRequest anyItem(BlockEntity tile, Direction side, int amount) {
        return TransitRequest.definedItem(tile, side, amount, Finder.ANY);
    }

    public static TransitRequest definedItem(BlockEntity tile, Direction side, int amount, Finder finder) {
        return TransitRequest.definedItem(tile, side, 1, amount, finder);
    }

    public static TransitRequest definedItem(BlockEntity tile, Direction side, int min, int max, Finder finder) {
        TileTransitRequest ret = new TileTransitRequest(tile, side);
        IItemHandler inventory = InventoryUtils.assertItemHandler("TransitRequest", tile, side);
        if (inventory == null) {
            return ret;
        }
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack stack = inventory.extractItem(i, max, true);
            if (stack.m_41619_() || !finder.modifies(stack)) continue;
            HashedItem hashed = HashedItem.raw(stack);
            int toUse = Math.min(stack.m_41613_(), max - ret.getCount(hashed));
            if (toUse == 0) continue;
            ret.addItem(StackUtils.size(stack, toUse), i);
        }
        ret.getItemMap().entrySet().removeIf(entry -> ((TileTransitRequest.TileItemData)entry.getValue()).getTotalCount() < min);
        return ret;
    }

    public abstract Collection<? extends ItemData> getItemData();

    @NotNull
    public TransitResponse addToInventory(BlockEntity tile, Direction side, int min, boolean force) {
        if (force && tile instanceof TileEntityLogisticalSorter) {
            TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)tile;
            return sorter.sendHome(this);
        }
        if (this.isEmpty()) {
            return this.getEmptyResponse();
        }
        Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, ForgeCapabilities.ITEM_HANDLER, side.m_122424_()).resolve();
        if (capability.isPresent()) {
            TransitResponse response;
            IItemHandler inventory = (IItemHandler)capability.get();
            if (min > 1 && ((response = TransporterManager.getPredictedInsert(inventory, this)).isEmpty() || response.getSendingAmount() < min)) {
                return this.getEmptyResponse();
            }
            for (ItemData itemData : this.getItemData()) {
                ItemStack origInsert = StackUtils.size(itemData.getStack(), itemData.getTotalCount());
                ItemStack toInsert = origInsert.m_41777_();
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    if (!inventory.isItemValid(i, toInsert) || !(toInsert = inventory.insertItem(i, toInsert, false)).m_41619_()) continue;
                    return this.createResponse(origInsert, itemData);
                }
                if (!TransporterManager.didEmit(origInsert, toInsert)) continue;
                return this.createResponse(TransporterManager.getToUse(origInsert, toInsert), itemData);
            }
        }
        return this.getEmptyResponse();
    }

    public boolean isEmpty() {
        return this.getItemData().isEmpty();
    }

    @NotNull
    public TransitResponse createResponse(ItemStack inserted, ItemData data) {
        return new TransitResponse(inserted, data);
    }

    public TransitResponse createSimpleResponse() {
        ItemData data = this.getItemData().stream().findFirst().orElse(null);
        return data == null ? this.getEmptyResponse() : this.createResponse(data.itemType.createStack(data.totalCount), data);
    }

    @NotNull
    public TransitResponse getEmptyResponse() {
        return this.EMPTY;
    }

    public static class TransitResponse {
        private final ItemStack inserted;
        private final ItemData slotData;

        public TransitResponse(@NotNull ItemStack inserted, ItemData slotData) {
            this.inserted = inserted;
            this.slotData = slotData;
        }

        public int getSendingAmount() {
            return this.inserted.m_41613_();
        }

        public ItemData getSlotData() {
            return this.slotData;
        }

        public ItemStack getStack() {
            return this.inserted;
        }

        public boolean isEmpty() {
            return this.inserted.m_41619_() || this.slotData.getTotalCount() == 0;
        }

        public ItemStack getRejected() {
            if (this.isEmpty()) {
                return ItemStack.f_41583_;
            }
            return StackUtils.size(this.slotData.getStack(), this.slotData.getStack().m_41613_() - this.getSendingAmount());
        }

        public ItemStack use(int amount) {
            return this.slotData.use(amount);
        }

        public ItemStack useAll() {
            return this.use(this.getSendingAmount());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransitResponse other = (TransitResponse)o;
            return (this.inserted == other.inserted || ItemStack.m_41728_((ItemStack)this.inserted, (ItemStack)other.inserted)) && this.slotData.equals(other.slotData);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.inserted.m_41720_().hashCode();
            code = 31 * code + this.inserted.m_41613_();
            if (this.inserted.m_41782_()) {
                code = 31 * code + this.inserted.m_41783_().hashCode();
            }
            code = 31 * code + this.slotData.hashCode();
            return code;
        }
    }

    public static class ItemData {
        private final HashedItem itemType;
        protected int totalCount;

        public ItemData(HashedItem itemType) {
            this.itemType = itemType;
        }

        public HashedItem getItemType() {
            return this.itemType;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public ItemStack getStack() {
            return this.getItemType().createStack(this.getTotalCount());
        }

        public ItemStack use(int amount) {
            Mekanism.logger.error("Can't 'use' with this type of TransitResponse: {}", (Object)this.getClass().getName());
            return ItemStack.f_41583_;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemData itemData = (ItemData)o;
            return this.totalCount == itemData.totalCount && this.itemType.equals(itemData.itemType);
        }

        public int hashCode() {
            return Objects.hash(this.itemType, this.totalCount);
        }
    }

    public static class SimpleTransitRequest
    extends TransitRequest {
        private final List<ItemData> slotData = new ArrayList<ItemData>();

        protected SimpleTransitRequest(ItemStack stack) {
            this.slotData.add(new SimpleItemData(stack));
        }

        public Collection<ItemData> getItemData() {
            return this.slotData;
        }

        public static class SimpleItemData
        extends ItemData {
            public SimpleItemData(ItemStack stack) {
                super(HashedItem.create(stack));
                this.totalCount = stack.m_41613_();
            }
        }
    }
}

