/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.text.EnumColor;
import mekanism.client.key.MekKeyHandler;
import mekanism.client.key.MekanismKeyHandler;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.ChemicalTankSpec;
import mekanism.common.capabilities.chemical.item.RateLimitMultiTankGasHandler;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.item.RateLimitEnergyHandler;
import mekanism.common.capabilities.fluid.item.RateLimitMultiTankFluidHandler;
import mekanism.common.capabilities.laser.item.LaserDissipationHandler;
import mekanism.common.capabilities.radiation.item.RadiationShieldingHandler;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.shared.ModuleEnergyUnit;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemHazmatSuitArmor;
import mekanism.common.item.gear.ItemSpecialArmor;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemMekaSuitArmor
extends ItemSpecialArmor
implements IModuleContainerItem,
IModeItem,
IJetpackItem,
IAttributeRefresher {
    private static final Set<DamageSource> ALWAYS_SUPPORTED_SOURCES = new LinkedHashSet<DamageSource>(List.of(DamageSource.f_19321_, DamageSource.f_19314_, DamageSource.f_19311_, DamageSource.f_19323_, DamageSource.f_19324_, DamageSource.f_19315_, DamageSource.f_19322_, DamageSource.f_19316_, DamageSource.f_19318_, DamageSource.f_19309_, DamageSource.f_19305_, DamageSource.f_19310_, DamageSource.f_19308_, DamageSource.f_19306_, DamageSource.f_19307_, DamageSource.f_19325_, DamageSource.f_19320_, DamageSource.f_146701_, DamageSource.f_146702_, DamageSource.f_146703_));
    private static final MekaSuitMaterial MEKASUIT_MATERIAL = new MekaSuitMaterial();
    private final AttributeCache attributeCache;
    private final List<ChemicalTankSpec<Gas>> gasTankSpecs = new ArrayList<ChemicalTankSpec<Gas>>();
    private final List<ChemicalTankSpec<Gas>> gasTankSpecsView = Collections.unmodifiableList(this.gasTankSpecs);
    private final List<RateLimitMultiTankFluidHandler.FluidTankSpec> fluidTankSpecs = new ArrayList<RateLimitMultiTankFluidHandler.FluidTankSpec>();
    private final List<RateLimitMultiTankFluidHandler.FluidTankSpec> fluidTankSpecsView = Collections.unmodifiableList(this.fluidTankSpecs);
    private final float absorption;
    private final double laserDissipation;
    private final double laserRefraction;

    public static Set<DamageSource> getSupportedSources() {
        return Collections.unmodifiableSet(ALWAYS_SUPPORTED_SOURCES);
    }

    public ItemMekaSuitArmor(EquipmentSlot slot, Item.Properties properties) {
        super(MEKASUIT_MATERIAL, slot, properties.m_41497_(Rarity.EPIC).setNoRepair().m_41487_(1));
        CachedIntValue armorConfig;
        if (slot == EquipmentSlot.HEAD) {
            this.fluidTankSpecs.add(RateLimitMultiTankFluidHandler.FluidTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitNutritionalTransferRate, MekanismConfig.gear.mekaSuitNutritionalMaxStorage, fluid -> fluid.getFluid() == MekanismFluids.NUTRITIONAL_PASTE.getFluid(), stack -> this.hasModule((ItemStack)stack, MekanismModules.NUTRITIONAL_INJECTION_UNIT)));
            this.absorption = 0.15f;
            this.laserDissipation = 0.15;
            this.laserRefraction = 0.2;
            armorConfig = MekanismConfig.gear.mekaSuitHelmetArmor;
        } else if (slot == EquipmentSlot.CHEST) {
            this.gasTankSpecs.add(ChemicalTankSpec.createFillOnly(MekanismConfig.gear.mekaSuitJetpackTransferRate, MekanismConfig.gear.mekaSuitJetpackMaxStorage, gas -> gas == MekanismGases.HYDROGEN.get(), stack -> this.hasModule((ItemStack)stack, MekanismModules.JETPACK_UNIT)));
            this.absorption = 0.4f;
            this.laserDissipation = 0.3;
            this.laserRefraction = 0.4;
            armorConfig = MekanismConfig.gear.mekaSuitBodyArmorArmor;
        } else if (slot == EquipmentSlot.LEGS) {
            this.absorption = 0.3f;
            this.laserDissipation = 0.1875;
            this.laserRefraction = 0.25;
            armorConfig = MekanismConfig.gear.mekaSuitPantsArmor;
        } else if (slot == EquipmentSlot.FEET) {
            this.absorption = 0.15f;
            this.laserDissipation = 0.1125;
            this.laserRefraction = 0.15;
            armorConfig = MekanismConfig.gear.mekaSuitBootsArmor;
        } else {
            throw new IllegalArgumentException("Unknown Equipment Slot Type");
        }
        this.attributeCache = new AttributeCache(this, armorConfig, MekanismConfig.gear.mekaSuitToughness, MekanismConfig.gear.mekaSuitKnockbackResistance);
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(RenderPropertiesProvider.mekaSuit());
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        if (MekKeyHandler.isKeyPressed(MekanismKeyHandler.detailsKey)) {
            this.addModuleDetails(stack, tooltip);
        } else {
            StorageUtils.addStoredEnergy(stack, tooltip, true);
            if (!this.gasTankSpecs.isEmpty()) {
                StorageUtils.addStoredGas(stack, tooltip, true, false);
            }
            if (!this.fluidTankSpecs.isEmpty()) {
                StorageUtils.addStoredFluid(stack, tooltip, true);
            }
            tooltip.add((Component)MekanismLang.HOLD_FOR_MODULES.translateColored(EnumColor.GRAY, EnumColor.INDIGO, MekanismKeyHandler.detailsKey.m_90863_()));
        }
    }

    public boolean makesPiglinsNeutral(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return true;
    }

    public boolean isEnderMask(@NotNull ItemStack stack, @NotNull Player player, @NotNull EnderMan enderman) {
        return this.m_40402_() == EquipmentSlot.HEAD;
    }

    public boolean canWalkOnPowderedSnow(@NotNull ItemStack stack, @NotNull LivingEntity wearer) {
        return this.m_40402_() == EquipmentSlot.FEET;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return StorageUtils.getEnergyBarWidth(stack);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return MekanismConfig.client.energyColor.get();
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return super.isNotReplaceableByPickAction(stack, player, inventorySlot) || ItemDataUtils.hasData(stack, "modules", 10);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41619_()) {
            return 0;
        }
        ListTag enchantments = ItemDataUtils.getList(stack, "Enchantments");
        return Math.max(MekanismUtils.getEnchantmentLevel(enchantments, enchantment), super.getEnchantmentLevel(stack, enchantment));
    }

    public Map<Enchantment, Integer> getAllEnchantments(ItemStack stack) {
        Map enchantments = EnchantmentHelper.m_44882_((ListTag)ItemDataUtils.getList(stack, "Enchantments"));
        super.getAllEnchantments(stack).forEach((enchantment, level) -> enchantments.merge(enchantment, level, Math::max));
        return enchantments;
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        super.m_6787_(group, items);
        if (this.m_220152_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            items.add((Object)StorageUtils.getFilledEnergyVariant(stack, this.getMaxEnergy(stack)));
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        for (Module module : this.getModules(stack)) {
            module.tick(player);
        }
    }

    @Override
    protected void gatherCapabilities(List<ItemCapabilityWrapper.ItemCapability> capabilities, ItemStack stack, CompoundTag nbt) {
        super.gatherCapabilities(capabilities, stack, nbt);
        capabilities.add(RateLimitEnergyHandler.create(() -> this.getChargeRate(stack), () -> this.getMaxEnergy(stack), BasicEnergyContainer.manualOnly, BasicEnergyContainer.alwaysTrue));
        capabilities.add(RadiationShieldingHandler.create(item -> this.isModuleEnabled((ItemStack)item, MekanismModules.RADIATION_SHIELDING_UNIT) ? ItemHazmatSuitArmor.getShieldingByArmor(this.f_40377_) : 0.0));
        capabilities.add(LaserDissipationHandler.create(item -> this.isModuleEnabled((ItemStack)item, MekanismModules.LASER_DISSIPATION_UNIT) ? this.laserDissipation : 0.0, item -> this.isModuleEnabled((ItemStack)item, MekanismModules.LASER_DISSIPATION_UNIT) ? this.laserRefraction : 0.0));
        if (!this.gasTankSpecs.isEmpty()) {
            capabilities.add(RateLimitMultiTankGasHandler.create(this.gasTankSpecs));
        }
        if (!this.fluidTankSpecs.isEmpty()) {
            capabilities.add(RateLimitMultiTankFluidHandler.create(this.fluidTankSpecs));
        }
    }

    public List<ChemicalTankSpec<Gas>> getGasTankSpecs() {
        return this.gasTankSpecsView;
    }

    public List<RateLimitMultiTankFluidHandler.FluidTankSpec> getFluidTankSpecs() {
        return this.fluidTankSpecsView;
    }

    @NotNull
    public GasStack useGas(ItemStack stack, Gas type, long amount) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            return gasHandlerItem.extractChemical(new GasStack(type, amount), Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }

    public GasStack getContainedGas(ItemStack stack, Gas type) {
        Optional capability = stack.getCapability(Capabilities.GAS_HANDLER).resolve();
        if (capability.isPresent()) {
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            for (int i = 0; i < gasHandlerItem.getTanks(); ++i) {
                GasStack gasInTank = (GasStack)gasHandlerItem.getChemicalInTank(i);
                if (gasInTank.getType() != type) continue;
                return gasInTank;
            }
        }
        return GasStack.EMPTY;
    }

    public FluidStack getContainedFluid(ItemStack stack, FluidStack type) {
        Optional capability = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (capability.isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)capability.get();
            for (int i = 0; i < fluidHandlerItem.getTanks(); ++i) {
                FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(i);
                if (!fluidInTank.isFluidEqual(type)) continue;
                return fluidInTank;
            }
        }
        return FluidStack.EMPTY;
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, boolean displayChangeMessage) {
        for (Module module : this.getModules(stack)) {
            if (!module.handlesModeChange()) continue;
            module.changeMode(player, stack, shift, displayChangeMessage);
            return;
        }
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @NotNull EquipmentSlot slotType) {
        return slotType == this.m_40402_() && this.getModules(stack).stream().anyMatch(Module::handlesModeChange);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        IModule module;
        if (this.f_40377_ == EquipmentSlot.CHEST && !entity.m_6144_() && (module = this.getModule(stack, MekanismModules.ELYTRA_UNIT)) != null && module.isEnabled() && module.canUseEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get())) {
            IModule jetpack = this.getModule(stack, MekanismModules.JETPACK_UNIT);
            return jetpack == null || !jetpack.isEnabled() || ((ModuleJetpackUnit)jetpack.getCustomInstance()).getMode() != IJetpackItem.JetpackMode.HOVER || this.getContainedGas(stack, (Gas)MekanismGases.HYDROGEN.get()).isEmpty();
        }
        return false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTicks;
        if (!entity.f_19853_.f_46443_ && (nextFlightTicks = flightTicks + 1) % 10 == 0) {
            IModule module;
            if (nextFlightTicks % 20 == 0 && (module = this.getModule(stack, MekanismModules.ELYTRA_UNIT)) != null && module.isEnabled()) {
                module.useEnergy(entity, (FloatingLong)MekanismConfig.gear.mekaSuitElytraEnergyUsage.get());
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    @Override
    public boolean canUseJetpack(ItemStack stack) {
        return this.f_40377_ == EquipmentSlot.CHEST && (this.isModuleEnabled(stack, MekanismModules.JETPACK_UNIT) ? ChemicalUtil.hasChemical(stack, (Gas)MekanismGases.HYDROGEN.get()) : this.getModules(stack).stream().anyMatch(module -> module.isEnabled() && module.getData().isExclusive(ModuleData.ExclusiveFlag.OVERRIDE_JUMP.getMask())));
    }

    @Override
    public IJetpackItem.JetpackMode getJetpackMode(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.JETPACK_UNIT);
        if (module != null && module.isEnabled()) {
            return ((ModuleJetpackUnit)module.getCustomInstance()).getMode();
        }
        return IJetpackItem.JetpackMode.DISABLED;
    }

    @Override
    public void useJetpackFuel(ItemStack stack) {
        this.useGas(stack, (Gas)MekanismGases.HYDROGEN.get(), 1L);
    }

    private FloatingLong getMaxEnergy(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaSuitBaseEnergyCapacity.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getEnergyCapacity(module);
    }

    private FloatingLong getChargeRate(ItemStack stack) {
        IModule module = this.getModule(stack, MekanismModules.ENERGY_UNIT);
        return module == null ? (FloatingLong)MekanismConfig.gear.mekaSuitBaseChargeRate.get() : ((ModuleEnergyUnit)module.getCustomInstance()).getChargeRate(module);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, @NotNull ItemStack stack) {
        return slot == this.m_40402_() ? (Multimap)this.attributeCache.get() : ImmutableMultimap.of();
    }

    @Override
    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = f_40380_[this.m_40402_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.m_40401_().m_6649_(), AttributeModifier.Operation.ADDITION));
    }

    public int m_40404_() {
        return this.m_40401_().m_7365_(this.m_40402_());
    }

    public float m_40405_() {
        return this.m_40401_().m_6651_();
    }

    public static float getDamageAbsorbed(Player player, DamageSource source, float amount) {
        return ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, null);
    }

    public static boolean tryAbsorbAll(Player player, DamageSource source, float amount) {
        ArrayList<Runnable> energyUsageCallbacks = new ArrayList<Runnable>(4);
        if (ItemMekaSuitArmor.getDamageAbsorbed(player, source, amount, energyUsageCallbacks) >= 1.0f) {
            for (Runnable energyUsageCallback : energyUsageCallbacks) {
                energyUsageCallback.run();
            }
            return true;
        }
        return false;
    }

    private static float getDamageAbsorbed(Player player, DamageSource source, float amount, @Nullable List<Runnable> energyUseCallbacks) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float ratioAbsorbed = 0.0f;
        ArrayList<FoundArmorDetails> armorDetails = new ArrayList<FoundArmorDetails>();
        for (Object stack : player.m_6168_()) {
            float absorption;
            ICustomModule.ModuleDamageAbsorbInfo damageAbsorbInfo;
            Module module;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof ItemMekaSuitArmor)) continue;
            ItemMekaSuitArmor armor = (ItemMekaSuitArmor)item;
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, 0);
            if (energyContainer == null) continue;
            FoundArmorDetails details = new FoundArmorDetails(energyContainer, armor);
            armorDetails.add(details);
            Iterator iterator = details.armor.getModules((ItemStack)stack).iterator();
            while (!(!iterator.hasNext() || (module = (Module)iterator.next()).isEnabled() && (damageAbsorbInfo = ItemMekaSuitArmor.getModuleDamageAbsorbInfo(module, source)) != null && (ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption = damageAbsorbInfo.absorptionRatio().getAsFloat(), ratioAbsorbed, damageAbsorbInfo.energyCost())) >= 1.0f)) {
            }
            if (!(ratioAbsorbed >= 1.0f)) continue;
            break;
        }
        if (ratioAbsorbed < 1.0f) {
            FloatSupplier absorbRatio = null;
            for (FoundArmorDetails details : armorDetails) {
                float absorption;
                if ((absorbRatio != null || (ALWAYS_SUPPORTED_SOURCES.contains(source) || !source.m_19376_()) && (absorbRatio = (FloatSupplier)MekanismConfig.gear.mekaSuitDamageRatios.getOrDefault(source, MekanismConfig.gear.mekaSuitUnspecifiedDamageRatio)).getAsFloat() != 0.0f) && !((ratioAbsorbed += ItemMekaSuitArmor.absorbDamage(details.usageInfo, amount, absorption = details.armor.absorption * absorbRatio.getAsFloat(), ratioAbsorbed, MekanismConfig.gear.mekaSuitEnergyUsageDamage)) >= 1.0f)) continue;
                break;
            }
        }
        for (FoundArmorDetails details : armorDetails) {
            if (details.usageInfo.energyUsed.isZero()) continue;
            if (energyUseCallbacks == null) {
                details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL);
                continue;
            }
            energyUseCallbacks.add(() -> details.energyContainer.extract(details.usageInfo.energyUsed, Action.EXECUTE, AutomationType.MANUAL));
        }
        return Math.min(ratioAbsorbed, 1.0f);
    }

    @Nullable
    private static <MODULE extends ICustomModule<MODULE>> ICustomModule.ModuleDamageAbsorbInfo getModuleDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return module.getCustomInstance().getDamageAbsorbInfo(module, damageSource);
    }

    private static float absorbDamage(EnergyUsageInfo usageInfo, float amount, float absorption, float currentAbsorbed, FloatingLongSupplier energyCost) {
        float toAbsorb = amount * (absorption = Math.min(1.0f - currentAbsorbed, absorption));
        if (toAbsorb > 0.0f) {
            FloatingLong usage = energyCost.get().multiply(toAbsorb);
            if (usage.isZero()) {
                return absorption;
            }
            if (usageInfo.energyAvailable.greaterOrEqual(usage)) {
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usage);
                usageInfo.energyAvailable = usageInfo.energyAvailable.minusEqual(usage);
                return absorption;
            }
            if (!usageInfo.energyAvailable.isZero()) {
                float absorbedPercent = usageInfo.energyAvailable.divide(usage).floatValue();
                usageInfo.energyUsed = usageInfo.energyUsed.plusEqual(usageInfo.energyAvailable);
                usageInfo.energyAvailable = FloatingLong.ZERO;
                return absorption * absorbedPercent;
            }
        }
        return 0.0f;
    }

    protected static class MekaSuitMaterial
    extends BaseSpecialArmorMaterial {
        protected MekaSuitMaterial() {
        }

        @Override
        public int m_7365_(@NotNull EquipmentSlot slot) {
            return switch (slot) {
                case EquipmentSlot.FEET -> MekanismConfig.gear.mekaSuitBootsArmor.getOrDefault();
                case EquipmentSlot.LEGS -> MekanismConfig.gear.mekaSuitPantsArmor.getOrDefault();
                case EquipmentSlot.CHEST -> MekanismConfig.gear.mekaSuitBodyArmorArmor.getOrDefault();
                case EquipmentSlot.HEAD -> MekanismConfig.gear.mekaSuitHelmetArmor.getOrDefault();
                default -> 0;
            };
        }

        @Override
        public float m_6651_() {
            return MekanismConfig.gear.mekaSuitToughness.getOrDefault();
        }

        @Override
        public float m_6649_() {
            return MekanismConfig.gear.mekaSuitKnockbackResistance.getOrDefault();
        }

        @NotNull
        public String m_6082_() {
            return "mekanism:mekasuit";
        }
    }

    private static class FoundArmorDetails {
        private final IEnergyContainer energyContainer;
        private final EnergyUsageInfo usageInfo;
        private final ItemMekaSuitArmor armor;

        public FoundArmorDetails(IEnergyContainer energyContainer, ItemMekaSuitArmor armor) {
            this.energyContainer = energyContainer;
            this.usageInfo = new EnergyUsageInfo(energyContainer.getEnergy());
            this.armor = armor;
        }
    }

    private static class EnergyUsageInfo {
        private FloatingLong energyAvailable;
        private FloatingLong energyUsed = FloatingLong.ZERO;

        public EnergyUsageInfo(FloatingLong energyAvailable) {
            this.energyAvailable = energyAvailable.copy();
        }
    }
}

