/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.list.ListPropertyData;
import org.jetbrains.annotations.NotNull;

public abstract class SyncableList<TYPE>
implements ISyncableData {
    private final Supplier<? extends @NotNull Collection<TYPE>> getter;
    private final Consumer<@NotNull List<TYPE>> setter;
    private int lastKnownHashCode;

    protected SyncableList(Supplier<? extends @NotNull Collection<TYPE>> getter, Consumer<@NotNull List<TYPE>> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @NotNull
    public List<TYPE> get() {
        Collection<TYPE> collection = this.getRaw();
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<TYPE>(collection);
    }

    @NotNull
    protected Collection<TYPE> getRaw() {
        return this.getter.get();
    }

    protected int getValueHashCode() {
        return this.getRaw().hashCode();
    }

    public void set(@NotNull List<TYPE> value) {
        this.setter.accept(value);
    }

    @Override
    public abstract ListPropertyData<TYPE> getPropertyData(short var1, ISyncableData.DirtyType var2);

    @Override
    public ISyncableData.DirtyType isDirty() {
        int valuesHashCode = this.getValueHashCode();
        if (this.lastKnownHashCode == valuesHashCode) {
            return ISyncableData.DirtyType.CLEAN;
        }
        this.lastKnownHashCode = valuesHashCode;
        return ISyncableData.DirtyType.DIRTY;
    }
}

