/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio.filter;

import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QIOItemStackFilter
extends QIOFilter<QIOItemStackFilter>
implements IItemStackFilter<QIOItemStackFilter> {
    private ItemStack itemType = ItemStack.f_41583_;
    public boolean fuzzyMode;

    public QIOItemStackFilter(ItemStack item) {
        this.itemType = item;
    }

    public QIOItemStackFilter() {
    }

    @Override
    public Finder getFinder() {
        return this.fuzzyMode ? Finder.item(this.itemType) : Finder.strict(this.itemType);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.m_128379_("fuzzyMode", this.fuzzyMode);
        this.itemType.m_41739_(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        NBTUtils.setBooleanIfPresent(nbtTags, "fuzzyMode", fuzzy -> {
            this.fuzzyMode = fuzzy;
        });
        this.itemType = ItemStack.m_41712_((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.fuzzyMode);
        buffer.m_130055_(this.itemType);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        this.fuzzyMode = dataStream.readBoolean();
        this.itemType = dataStream.m_130267_();
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + this.itemType.hashCode();
        code = 31 * code + (this.fuzzyMode ? 1 : 0);
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QIOItemStackFilter)) return false;
        QIOItemStackFilter filter = (QIOItemStackFilter)o;
        if (!filter.itemType.m_41656_(this.itemType)) return false;
        if (filter.fuzzyMode != this.fuzzyMode) return false;
        return true;
    }

    @Override
    public QIOItemStackFilter clone() {
        QIOItemStackFilter filter = new QIOItemStackFilter();
        filter.itemType = this.itemType.m_41777_();
        filter.fuzzyMode = this.fuzzyMode;
        return filter;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.QIO_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

