/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.lib.inventory.HashedItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QIOGlobalItemLookup {
    public static final QIOGlobalItemLookup INSTANCE = new QIOGlobalItemLookup();
    private static final String DATA_HANDLER_NAME = "qio_type_cache";
    @Nullable
    private QIOGlobalItemLookupDataHandler dataHandler;
    private BiMap<UUID, HashedItem> itemCache = HashBiMap.create();

    private QIOGlobalItemLookup() {
    }

    @Nullable
    public UUID getUUIDForType(HashedItem item) {
        return (UUID)this.itemCache.inverse().get((Object)item);
    }

    public UUID getOrTrackUUID(HashedItem item) {
        SerializedHashedItem serializable = new SerializedHashedItem(item);
        return (UUID)this.itemCache.inverse().computeIfAbsent((Object)serializable, s -> {
            this.markDirty();
            return UUID.randomUUID();
        });
    }

    @Nullable
    public HashedItem getTypeByUUID(@Nullable UUID uuid) {
        return uuid == null ? null : (HashedItem)this.itemCache.get((Object)uuid);
    }

    private void markDirty() {
        if (this.dataHandler != null) {
            this.dataHandler.m_77762_();
        }
    }

    public void createOrLoad() {
        if (this.dataHandler == null) {
            DimensionDataStorage savedData = ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
            this.dataHandler = (QIOGlobalItemLookupDataHandler)savedData.m_164861_(tag -> {
                QIOGlobalItemLookupDataHandler handler = new QIOGlobalItemLookupDataHandler();
                handler.load((CompoundTag)tag);
                return handler;
            }, QIOGlobalItemLookupDataHandler::new, DATA_HANDLER_NAME);
        }
    }

    public void reset() {
        this.itemCache = HashBiMap.create();
        this.dataHandler = null;
    }

    private static class SerializedHashedItem
    extends HashedItem {
        private CompoundTag nbtRepresentation;

        @Nullable
        protected static SerializedHashedItem read(CompoundTag nbtRepresentation) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbtRepresentation);
            return stack.m_41619_() ? null : new SerializedHashedItem(stack);
        }

        private SerializedHashedItem(ItemStack stack) {
            super(stack);
        }

        protected SerializedHashedItem(HashedItem other) {
            super(other);
        }

        public CompoundTag getNbtRepresentation() {
            if (this.nbtRepresentation == null) {
                this.nbtRepresentation = this.getStack().serializeNBT();
                this.nbtRepresentation.m_128344_("Count", (byte)1);
            }
            return this.nbtRepresentation;
        }
    }

    private static class QIOGlobalItemLookupDataHandler
    extends SavedData {
        private QIOGlobalItemLookupDataHandler() {
        }

        private void load(@NotNull CompoundTag nbt) {
            for (String key : nbt.m_128431_()) {
                UUID uuid;
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException e) {
                    Mekanism.logger.warn("Invalid UUID ({}) stored in {} saved data.", (Object)key, (Object)QIOGlobalItemLookup.DATA_HANDLER_NAME);
                    continue;
                }
                ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(key));
                if (stack.m_41619_()) {
                    Mekanism.logger.debug("Failed to read corresponding item for UUID ({}) stored in {} saved data. This most likely means the mod adding the item was removed.", (Object)uuid, (Object)QIOGlobalItemLookup.DATA_HANDLER_NAME);
                    continue;
                }
                QIOGlobalItemLookup.INSTANCE.itemCache.put((Object)uuid, (Object)new SerializedHashedItem(stack));
            }
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag nbt) {
            for (Map.Entry entry : QIOGlobalItemLookup.INSTANCE.itemCache.entrySet()) {
                nbt.m_128365_(((UUID)entry.getKey()).toString(), (Tag)((SerializedHashedItem)entry.getValue()).getNbtRepresentation());
            }
            return nbt;
        }

        public void m_77757_(@NotNull File file) {
            if (this.m_77764_()) {
                File tempFile = file.toPath().getParent().resolve(file.getName() + ".temp").toFile();
                super.m_77757_(tempFile);
                if (file.exists() && !file.delete()) {
                    Mekanism.logger.error("Failed to delete " + file.getName());
                }
                if (!tempFile.renameTo(file)) {
                    Mekanism.logger.error("Failed to rename " + tempFile.getName());
                }
            }
        }
    }
}

