/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Arrays;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.tier.TransporterTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class DiversionTransporter
extends LogisticalTransporterBase {
    public final DiversionControl[] modes = new DiversionControl[EnumUtils.DIRECTIONS.length];

    public DiversionTransporter(TileEntityTransmitter tile) {
        super(tile, TransporterTier.BASIC);
        Arrays.fill(this.modes, DiversionControl.DISABLED);
    }

    @Override
    public void onNeighborBlockChange(Direction side) {
        byte current = this.getAllCurrentConnections();
        this.refreshConnections();
        if (current != this.getAllCurrentConnections()) {
            this.markDirtyTransmitters();
        }
    }

    private void readModes(@NotNull CompoundTag tag) {
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setEnumIfPresent(tag, "mode" + index, DiversionControl::byIndexStatic, mode -> {
                this.modes[index] = mode;
            });
        }
    }

    @NotNull
    private CompoundTag writeModes(@NotNull CompoundTag nbtTags) {
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            NBTUtils.writeEnum(nbtTags, "mode" + i, this.modes[i]);
        }
        return nbtTags;
    }

    @Override
    public void read(@NotNull CompoundTag nbtTags) {
        super.read(nbtTags);
        this.readModes(nbtTags);
    }

    @Override
    @NotNull
    public CompoundTag write(@NotNull CompoundTag nbtTags) {
        return this.writeModes(super.write(nbtTags));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(CompoundTag updateTag) {
        return this.writeModes(super.getReducedUpdateTag(updateTag));
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.readModes(tag);
    }

    public void updateMode(Direction side, DiversionControl mode) {
        int ordinal = side.ordinal();
        if (this.modes[ordinal] != mode) {
            this.modes[ordinal] = mode;
            this.refreshConnections();
            this.notifyTileChange();
            this.getTransmitterTile().sendUpdatePacket();
        }
    }

    @Override
    public InteractionResult onRightClick(Player player, Direction side) {
        side = this.getTransmitterTile().getSideLookingAt(player, side);
        DiversionControl newMode = (DiversionControl)this.modes[side.ordinal()].getNext();
        this.updateMode(side, newMode);
        player.m_213846_(MekanismUtils.logFormat(MekanismLang.TOGGLE_DIVERTER.translate(EnumColor.RED, newMode)));
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean canConnect(Direction side) {
        if (super.canConnect(side)) {
            DiversionControl mode = this.modes[side.ordinal()];
            if (mode == DiversionControl.HIGH) {
                return this.isGettingPowered();
            }
            if (mode == DiversionControl.LOW) {
                return !this.isGettingPowered();
            }
            return true;
        }
        return false;
    }

    private boolean isGettingPowered() {
        return WorldUtils.isGettingPowered(this.getTileWorld(), this.getTilePos());
    }

    @NothingNullByDefault
    public static enum DiversionControl implements IIncrementalEnum<DiversionControl>,
    IHasTextComponent
    {
        DISABLED(MekanismLang.DIVERSION_CONTROL_DISABLED),
        HIGH(MekanismLang.DIVERSION_CONTROL_HIGH),
        LOW(MekanismLang.DIVERSION_CONTROL_LOW);

        private static final DiversionControl[] MODES;
        private final ILangEntry langEntry;

        private DiversionControl(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        public DiversionControl byIndex(int index) {
            return DiversionControl.byIndexStatic(index);
        }

        public static DiversionControl byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = DiversionControl.values();
        }
    }
}

