/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryNetwork
extends DynamicNetwork<IItemHandler, InventoryNetwork, LogisticalTransporterBase> {
    private final Map<BlockPos, LogisticalTransporterBase> positionedTransmitters = new Object2ObjectOpenHashMap();

    public InventoryNetwork(UUID networkID) {
        super(networkID);
    }

    public InventoryNetwork(Collection<InventoryNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    public List<AcceptorData> calculateAcceptors(TransitRequest request, TransporterStack stack, Long2ObjectMap<ChunkAccess> chunkMap) {
        ArrayList<AcceptorData> toReturn = new ArrayList<AcceptorData>();
        for (Map.Entry entry : this.acceptorCache.getAcceptorEntrySet()) {
            BlockEntity acceptor;
            BlockPos pos = entry.getKey();
            if (pos.equals((Object)stack.homeLocation) || (acceptor = WorldUtils.getTileEntity((LevelAccessor)this.getWorld(), chunkMap, pos)) == null) continue;
            HashMap<TransitRequest.TransitResponse, AcceptorData> dataMap = new HashMap<TransitRequest.TransitResponse, AcceptorData>();
            Coord4D position = new Coord4D((Vec3i)pos, this.getWorld());
            for (Map.Entry acceptorEntry : entry.getValue().entrySet()) {
                TransitRequest.TransitResponse response;
                EnumColor configColor;
                ISideConfiguration config;
                Optional handler = acceptorEntry.getValue().resolve();
                if (!handler.isPresent()) continue;
                Direction side = acceptorEntry.getKey();
                if (acceptor instanceof ISideConfiguration && (config = (ISideConfiguration)acceptor).getEjector().hasStrictInput() && (configColor = config.getEjector().getInputColor(RelativeSide.fromDirections(config.getDirection(), side))) != null && configColor != stack.color || (response = TransporterManager.getPredictedInsert(position, side, (IItemHandler)handler.get(), request)).isEmpty()) continue;
                Direction opposite = side.m_122424_();
                AcceptorData data = (AcceptorData)dataMap.get(response);
                if (data == null) {
                    data = new AcceptorData(pos, response, opposite);
                    dataMap.put(response, data);
                    toReturn.add(data);
                    continue;
                }
                data.sides.add(opposite);
            }
        }
        return toReturn;
    }

    @Nullable
    public LogisticalTransporterBase getTransmitter(BlockPos pos) {
        return this.positionedTransmitters.get(pos);
    }

    @Override
    protected void addTransmitterFromCommit(LogisticalTransporterBase transmitter) {
        super.addTransmitterFromCommit(transmitter);
        this.positionedTransmitters.put(transmitter.getTilePos(), transmitter);
    }

    @Override
    public void addTransmitter(LogisticalTransporterBase transmitter) {
        super.addTransmitter(transmitter);
        this.positionedTransmitters.put(transmitter.getTilePos(), transmitter);
    }

    @Override
    public void removeTransmitter(LogisticalTransporterBase transmitter) {
        this.removePositionedTransmitter(transmitter);
        super.removeTransmitter(transmitter);
    }

    private void removePositionedTransmitter(LogisticalTransporterBase transmitter) {
        BlockPos pos = transmitter.getTilePos();
        LogisticalTransporterBase currentTransmitter = this.getTransmitter(pos);
        if (currentTransmitter != null) {
            if (currentTransmitter != transmitter) {
                Level world = this.world;
                if (world == null) {
                    world = transmitter.getTileWorld();
                }
                if (world != null && world.m_5776_()) {
                    return;
                }
                Mekanism.logger.warn("Removed transmitter at position: {} in {} was different than expected.", (Object)pos, world == null ? null : world.m_46472_().m_135782_());
            }
            this.positionedTransmitters.remove(pos);
        }
    }

    @Override
    protected void removeInvalid(@Nullable LogisticalTransporterBase triggerTransmitter) {
        Iterator iterator = this.transmitters.iterator();
        while (iterator.hasNext()) {
            LogisticalTransporterBase transmitter = (LogisticalTransporterBase)iterator.next();
            if (transmitter.isValid()) continue;
            iterator.remove();
            this.removePositionedTransmitter(transmitter);
        }
    }

    @Override
    public List<LogisticalTransporterBase> adoptTransmittersAndAcceptorsFrom(InventoryNetwork net) {
        this.positionedTransmitters.putAll(net.positionedTransmitters);
        return super.adoptTransmittersAndAcceptorsFrom(net);
    }

    @Override
    public void commit() {
        super.commit();
        PathfinderCache.onChanged(this);
    }

    @Override
    public void deregister() {
        super.deregister();
        this.positionedTransmitters.clear();
        PathfinderCache.onChanged(this);
    }

    public String toString() {
        return "[InventoryNetwork] " + this.transmittersSize() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    @NotNull
    public Component getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.INVENTORY_NETWORK, this.transmittersSize(), this.getAcceptorCount());
    }

    public static class AcceptorData {
        private final BlockPos location;
        private final TransitRequest.TransitResponse response;
        private final Set<Direction> sides;

        protected AcceptorData(BlockPos pos, TransitRequest.TransitResponse ret, Direction side) {
            this.location = pos;
            this.response = ret;
            this.sides = EnumSet.of(side);
        }

        public TransitRequest.TransitResponse getResponse() {
            return this.response;
        }

        public BlockPos getLocation() {
            return this.location;
        }

        public Set<Direction> getSides() {
            return this.sides;
        }
    }
}

