/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import mekanism.common.content.filter.BaseFilter;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class MinerFilter<FILTER extends MinerFilter<FILTER>>
extends BaseFilter<FILTER> {
    public Item replaceTarget = Items.f_41852_;
    public boolean requiresReplacement;

    protected MinerFilter() {
    }

    protected MinerFilter(FILTER filter) {
        this.replaceTarget = ((MinerFilter)filter).replaceTarget;
        this.requiresReplacement = ((MinerFilter)filter).requiresReplacement;
    }

    public boolean replaceTargetMatches(@NotNull Item target) {
        return this.replaceTarget != Items.f_41852_ && this.replaceTarget == target;
    }

    public abstract boolean canFilter(BlockState var1);

    public abstract boolean hasBlacklistedElement();

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.m_128379_("requireStack", this.requiresReplacement);
        if (this.replaceTarget != Items.f_41852_) {
            NBTUtils.writeRegistryEntry(nbtTags, "replaceStack", ForgeRegistries.ITEMS, this.replaceTarget);
        }
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        this.requiresReplacement = nbtTags.m_128471_("requireStack");
        this.replaceTarget = NBTUtils.readRegistryEntry(nbtTags, "replaceStack", ForgeRegistries.ITEMS, Items.f_41852_);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.requiresReplacement);
        buffer.writeRegistryId(ForgeRegistries.ITEMS, (Object)this.replaceTarget);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        this.requiresReplacement = dataStream.readBoolean();
        this.replaceTarget = (Item)dataStream.readRegistryIdSafe(Item.class);
    }

    @Override
    public int hashCode() {
        int code = 1;
        code = 31 * code + this.replaceTarget.hashCode();
        code = 31 * code + (this.requiresReplacement ? 1 : 0);
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MinerFilter)) return false;
        MinerFilter filter = (MinerFilter)o;
        if (filter.requiresReplacement != this.requiresReplacement) return false;
        if (filter.replaceTarget != this.replaceTarget) return false;
        return true;
    }
}

