/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.filter;

import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerMaterialFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.content.transporter.SorterItemStackFilter;
import mekanism.common.content.transporter.SorterMaterialFilter;
import mekanism.common.content.transporter.SorterModIDFilter;
import mekanism.common.content.transporter.SorterTagFilter;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFilter<FILTER extends BaseFilter<FILTER>>
implements IFilter<FILTER> {
    @Override
    public abstract FILTER clone();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        NBTUtils.writeEnum(nbtTags, "type", this.getFilterType());
        return nbtTags;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.getFilterType());
    }

    @Nullable
    public static IFilter<?> readFromNBT(CompoundTag nbt) {
        if (nbt.m_128425_("type", 3)) {
            IFilter<?> filter = BaseFilter.fromType(FilterType.byIndexStatic(nbt.m_128451_("type")));
            if (filter != null) {
                filter.read(nbt);
            }
            return filter;
        }
        return null;
    }

    @Nullable
    public static IFilter<?> readFromPacket(FriendlyByteBuf dataStream) {
        IFilter<?> filter = BaseFilter.fromType((FilterType)dataStream.m_130066_(FilterType.class));
        if (filter != null) {
            filter.read(dataStream);
        }
        return filter;
    }

    public static IFilter<?> fromType(FilterType filterType) {
        return switch (filterType) {
            default -> throw new IncompatibleClassChangeError();
            case FilterType.MINER_ITEMSTACK_FILTER -> new MinerItemStackFilter();
            case FilterType.MINER_MATERIAL_FILTER -> new MinerMaterialFilter();
            case FilterType.MINER_MODID_FILTER -> new MinerModIDFilter();
            case FilterType.MINER_TAG_FILTER -> new MinerTagFilter();
            case FilterType.SORTER_ITEMSTACK_FILTER -> new SorterItemStackFilter();
            case FilterType.SORTER_MATERIAL_FILTER -> new SorterMaterialFilter();
            case FilterType.SORTER_MODID_FILTER -> new SorterModIDFilter();
            case FilterType.SORTER_TAG_FILTER -> new SorterTagFilter();
            case FilterType.OREDICTIONIFICATOR_ITEM_FILTER -> new OredictionificatorItemFilter();
            case FilterType.QIO_ITEMSTACK_FILTER -> new QIOItemStackFilter();
            case FilterType.QIO_MODID_FILTER -> new QIOModIDFilter();
            case FilterType.QIO_TAG_FILTER -> new QIOTagFilter();
        };
    }
}

