/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.boiler;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collections;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.heat.HeatAPI;
import mekanism.api.math.MathUtils;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.fluids.FluidStack;

public class BoilerMultiblockData
extends MultiblockData
implements IValveHandler {
    public static final Object2BooleanMap<UUID> hotMap = new Object2BooleanOpenHashMap();
    public static final double CASING_HEAT_CAPACITY = 50.0;
    private static final double CASING_INVERSE_INSULATION_COEFFICIENT = 100000.0;
    private static final double CASING_INVERSE_CONDUCTION_COEFFICIENT = 1.0;
    private static final int WATER_PER_VOLUME = 16000;
    private static final long STEAM_PER_VOLUME = 160000L;
    private static final int SUPERHEATED_COOLANT_PER_VOLUME = 256000;
    private static final int COOLED_COOLANT_PER_VOLUME = 256000;
    private static final double COOLANT_COOLING_EFFICIENCY = 0.4;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getHeatedCoolant", "getHeatedCoolantCapacity", "getHeatedCoolantNeeded", "getHeatedCoolantFilledPercentage"})
    public IGasTank superheatedCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getCooledCoolant", "getCooledCoolantCapacity", "getCooledCoolantNeeded", "getCooledCoolantFilledPercentage"})
    public IGasTank cooledCoolantTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getWater", "getWaterCapacity", "getWaterNeeded", "getWaterFilledPercentage"})
    public VariableCapacityFluidTank waterTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getSteam", "getSteamCapacity", "getSteamNeeded", "getSteamFilledPercentage"})
    public IGasTank steamTank;
    @ContainerSync
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"})
    public VariableHeatCapacitor heatCapacitor;
    private double biomeAmbientTemp;
    @ContainerSync
    @SyntheticComputerMethod(getter="getEnvironmentalLoss")
    public double lastEnvironmentLoss;
    @ContainerSync
    @SyntheticComputerMethod(getter="getBoilRate")
    public int lastBoilRate;
    @ContainerSync
    @SyntheticComputerMethod(getter="getMaxBoilRate")
    public int lastMaxBoil;
    @ContainerSync
    @SyntheticComputerMethod(getter="getSuperheaters")
    public int superheatingElements;
    @ContainerSync(setter="setWaterVolume")
    private int waterVolume;
    @ContainerSync(setter="setSteamVolume")
    private int steamVolume;
    private int waterTankCapacity;
    private long superheatedCoolantCapacity;
    private long steamTankCapacity;
    private long cooledCoolantCapacity;
    public BlockPos upperRenderLocation;
    public float prevWaterScale;
    public float prevSteamScale;

    public BoilerMultiblockData(TileEntityBoilerCasing tile) {
        super(tile);
        this.biomeAmbientTemp = HeatAPI.getAmbientTemp((LevelReader)tile.m_58904_(), tile.getTilePos());
        this.superheatedCoolantTank = MultiblockChemicalTankBuilder.GAS.input(this, () -> this.superheatedCoolantCapacity, gas -> gas.has(GasAttributes.HeatedCoolant.class), this);
        this.waterTank = VariableCapacityFluidTank.input(this, () -> this.waterTankCapacity, fluid -> MekanismTags.Fluids.WATER_LOOKUP.contains(fluid.getFluid()), this.createSaveAndComparator());
        this.fluidTanks.add(this.waterTank);
        this.steamTank = MultiblockChemicalTankBuilder.GAS.output(this, () -> this.steamTankCapacity, gas -> gas == MekanismGases.STEAM.getChemical(), this);
        this.cooledCoolantTank = MultiblockChemicalTankBuilder.GAS.output(this, () -> this.cooledCoolantCapacity, gas -> gas.has(GasAttributes.CooledCoolant.class), this);
        Collections.addAll(this.gasTanks, this.steamTank, this.superheatedCoolantTank, this.cooledCoolantTank);
        this.heatCapacitor = VariableHeatCapacitor.create(50.0, () -> 1.0, () -> 100000.0, () -> this.biomeAmbientTemp, (IContentsListener)this);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    @Override
    public void onCreated(Level world) {
        super.onCreated(world);
        this.biomeAmbientTemp = this.calculateAverageAmbientTemperature(world);
        this.heatCapacitor.setHeatCapacity(50.0 * (double)this.locations.size(), true);
    }

    @Override
    public void remove(Level world) {
        hotMap.removeBoolean((Object)this.inventoryID);
        super.remove(world);
    }

    @Override
    public boolean tick(Level world) {
        float steamScale;
        GasAttributes.HeatedCoolant coolantType;
        boolean needsPacket = super.tick(world);
        hotMap.put((Object)this.inventoryID, this.getTotalTemperature() >= HeatUtils.BASE_BOIL_TEMP - 0.01);
        this.lastEnvironmentLoss = this.simulateEnvironment();
        this.updateHeatCapacitors(null);
        if (!this.superheatedCoolantTank.isEmpty() && (coolantType = ((GasStack)this.superheatedCoolantTank.getStack()).get(GasAttributes.HeatedCoolant.class)) != null) {
            long toCool = Math.round(0.4 * (double)this.superheatedCoolantTank.getStored());
            toCool = MathUtils.clampToLong((double)toCool * (1.0 - this.heatCapacitor.getTemperature() / 100000.0));
            GasStack cooledCoolant = coolantType.getCooledGas().getStack(toCool);
            if ((toCool = Math.min(toCool, toCool - this.cooledCoolantTank.insert(cooledCoolant, Action.EXECUTE, AutomationType.INTERNAL).getAmount())) > 0L) {
                double heatEnergy = (double)toCool * coolantType.getThermalEnthalpy();
                this.heatCapacitor.handleHeat(heatEnergy);
                this.superheatedCoolantTank.shrinkStack(toCool, Action.EXECUTE);
            }
        }
        if (this.getTotalTemperature() >= HeatUtils.BASE_BOIL_TEMP && !this.waterTank.isEmpty()) {
            double heatAvailable = this.getHeatAvailable();
            this.lastMaxBoil = (int)Math.floor(HeatUtils.getSteamEnergyEfficiency() * heatAvailable / HeatUtils.getWaterThermalEnthalpy());
            int amountToBoil = Math.min(this.lastMaxBoil, this.waterTank.getFluidAmount());
            amountToBoil = Math.min(amountToBoil, MathUtils.clampToInt(this.steamTank.getNeeded()));
            if (!this.waterTank.isEmpty()) {
                this.waterTank.shrinkStack(amountToBoil, Action.EXECUTE);
            }
            if (this.steamTank.isEmpty()) {
                this.steamTank.setStack(MekanismGases.STEAM.getStack(amountToBoil));
            } else {
                this.steamTank.growStack(amountToBoil, Action.EXECUTE);
            }
            this.heatCapacitor.handleHeat((double)(-amountToBoil) * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency());
            this.lastBoilRate = amountToBoil;
        } else {
            this.lastBoilRate = 0;
            this.lastMaxBoil = 0;
        }
        float waterScale = MekanismUtils.getScale(this.prevWaterScale, this.waterTank);
        if (waterScale != this.prevWaterScale) {
            needsPacket = true;
            this.prevWaterScale = waterScale;
        }
        if ((steamScale = MekanismUtils.getScale(this.prevSteamScale, this.steamTank)) != this.prevSteamScale) {
            needsPacket = true;
            this.prevSteamScale = steamScale;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundTag tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevWaterScale = scale;
        });
        NBTUtils.setFloatIfPresent(tag, "scaleAlt", scale -> {
            this.prevSteamScale = scale;
        });
        NBTUtils.setIntIfPresent(tag, "volume", this::setWaterVolume);
        NBTUtils.setIntIfPresent(tag, "lowerVolume", this::setSteamVolume);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", value -> this.waterTank.setStack((FluidStack)value));
        NBTUtils.setGasStackIfPresent(tag, "gas", value -> this.steamTank.setStack(value));
        NBTUtils.setBlockPosIfPresent(tag, "renderY", value -> {
            this.upperRenderLocation = value;
        });
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundTag tag) {
        super.writeUpdateTag(tag);
        tag.m_128350_("scale", this.prevWaterScale);
        tag.m_128350_("scaleAlt", this.prevSteamScale);
        tag.m_128405_("volume", this.getWaterVolume());
        tag.m_128405_("lowerVolume", this.getSteamVolume());
        tag.m_128365_("fluid", (Tag)this.waterTank.getFluid().writeToNBT(new CompoundTag()));
        tag.m_128365_("gas", (Tag)((GasStack)this.steamTank.getStack()).write(new CompoundTag()));
        tag.m_128365_("renderY", (Tag)NbtUtils.m_129224_((BlockPos)this.upperRenderLocation));
        this.writeValves(tag);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.waterTank.getFluidAmount(), this.waterTank.getCapacity());
    }

    private double getHeatAvailable() {
        double heatAvailable = (this.heatCapacitor.getTemperature() - HeatUtils.BASE_BOIL_TEMP) * (this.heatCapacitor.getHeatCapacity() * MekanismConfig.general.boilerWaterConductivity.get());
        return Math.min(heatAvailable, MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superheatingElements);
    }

    @Override
    public double simulateEnvironment() {
        double invConduction = 110001.0;
        double tempToTransfer = (this.heatCapacitor.getTemperature() - this.biomeAmbientTemp) / invConduction;
        this.heatCapacitor.handleHeat(-tempToTransfer * this.heatCapacitor.getHeatCapacity());
        return Math.max(tempToTransfer, 0.0);
    }

    public int getWaterVolume() {
        return this.waterVolume;
    }

    public void setWaterVolume(int volume) {
        this.waterVolume = volume;
        this.waterTankCapacity = this.getWaterVolume() * 16000;
        this.superheatedCoolantCapacity = (long)this.getWaterVolume() * 256000L;
    }

    public int getSteamVolume() {
        return this.steamVolume;
    }

    public void setSteamVolume(int volume) {
        this.steamVolume = volume;
        this.steamTankCapacity = (long)this.getSteamVolume() * 160000L;
        this.cooledCoolantCapacity = (long)this.getSteamVolume() * 256000L;
    }

    @ComputerMethod
    public long getBoilCapacity() {
        double boilCapacity = MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superheatingElements / HeatUtils.getWaterThermalEnthalpy();
        return MathUtils.clampToLong(boilCapacity * HeatUtils.getSteamEnergyEfficiency());
    }
}

