/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Predicate;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RadiationCommand {
    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"radiation").requires((Predicate)MekanismPermissions.COMMAND_RADIATION)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_ADD)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"magnitude", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10000.0)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.addRadiation(source, source.m_81371_(), (Level)source.m_81372_(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.addRadiation(source, Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), (Level)source.m_81372_(), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.addRadiation(source, Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), (Level)DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"magnitude"));
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"get").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_GET)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.getRadiationLevel(source, source.m_81371_(), (Level)source.m_81372_());
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            return RadiationCommand.getRadiationLevel(source, Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), (Level)source.m_81372_());
        })).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> RadiationCommand.getRadiationLevel((CommandSourceStack)ctx.getSource(), Vec3Argument.m_120849_((CommandContext)ctx, (String)"location"), (Level)DimensionArgument.m_88808_((CommandContext)ctx, (String)"dimension"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"heal").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_HEAL)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            source.m_81375_().getCapability(Capabilities.RADIATION_ENTITY).ifPresent(c -> {
                c.set(1.0E-7);
                source.m_81354_((Component)MekanismLang.COMMAND_RADIATION_CLEAR.translateColored(EnumColor.GRAY, new Object[0]), true);
            });
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).requires((Predicate)MekanismPermissions.COMMAND_RADIATION_HEAL_OTHERS)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            for (Entity entity : EntityArgument.m_91461_((CommandContext)ctx, (String)"targets")) {
                if (!(entity instanceof LivingEntity)) continue;
                entity.getCapability(Capabilities.RADIATION_ENTITY).ifPresent(c -> {
                    c.set(1.0E-7);
                    source.m_81354_((Component)MekanismLang.COMMAND_RADIATION_CLEAR_ENTITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, entity.m_5446_()), true);
                });
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"removeAll").requires((Predicate)MekanismPermissions.COMMAND_RADIATION_REMOVE_ALL)).executes(ctx -> {
            RadiationManager.INSTANCE.clearSources();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)MekanismLang.COMMAND_RADIATION_REMOVE_ALL.translateColored(EnumColor.GRAY, new Object[0]), true);
            return 0;
        }));
    }

    private static int addRadiation(CommandSourceStack source, Coordinates location, Level world, double magnitude) {
        return RadiationCommand.addRadiation(source, location.m_6955_(source), world, magnitude);
    }

    private static int addRadiation(CommandSourceStack source, Vec3 pos, Level world, double magnitude) {
        Coord4D location = new Coord4D(pos.f_82479_, pos.f_82480_, pos.f_82481_, (ResourceKey<Level>)world.m_46472_());
        MekanismAPI.getRadiationManager().radiate(location, magnitude);
        source.m_81354_((Component)MekanismLang.COMMAND_RADIATION_ADD.translateColored(EnumColor.GRAY, RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3), EnumColor.INDIGO, RadiationCommand.getPosition(location.getPos()), EnumColor.INDIGO, location.dimension.m_135782_()), true);
        return 0;
    }

    private static int getRadiationLevel(CommandSourceStack source, Coordinates location, Level world) {
        return RadiationCommand.getRadiationLevel(source, location.m_6955_(source), world);
    }

    private static int getRadiationLevel(CommandSourceStack source, Vec3 pos, Level world) {
        Coord4D location = new Coord4D(pos.f_82479_, pos.f_82480_, pos.f_82481_, (ResourceKey<Level>)world.m_46472_());
        double magnitude = MekanismAPI.getRadiationManager().getRadiationLevel(location);
        source.m_81354_((Component)MekanismLang.COMMAND_RADIATION_GET.translateColored(EnumColor.GRAY, EnumColor.INDIGO, RadiationCommand.getPosition(location.getPos()), EnumColor.INDIGO, location.dimension.m_135782_(), RadiationManager.RadiationScale.getSeverityColor(magnitude), UnitDisplayUtils.getDisplayShort(magnitude, UnitDisplayUtils.RadiationUnit.SVH, 3)), true);
        return 0;
    }

    private static Component getPosition(BlockPos pos) {
        return MekanismLang.GENERIC_BLOCK_POS.translate(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }
}

