/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Optional;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.VoxelShapeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEnergyCube
extends BlockTile.BlockTileModel<TileEntityEnergyCube, Machine<TileEntityEnergyCube>> {
    private static final VoxelShape[] bounds = new VoxelShape[256];

    private static int getIndex(int top, int bottom, int front, int back, int left, int right, boolean rotateVertical, boolean rotateHorizontal) {
        return top | bottom << 1 | front << 2 | back << 3 | left << 4 | right << 5 | (rotateVertical ? 1 : 0) << 6 | (rotateHorizontal ? 1 : 0) << 7;
    }

    public BlockEnergyCube(Machine<TileEntityEnergyCube> type) {
        super(type, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.0f, 2.4f).m_60999_().m_60988_());
    }

    @Override
    public void setTileData(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, @NotNull TileEntityMekanism tile) {
        if (tile instanceof TileEntityEnergyCube) {
            IStrictEnergyHandler energyHandlerItem;
            Optional capability;
            ConfigInfo energyConfig;
            TileEntityEnergyCube energyCube = (TileEntityEnergyCube)tile;
            if (Attribute.getTier(this, EnergyCubeTier.class) == EnergyCubeTier.CREATIVE && (energyConfig = energyCube.configComponent.getConfig(TransmissionType.ENERGY)) != null && (capability = stack.getCapability(Capabilities.STRICT_ENERGY).resolve()).isPresent() && (energyHandlerItem = (IStrictEnergyHandler)capability.get()).getEnergyContainerCount() > 0) {
                energyConfig.fill(energyHandlerItem.getEnergy(0).isZero() ? DataType.INPUT : DataType.OUTPUT);
            }
        }
    }

    @Override
    @Deprecated
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index;
        TileEntityEnergyCube energyCube = WorldUtils.getTileEntity(TileEntityEnergyCube.class, world, pos, true);
        if (energyCube == null) {
            index = BlockEnergyCube.getIndex(1, 1, 1, 1, 1, 1, false, false);
        } else {
            ConfigInfo energyConfig = energyCube.configComponent.getConfig(TransmissionType.ENERGY);
            if (energyConfig == null) {
                index = BlockEnergyCube.getIndex(1, 1, 1, 1, 1, 1, false, false);
            } else {
                Direction facing = Attribute.get(this, AttributeStateFacing.class).getDirection(state);
                index = BlockEnergyCube.getIndex(BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.UP), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.DOWN), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.SOUTH), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.NORTH), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.EAST), BlockEnergyCube.isSideEnabled(energyConfig, facing, Direction.WEST), facing == Direction.EAST || facing == Direction.WEST, facing == Direction.DOWN || facing == Direction.UP);
            }
        }
        return bounds[index];
    }

    private static int isSideEnabled(ConfigInfo energyConfig, Direction facing, Direction side) {
        ISlotInfo slotInfo = energyConfig.getSlotInfo(RelativeSide.fromDirections(facing, side));
        return slotInfo != null && slotInfo.isEnabled() ? 1 : 0;
    }

    static {
        VoxelShape frame = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0), BlockEnergyCube.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0), BlockEnergyCube.m_49796_((double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), BlockEnergyCube.m_49796_((double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0), BlockEnergyCube.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), BlockEnergyCube.m_49796_((double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), BlockEnergyCube.m_49796_((double)3.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), BlockEnergyCube.m_49796_((double)3.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), BlockEnergyCube.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0, (double)13.0), BlockEnergyCube.m_49796_((double)13.0, (double)3.0, (double)0.0, (double)16.0, (double)13.0, (double)3.0), BlockEnergyCube.m_49796_((double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0, (double)16.0), BlockEnergyCube.m_49796_((double)13.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), BlockEnergyCube.m_49796_((double)12.5, (double)15.0, (double)7.5, (double)13.5, (double)15.9, (double)8.5), BlockEnergyCube.m_49796_((double)2.5, (double)15.0, (double)7.5, (double)3.5, (double)15.9, (double)8.5), BlockEnergyCube.m_49796_((double)12.5, (double)7.5, (double)0.1, (double)13.5, (double)8.5, (double)1.0), BlockEnergyCube.m_49796_((double)2.5, (double)7.5, (double)0.1, (double)3.5, (double)8.5, (double)1.0), BlockEnergyCube.m_49796_((double)2.5, (double)0.1, (double)7.5, (double)3.5, (double)1.0, (double)8.5), BlockEnergyCube.m_49796_((double)12.5, (double)0.1, (double)7.5, (double)13.5, (double)1.0, (double)8.5), BlockEnergyCube.m_49796_((double)12.5, (double)7.5, (double)15.0, (double)13.5, (double)8.5, (double)15.9), BlockEnergyCube.m_49796_((double)2.5, (double)7.5, (double)15.0, (double)3.5, (double)8.5, (double)15.9), BlockEnergyCube.m_49796_((double)0.1, (double)7.5, (double)2.5, (double)1.0, (double)8.5, (double)3.5), BlockEnergyCube.m_49796_((double)0.1, (double)7.5, (double)12.5, (double)1.0, (double)8.5, (double)13.5), BlockEnergyCube.m_49796_((double)15.0, (double)7.5, (double)2.5, (double)15.9, (double)8.5, (double)3.5), BlockEnergyCube.m_49796_((double)15.0, (double)7.5, (double)12.5, (double)15.9, (double)8.5, (double)13.5));
        VoxelShape frontPanel = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)15.0), BlockEnergyCube.m_49796_((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0));
        VoxelShape rightPanel = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)1.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)13.0), BlockEnergyCube.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0));
        VoxelShape leftPanel = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)14.0, (double)5.0, (double)3.0, (double)15.0, (double)11.0, (double)13.0), BlockEnergyCube.m_49796_((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        VoxelShape backPanel = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)3.0, (double)5.0, (double)1.0, (double)13.0, (double)11.0, (double)2.0), BlockEnergyCube.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0));
        VoxelShape topPanel = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)15.0, (double)11.0), BlockEnergyCube.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        VoxelShape bottomPanel = VoxelShapeUtils.combine(BlockEnergyCube.m_49796_((double)3.0, (double)1.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0), BlockEnergyCube.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0));
        VoxelShape frameRotated = VoxelShapeUtils.rotate(frame, Rotation.CLOCKWISE_90);
        VoxelShape topRotated = VoxelShapeUtils.rotate(topPanel, Rotation.CLOCKWISE_90);
        VoxelShape bottomRotated = VoxelShapeUtils.rotate(bottomPanel, Rotation.CLOCKWISE_90);
        VoxelShape frameRotatedAlt = VoxelShapeUtils.rotate(frame, Direction.NORTH);
        VoxelShape rightRotated = VoxelShapeUtils.rotate(rightPanel, Direction.NORTH);
        VoxelShape leftRotated = VoxelShapeUtils.rotate(leftPanel, Direction.NORTH);
        for (int rotated = 0; rotated < 3; ++rotated) {
            boolean rotateHorizontal;
            boolean rotateVertical = rotated == 1;
            boolean bl = rotateHorizontal = rotated == 2;
            VoxelShape baseFrame = rotateVertical ? frameRotated : (rotateHorizontal ? frameRotatedAlt : frame);
            for (int top = 0; top < 2; ++top) {
                VoxelShape withTop = top == 0 ? baseFrame : Shapes.m_83110_((VoxelShape)baseFrame, (VoxelShape)(rotateVertical ? topRotated : topPanel));
                for (int bottom = 0; bottom < 2; ++bottom) {
                    VoxelShape withBottom = bottom == 0 ? withTop : Shapes.m_83110_((VoxelShape)withTop, (VoxelShape)(rotateVertical ? bottomRotated : bottomPanel));
                    for (int front = 0; front < 2; ++front) {
                        VoxelShape withFront = front == 0 ? withBottom : Shapes.m_83110_((VoxelShape)withBottom, (VoxelShape)frontPanel);
                        for (int back = 0; back < 2; ++back) {
                            VoxelShape withBack = back == 0 ? withFront : Shapes.m_83110_((VoxelShape)withFront, (VoxelShape)backPanel);
                            for (int left = 0; left < 2; ++left) {
                                VoxelShape withLeft = left == 0 ? withBack : Shapes.m_83110_((VoxelShape)withBack, (VoxelShape)(rotateHorizontal ? leftRotated : leftPanel));
                                for (int right = 0; right < 2; ++right) {
                                    VoxelShape withRight;
                                    BlockEnergyCube.bounds[BlockEnergyCube.getIndex((int)top, (int)bottom, (int)front, (int)back, (int)left, (int)right, (boolean)rotateVertical, (boolean)rotateHorizontal)] = withRight = right == 0 ? withLeft : Shapes.m_83110_((VoxelShape)withLeft, (VoxelShape)(rotateHorizontal ? rightRotated : rightPanel));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

