/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.FluidRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class RenderFluidTank
extends MekanismTileEntityRenderer<TileEntityFluidTank> {
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedCenterFluids = new FluidRenderMap();
    private static final FluidRenderMap<Int2ObjectMap<MekanismRenderer.Model3D>> cachedValveFluids = new FluidRenderMap();
    private static final int stages = 1400;

    public RenderFluidTank(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public static void resetCachedModels() {
        cachedCenterFluids.clear();
        cachedValveFluids.clear();
    }

    @Override
    protected void render(TileEntityFluidTank tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        FluidStack fluid = tile.fluidTank.getFluid();
        float fluidScale = tile.prevScale;
        Lazy buffer = Lazy.of(() -> renderer.m_6299_(Sheets.m_110792_()));
        if (!fluid.isEmpty() && fluidScale > 0.0f) {
            MekanismRenderer.renderObject(RenderFluidTank.getFluidModel(fluid, fluidScale), matrix, (VertexConsumer)buffer.get(), MekanismRenderer.getColorARGB(fluid, fluidScale), MekanismRenderer.calculateGlowLight(light, fluid), overlayLight, RenderResizableCuboid.FaceDisplay.FRONT, this.getCamera(), tile.m_58899_());
        }
        if (!tile.valveFluid.isEmpty() && !MekanismUtils.lighterThanAirGas(tile.valveFluid)) {
            MekanismRenderer.renderObject(this.getValveModel(tile.valveFluid, fluidScale), matrix, (VertexConsumer)buffer.get(), MekanismRenderer.getColorARGB(tile.valveFluid), MekanismRenderer.calculateGlowLight(light, tile.valveFluid), overlayLight, RenderResizableCuboid.FaceDisplay.FRONT, this.getCamera(), tile.m_58899_());
        }
    }

    @Override
    protected String getProfilerSection() {
        return "fluidTank";
    }

    private MekanismRenderer.Model3D getValveModel(@NotNull FluidStack fluid, float fluidScale) {
        return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedValveFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).computeIfAbsent(Math.min(1399, (int)(fluidScale * 1399.0f)), stage -> new MekanismRenderer.Model3D().setSideRender(side -> side.m_122434_().m_122479_()).prepFlowing(fluid).xBounds(0.3225f, 0.6775f).yBounds(0.0625f + 0.875f * ((float)stage / 1400.0f), 0.9375f).zBounds(0.3225f, 0.6775f));
    }

    public static MekanismRenderer.Model3D getFluidModel(@NotNull FluidStack fluid, float fluidScale) {
        return (MekanismRenderer.Model3D)((Int2ObjectMap)cachedCenterFluids.computeIfAbsent(fluid, f -> new Int2ObjectOpenHashMap())).computeIfAbsent(ModelRenderer.getStage(fluid, 1400, (double)fluidScale), stage -> new MekanismRenderer.Model3D().setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidTextureType.STILL)).setSideRender(Direction.DOWN, false).setSideRender(Direction.UP, stage < 1400).xBounds(0.135f, 0.865f).yBounds(0.0625f, 0.0625f + 0.875f * ((float)stage / 1400.0f)).zBounds(0.135f, 0.865f));
    }
}

