/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.client.MekanismClient;
import mekanism.client.render.HUDRenderer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.items.IItemHandler;

public class MekaSuitHUD
implements IGuiOverlay {
    private static final EquipmentSlot[] EQUIPMENT_ORDER = new EquipmentSlot[]{EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final HUDRenderer hudRenderer = new HUDRenderer();

    public void render(ForgeGui gui, PoseStack poseStack, float partialTicks, int width, int height) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92062_ && !minecraft.f_91074_.m_5833_() && MekanismConfig.client.enableHUD.get() && MekanismClient.renderHUD) {
            Optional<? extends IItemHandler> invOptional;
            Object object;
            ItemStack stack;
            int count = 0;
            ArrayList<List<Component>> renderStrings = new ArrayList<List<Component>>();
            for (EquipmentSlot slotType : EQUIPMENT_ORDER) {
                stack = minecraft.f_91074_.m_6844_(slotType);
                object = stack.m_41720_();
                if (!(object instanceof IItemHUDProvider)) continue;
                IItemHUDProvider iItemHUDProvider = (IItemHUDProvider)object;
                count += this.makeComponent(list -> hudProvider.addHUDStrings((List<Component>)list, (Player)minecraft.f_91074_, stack, slotType), renderStrings);
            }
            if (Mekanism.hooks.CuriosLoaded && (invOptional = CuriosIntegration.getCuriosInventory((LivingEntity)minecraft.f_91074_)).isPresent()) {
                IItemHandler inv = invOptional.get();
                int slots = inv.getSlots();
                for (int i = 0; i < slots; ++i) {
                    stack = inv.getStackInSlot(i);
                    object = stack.m_41720_();
                    if (!(object instanceof IItemHUDProvider)) continue;
                    IItemHUDProvider iItemHUDProvider = (IItemHUDProvider)object;
                    count += this.makeComponent(list -> hudProvider.addCurioHUDStrings((List<Component>)list, (Player)minecraft.f_91074_, stack), renderStrings);
                }
            }
            if (count > 0) {
                int start = renderStrings.size() * 2 + count * 9;
                boolean alignLeft = MekanismConfig.client.alignHUDLeft.get();
                float hudScale = MekanismConfig.client.hudScale.get();
                int yScale = (int)(1.0f / hudScale * (float)height);
                poseStack.m_85836_();
                poseStack.m_85841_(hudScale, hudScale, hudScale);
                for (List list2 : renderStrings) {
                    for (Component text : list2) {
                        this.drawString(minecraft.f_91062_, width, poseStack, text, alignLeft, yScale - start, 0xC8C8C8);
                        start -= 9;
                    }
                    start -= 2;
                }
                poseStack.m_85849_();
            }
            if (minecraft.f_91074_.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ItemMekaSuitArmor) {
                hudRenderer.renderHUD(poseStack, partialTicks);
            }
        }
    }

    private int makeComponent(Consumer<List<Component>> adder, List<List<Component>> initial) {
        ArrayList list = new ArrayList();
        adder.accept(list);
        int size = list.size();
        if (size > 0) {
            initial.add(list);
        }
        return size;
    }

    private void drawString(Font font, int windowWidth, PoseStack matrix, Component text, boolean leftSide, int y, int color) {
        if (leftSide) {
            font.m_92763_(matrix, text, 2.0f, (float)y, color);
        } else {
            int width = font.m_92852_((FormattedText)text) + 2;
            font.m_92763_(matrix, text, (float)(windowWidth - width), (float)y, color);
        }
    }
}

