/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.BaseTier;
import mekanism.client.SpecialColors;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.model.baked.DigitalMinerBakedModel;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.data.ValveRenderData;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.client.render.tileentity.RenderDigitalMiner;
import mekanism.client.render.tileentity.RenderDimensionalStabilizer;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderNutritionalLiquifier;
import mekanism.client.render.tileentity.RenderPigmentMixer;
import mekanism.client.render.tileentity.RenderSeismicVibrator;
import mekanism.client.render.tileentity.RenderTeleporter;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="mekanism", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MekanismRenderer {
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite whiteIcon;
    public static TextureAtlasSprite teleporterPortal;
    public static TextureAtlasSprite redstoneTorch;
    public static TextureAtlasSprite redstonePulse;
    public static final Map<TransmissionType, TextureAtlasSprite> overlays;

    public static TextureAtlasSprite getBaseFluidTexture(@NotNull Fluid fluid, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation spriteLocation = type == FluidTextureType.STILL ? properties.getStillTexture() : properties.getFlowingTexture();
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getFluidTexture(@NotNull FluidStack fluidStack, @NotNull FluidTextureType type) {
        IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation spriteLocation = type == FluidTextureType.STILL ? properties.getStillTexture(fluidStack) : properties.getFlowingTexture(fluidStack);
        return MekanismRenderer.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getChemicalTexture(@NotNull Chemical<?> chemical) {
        return MekanismRenderer.getSprite(chemical.getIcon());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(spriteLocation);
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera, BlockPos renderPos) {
        if (object != null) {
            MekanismRenderer.renderObject(object, matrix, buffer, argb, light, overlay, faceDisplay, camera, Vec3.m_82528_((Vec3i)renderPos));
        }
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera) {
        MekanismRenderer.renderObject(object, matrix, buffer, argb, light, overlay, faceDisplay, camera, (Vec3)null);
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int argb, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, argb, light, overlay, faceDisplay, camera, renderPos);
        }
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera) {
        MekanismRenderer.renderObject(object, matrix, buffer, colors, light, overlay, faceDisplay, camera, null);
    }

    public static void renderObject(@Nullable Model3D object, @NotNull PoseStack matrix, VertexConsumer buffer, int[] colors, int light, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera, @Nullable Vec3 renderPos) {
        if (object != null) {
            RenderResizableCuboid.renderCube(object, matrix, buffer, colors, light, overlay, faceDisplay, camera, renderPos);
        }
    }

    public static void renderValves(PoseStack matrix, VertexConsumer buffer, Set<IValveHandler.ValveData> valves, FluidRenderData data, float fluidHeight, BlockPos pos, int glow, int overlay, RenderResizableCuboid.FaceDisplay faceDisplay, Camera camera) {
        for (IValveHandler.ValveData valveData : valves) {
            ValveRenderData valveRenderData = ValveRenderData.get(data, valveData);
            Model3D valveModel = ModelRenderer.getValveModel(valveRenderData, fluidHeight);
            if (valveModel == null) continue;
            matrix.m_85836_();
            matrix.m_85837_((double)(valveData.location.m_123341_() - pos.m_123341_()), (double)(valveData.location.m_123342_() - pos.m_123342_()), (double)(valveData.location.m_123343_() - pos.m_123343_()));
            MekanismRenderer.renderObject(valveModel, matrix, buffer, valveRenderData.getColorARGB(), glow, overlay, faceDisplay, camera, valveData.location);
            matrix.m_85849_();
        }
    }

    public static void resetColor() {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static float getRed(int color) {
        return (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
    }

    public static void color(int color) {
        RenderSystem.m_157429_((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)MekanismRenderer.getAlpha(color));
    }

    public static void color(ColorAtlas.ColorRegistryObject colorRO) {
        MekanismRenderer.color(colorRO.get());
    }

    public static void color(Color color) {
        RenderSystem.m_157429_((float)color.rf(), (float)color.gf(), (float)color.bf(), (float)color.af());
    }

    public static void color(@NotNull FluidStack fluid) {
        if (!fluid.isEmpty()) {
            MekanismRenderer.color(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid));
        }
    }

    public static void color(@NotNull ChemicalStack<?> chemicalStack) {
        if (!chemicalStack.isEmpty()) {
            MekanismRenderer.color(chemicalStack.getType());
        }
    }

    public static void color(@NotNull Chemical<?> chemical) {
        if (!chemical.isEmptyType()) {
            int color = chemical.getTint();
            RenderSystem.m_157429_((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)1.0f);
        }
    }

    public static void color(@NotNull BaseTier tier) {
        MekanismRenderer.color(tier.getColor());
    }

    public static void color(@Nullable EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha) {
        if (color != null) {
            RenderSystem.m_157429_((float)color.getColor(0), (float)color.getColor(1), (float)color.getColor(2), (float)alpha);
        }
    }

    public static int getColorARGB(EnumColor color, float alpha) {
        return MekanismRenderer.getColorARGB(color.getRgbCode()[0], color.getRgbCode()[1], color.getRgbCode()[2], alpha);
    }

    public static int getColorARGB(@NotNull FluidStack fluidStack) {
        return IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
    }

    public static int getColorARGB(@NotNull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        int color = MekanismRenderer.getColorARGB(fluidStack);
        if (MekanismUtils.lighterThanAirGas(fluidStack)) {
            return MekanismRenderer.getColorARGB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), Math.min(1.0f, fluidScale + 0.2f));
        }
        return color;
    }

    public static int getColorARGB(@NotNull ChemicalStack<?> stack, float scale, boolean gaseous) {
        return MekanismRenderer.getColorARGB(stack.getType(), scale, gaseous);
    }

    public static int getColorARGB(@NotNull Chemical<?> chemical, float scale, boolean gaseous) {
        if (chemical.isEmptyType()) {
            return -1;
        }
        int color = chemical.getTint();
        return MekanismRenderer.getColorARGB(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), gaseous ? Math.min(1.0f, scale + 0.2f) : 1.0f);
    }

    public static int getColorARGB(float red, float green, float blue, float alpha) {
        return MekanismRenderer.getColorARGB((int)(255.0f * red), (int)(255.0f * green), (int)(255.0f * blue), alpha);
    }

    public static int getColorARGB(int red, int green, int blue, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        return FastColor.ARGB32.m_13660_((int)((int)(255.0f * alpha)), (int)red, (int)green, (int)blue);
    }

    public static int calculateGlowLight(int combinedLight, @NotNull FluidStack fluid) {
        return fluid.isEmpty() ? combinedLight : MekanismRenderer.calculateGlowLight(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
    }

    public static int calculateGlowLight(int combinedLight, int glow) {
        return combinedLight & 0xFFFF0000 | Math.max(Math.min(glow, 15) << 4, combinedLight & 0xFFFF);
    }

    public static void renderColorOverlay(PoseStack matrix, int x, int y, int width, int height, int color) {
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = FastColor.ARGB32.m_13655_((int)color);
        RenderSystem.m_69465_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        bufferbuilder.m_85982_(matrix4f, (float)width, (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)x, (float)height, 0.0f).m_6122_(r, g, b, a).m_5752_();
        bufferbuilder.m_85982_(matrix4f, (float)width, (float)height, 0.0f).m_6122_(r, g, b, a).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        RenderSystem.m_69482_();
    }

    public static float getPartialTick() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static void rotate(PoseStack matrix, Direction facing, float north, float south, float west, float east) {
        switch (facing) {
            case NORTH: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(north));
                break;
            }
            case SOUTH: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(south));
                break;
            }
            case WEST: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(west));
                break;
            }
            case EAST: {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(east));
            }
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (!event.getAtlas().m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            event.addSprite(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay"));
        }
        event.addSprite(Mekanism.rl("block/overlay/overlay_white"));
        event.addSprite(Mekanism.rl("liquid/energy"));
        event.addSprite(Mekanism.rl("liquid/heat"));
        event.addSprite(Mekanism.rl("icon/redstone_control_pulse"));
        event.addSprite(Mekanism.rl("block/teleporter_portal"));
        event.addSprite(Mekanism.rl("entity/armor/blank"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_player"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_body"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_helmet"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_exoskeleton"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_gravitational_modulator"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_elytra"));
        event.addSprite(Mekanism.rl("entity/armor/mekasuit_armor_modules"));
        event.addSprite(Mekanism.rl("entity/armor/mekatool"));
        DigitalMinerBakedModel.preStitch(event);
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.gasRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.infuseTypeRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.pigmentRegistry());
        MekanismRenderer.addChemicalSprites(event, MekanismAPI.slurryRegistry());
        ModelRenderer.resetCachedModels();
        RenderDigitalMiner.resetCachedVisuals();
        RenderDimensionalStabilizer.resetCachedVisuals();
        RenderFluidTank.resetCachedModels();
        RenderNutritionalLiquifier.resetCachedModels();
        RenderPigmentMixer.resetCached();
        RenderMechanicalPipe.onStitch();
        RenderSeismicVibrator.resetCached();
        RenderTickHandler.resetCached();
        RenderTeleporter.resetCachedModels();
        MekanismRenderer.parseColorAtlas(Mekanism.rl("textures/colormap/primary.png"));
        SpecialColors.GUI_OBJECTS.parse(Mekanism.rl("textures/colormap/gui_objects.png"));
        SpecialColors.GUI_TEXT.parse(Mekanism.rl("textures/colormap/gui_text.png"));
        GuiElementHolder.updateBackgroundColor();
    }

    private static void parseColorAtlas(ResourceLocation rl) {
        List<Color> parsed = ColorAtlas.load(rl, EnumUtils.COLORS.length);
        if (parsed.size() < EnumUtils.COLORS.length) {
            Mekanism.logger.error("Failed to parse primary color atlas.");
            return;
        }
        for (int i = 0; i < EnumUtils.COLORS.length; ++i) {
            EnumUtils.COLORS[i].setColorFromAtlas(parsed.get(i).rgbArray());
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>> void addChemicalSprites(TextureStitchEvent.Pre event, IForgeRegistry<CHEMICAL> chemicalRegistry) {
        for (Chemical chemical : chemicalRegistry.getValues()) {
            event.addSprite(chemical.getIcon());
        }
    }

    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Post event) {
        TextureAtlas map = event.getAtlas();
        if (!map.m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            overlays.put(type, map.m_118316_(Mekanism.rl("block/overlay/" + type.getTransmission() + "_overlay")));
        }
        whiteIcon = map.m_118316_(Mekanism.rl("block/overlay/overlay_white"));
        energyIcon = map.m_118316_(Mekanism.rl("liquid/energy"));
        heatIcon = map.m_118316_(Mekanism.rl("liquid/heat"));
        redstoneTorch = map.m_118316_(new ResourceLocation("minecraft:block/redstone_torch"));
        redstonePulse = map.m_118316_(Mekanism.rl("icon/redstone_control_pulse"));
        teleporterPortal = map.m_118316_(Mekanism.rl("block/teleporter_portal"));
        DigitalMinerBakedModel.onStitch(event);
        RenderLogisticalTransporter.onStitch(map);
        RenderTransmitterBase.onStitch();
    }

    static {
        overlays = new EnumMap<TransmissionType, TextureAtlasSprite>(TransmissionType.class);
    }

    public static enum FluidTextureType {
        STILL,
        FLOWING;

    }

    public static class Model3D {
        public float minX;
        public float minY;
        public float minZ;
        public float maxX;
        public float maxY;
        public float maxZ;
        private final SpriteInfo[] textures = new SpriteInfo[6];
        private final boolean[] renderSides = new boolean[]{true, true, true, true, true, true};

        public Model3D setSideRender(Predicate<Direction> shouldRender) {
            for (Direction direction : EnumUtils.DIRECTIONS) {
                this.setSideRender(direction, shouldRender.test(direction));
            }
            return this;
        }

        public Model3D setSideRender(Direction side, boolean value) {
            this.renderSides[side.ordinal()] = value;
            return this;
        }

        public Model3D copy() {
            Model3D copy = new Model3D();
            System.arraycopy(this.textures, 0, copy.textures, 0, this.textures.length);
            System.arraycopy(this.renderSides, 0, copy.renderSides, 0, this.renderSides.length);
            return copy.bounds(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }

        @Nullable
        public SpriteInfo getSpriteToRender(Direction side) {
            int ordinal = side.ordinal();
            return this.renderSides[ordinal] ? this.textures[ordinal] : null;
        }

        public Model3D shrink(float amount) {
            return this.grow(-amount);
        }

        public Model3D grow(float amount) {
            return this.bounds(this.minX - amount, this.minY - amount, this.minZ - amount, this.maxX + amount, this.maxY + amount, this.maxZ + amount);
        }

        public Model3D xBounds(float min, float max) {
            this.minX = min;
            this.maxX = max;
            return this;
        }

        public Model3D yBounds(float min, float max) {
            this.minY = min;
            this.maxY = max;
            return this;
        }

        public Model3D zBounds(float min, float max) {
            this.minZ = min;
            this.maxZ = max;
            return this;
        }

        public Model3D bounds(float min, float max) {
            return this.bounds(min, min, min, max, max, max);
        }

        public Model3D bounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            return this.xBounds(minX, maxX).yBounds(minY, maxY).zBounds(minZ, maxZ);
        }

        public Model3D prepSingleFaceModelSize(Direction face) {
            this.bounds(0.0f, 1.0f);
            return switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> this.yBounds(-0.01f, -0.001f);
                case Direction.UP -> this.yBounds(1.001f, 1.01f);
                case Direction.NORTH -> this.zBounds(-0.01f, -0.001f);
                case Direction.SOUTH -> this.zBounds(1.001f, 1.01f);
                case Direction.WEST -> this.xBounds(-0.01f, -0.001f);
                case Direction.EAST -> this.xBounds(1.001f, 1.01f);
            };
        }

        public Model3D prepFlowing(@NotNull FluidStack fluid) {
            SpriteInfo still = new SpriteInfo(MekanismRenderer.getFluidTexture(fluid, FluidTextureType.STILL), 16);
            SpriteInfo flowing = new SpriteInfo(MekanismRenderer.getFluidTexture(fluid, FluidTextureType.FLOWING), 8);
            return this.setTextures(still, still, flowing, flowing, flowing, flowing);
        }

        public Model3D setTexture(Direction side, @Nullable SpriteInfo spriteInfo) {
            this.textures[side.ordinal()] = spriteInfo;
            return this;
        }

        public Model3D setTexture(TextureAtlasSprite tex) {
            return this.setTexture(tex, 16);
        }

        public Model3D setTexture(TextureAtlasSprite tex, int size) {
            Arrays.fill(this.textures, new SpriteInfo(tex, size));
            return this;
        }

        public Model3D setTextures(SpriteInfo down, SpriteInfo up, SpriteInfo north, SpriteInfo south, SpriteInfo west, SpriteInfo east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
            return this;
        }

        public record SpriteInfo(TextureAtlasSprite sprite, int size) {
            public float getU(float u) {
                return this.sprite.m_118367_((double)(u * (float)this.size));
            }

            public float getV(float v) {
                return this.sprite.m_118393_((double)(v * (float)this.size));
            }
        }

        public static interface ModelBoundsSetter {
            public Model3D set(float var1, float var2);
        }
    }

    public static class LazyModel
    implements Supplier<Model3D> {
        private final Supplier<Model3D> supplier;
        @Nullable
        private Model3D model;

        public LazyModel(Supplier<Model3D> supplier) {
            this.supplier = supplier;
        }

        public void reset() {
            this.model = null;
        }

        @Override
        public Model3D get() {
            if (this.model == null) {
                this.model = this.supplier.get();
            }
            return this.model;
        }
    }
}

