/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.window.filter.GuiOredictionificatorFilter;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiOredictionificator
extends GuiConfigurableTile<TileEntityOredictionificator, MekanismTileContainer<TileEntityOredictionificator>> {
    private static final int FILTER_COUNT = 3;
    private GuiScrollBar scrollBar;

    public GuiOredictionificator(MekanismTileContainer<TileEntityOredictionificator> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97727_ += 64;
        this.f_97731_ = this.f_97727_ - 94;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiElementHolder(this, 9, 17, 144, 68));
        this.addRenderableWidget(new GuiElementHolder(this, 9, 85, 144, 22));
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 153, 17, 90, () -> ((TileEntityOredictionificator)this.tile).getFilters().size(), () -> 3));
        this.addRenderableWidget(new GuiProgress(() -> ((TileEntityOredictionificator)this.tile).didProcess, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 64, 119));
        this.addRenderableWidget(new TranslationButton(this, 10, 86, 142, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(GuiOredictionificatorFilter.create(this, (TileEntityOredictionificator)this.tile))));
        for (int i = 0; i < 3; ++i) {
            this.addRenderableWidget(new FilterButton(this, 10, 18 + i * 22, 142, 22, i, this.scrollBar::getCurrentSelection, ((TileEntityOredictionificator)this.tile)::getFilters, this::onClick, filter -> {
                if (filter instanceof OredictionificatorItemFilter) {
                    OredictionificatorItemFilter oredictionificatorFilter = (OredictionificatorItemFilter)filter;
                    return Collections.singletonList((ItemStack)oredictionificatorFilter.getResult());
                }
                return Collections.emptyList();
            })).warning(WarningTracker.WarningType.INVALID_OREDICTIONIFICATOR_FILTER, filter -> filter != null && !filter.hasFilter());
        }
        this.trackWarning(WarningTracker.WarningType.INVALID_OREDICTIONIFICATOR_FILTER, () -> ((TileEntityOredictionificator)this.tile).getFilters().stream().anyMatch(filter -> !filter.hasFilter()));
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof OredictionificatorItemFilter) {
            OredictionificatorItemFilter oredictionificatorFilter = (OredictionificatorItemFilter)filter;
            this.addWindow(GuiOredictionificatorFilter.edit(this, (TileEntityOredictionificator)this.tile, oredictionificatorFilter));
        }
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta) || this.scrollBar.adjustScroll(delta);
    }
}

