/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.item;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiArrowSelection;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.item.SeismicReaderContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.IFluidBlock;
import org.jetbrains.annotations.NotNull;

public class GuiSeismicReader
extends GuiMekanism<SeismicReaderContainer> {
    private final List<BlockState> blockList = new ArrayList<BlockState>();
    private final Object2IntMap<Block> frequencies = new Object2IntOpenHashMap();
    private final int minHeight;
    private MekanismButton upButton;
    private MekanismButton downButton;
    private GuiScrollBar scrollBar;

    public GuiSeismicReader(SeismicReaderContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97726_ = 147;
        this.f_97727_ = 182;
        this.minHeight = inv.f_35978_.f_19853_.m_141937_();
        BlockPos pos = inv.f_35978_.m_20183_();
        for (BlockPos p : BlockPos.m_121940_((BlockPos)new BlockPos(pos.m_123341_(), this.minHeight, pos.m_123343_()), (BlockPos)pos)) {
            this.blockList.add(inv.f_35978_.f_19853_.m_8055_(p));
        }
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen(this, 7, 11, 63, 49));
        this.addRenderableWidget(new GuiInnerScreen(this, 74, 11, 51, 159));
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 126, 25, 131, this.blockList::size, () -> 1));
        this.addRenderableWidget(new GuiArrowSelection(this, 76, 81, () -> {
            int currentLayer = this.scrollBar.getCurrentSelection();
            if (currentLayer >= 0) {
                return this.blockList.get(this.blockList.size() - 1 - currentLayer).m_60734_().m_49954_();
            }
            return null;
        }));
        this.upButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 126, 11, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "up.png"), () -> this.scrollBar.adjustScroll(1.0)));
        this.downButton = this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 126, 156, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "down.png"), () -> this.scrollBar.adjustScroll(-1.0)));
        this.updateEnabledButtons();
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        int currentLayer = this.scrollBar.getCurrentSelection();
        this.upButton.f_93623_ = currentLayer > 0;
        this.downButton.f_93623_ = currentLayer + 1 < this.blockList.size();
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        int currentLayer = this.blockList.size() - this.scrollBar.getCurrentSelection() - 1;
        this.drawTextScaledBound(matrix, (Component)TextComponentUtil.build(this.minHeight + currentLayer), 111.0f, 87.0f, this.screenTextColor(), 13.0f);
        for (int i = 0; i < 9; ++i) {
            RenderTarget renderTarget;
            int layer = currentLayer + (i - 4);
            if (0 > layer || layer >= this.blockList.size()) continue;
            BlockState state = this.blockList.get(layer);
            ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
            if (stack.m_41619_()) {
                Fluid fluid = Fluids.f_76191_;
                Block block = state.m_60734_();
                if (block instanceof LiquidBlock) {
                    LiquidBlock liquidBlock = (LiquidBlock)block;
                    fluid = liquidBlock.getFluid();
                } else {
                    block = state.m_60734_();
                    if (block instanceof IFluidBlock) {
                        IFluidBlock fluidBlock = (IFluidBlock)block;
                        fluid = fluidBlock.getFluid();
                    } else {
                        block = state.m_60734_();
                        if (block instanceof BubbleColumnBlock) {
                            BubbleColumnBlock bubbleColumn = (BubbleColumnBlock)block;
                            fluid = bubbleColumn.m_5888_(state).m_76152_();
                        }
                    }
                }
                if (fluid == Fluids.f_76191_) continue;
                IClientFluidTypeExtensions properties = IClientFluidTypeExtensions.of((Fluid)fluid);
                renderTarget = (poseStack, x, y) -> {
                    MekanismRenderer.color(properties.getTintColor());
                    TextureAtlasSprite texture = MekanismRenderer.getSprite(properties.getStillTexture());
                    GuiUtils.drawSprite(poseStack, x, y, 16, 16, this.m_93252_(), texture);
                    MekanismRenderer.resetColor();
                };
            } else {
                renderTarget = (poseStack, x, y) -> this.renderItem(poseStack, stack, x, y);
            }
            int renderX = 92;
            int renderY = 146 - 16 * i;
            if (i == 4) {
                renderTarget.render(matrix, renderX, renderY);
                continue;
            }
            matrix.m_85836_();
            matrix.m_85837_((double)renderX, (double)renderY, 0.0);
            if (i < 4) {
                matrix.m_85837_((double)1.7f, 2.5, 0.0);
            } else {
                matrix.m_85837_(1.5, 0.0, 0.0);
            }
            matrix.m_85841_(0.8f, 0.8f, 0.8f);
            renderTarget.render(matrix, 0, 0);
            matrix.m_85849_();
        }
        int frequency = 0;
        if (currentLayer >= 0) {
            Block block = this.blockList.get(currentLayer).m_60734_();
            MutableComponent displayName = block.m_49954_();
            this.drawTextScaledBound(matrix, (Component)displayName, 10.0f, 16.0f, this.screenTextColor(), 57.0f);
            frequency = this.frequencies.computeIfAbsent((Object)block, b -> (int)this.blockList.stream().filter(blockState -> b == blockState.m_60734_()).count());
        }
        this.drawTextScaledBound(matrix, (Component)MekanismLang.ABUNDANCY.translate(frequency), 10.0f, 26.0f, this.screenTextColor(), 57.0f);
        MekanismRenderer.resetColor();
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return super.m_6050_(mouseX, mouseY, delta) || this.scrollBar.adjustScroll(delta);
    }

    @FunctionalInterface
    private static interface RenderTarget {
        public void render(PoseStack var1, int var2, int var3);
    }
}

