/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.CharPredicate;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.window.filter.GuiTextFilter;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RegistryUtils;
import mekanism.common.util.text.InputValidator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiModIDFilter<FILTER extends IModIDFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiTextFilter<FILTER, TILE> {
    protected GuiModIDFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, (Component)MekanismLang.MODID_FILTER.translate(new Object[0]), tile, origFilter);
    }

    @Override
    protected CharPredicate getInputValidator() {
        return InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS);
    }

    @Override
    protected List<Component> getScreenText() {
        List<Component> list = super.getScreenText();
        list.add((Component)MekanismLang.MODID_FILTER_ID.translate(((IModIDFilter)this.filter).getModID()));
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.MODID_FILTER_NO_ID;
    }

    @Override
    protected boolean setText() {
        return this.setFilterName(this.text.getText(), false);
    }

    @Override
    @NotNull
    protected List<ItemStack> getRenderStacks() {
        if (((IModIDFilter)this.filter).hasFilter()) {
            return TagCache.getItemModIDStacks(((IModIDFilter)this.filter).getModID());
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected IJEIGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return new IJEIGhostTarget.IGhostIngredientConsumer(){

            @Override
            public boolean supportsIngredient(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    return !stack.m_41619_();
                }
                if (ingredient instanceof FluidStack) {
                    FluidStack stack = (FluidStack)ingredient;
                    return !stack.isEmpty();
                }
                if (ingredient instanceof ChemicalStack) {
                    ChemicalStack stack = (ChemicalStack)ingredient;
                    return !stack.isEmpty();
                }
                return RegistryUtils.getName(ingredient) != null;
            }

            @Override
            public void accept(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    GuiModIDFilter.this.setFilterName(stack);
                } else if (ingredient instanceof FluidStack) {
                    FluidStack stack = (FluidStack)ingredient;
                    GuiModIDFilter.this.setFilterName(RegistryUtils.getName(stack.getFluid()));
                } else if (ingredient instanceof ChemicalStack) {
                    ChemicalStack stack = (ChemicalStack)ingredient;
                    GuiModIDFilter.this.setFilterName(stack.getTypeRegistryName());
                } else {
                    ResourceLocation registryName = RegistryUtils.getName(ingredient);
                    if (registryName != null) {
                        GuiModIDFilter.this.setFilterName(registryName);
                    }
                }
            }
        };
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return GuiModIDFilter.mouseClickSlot(this.gui(), button, mouseX, mouseY, this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, NOT_EMPTY, this::setFilterName) || super.m_6375_(mouseX, mouseY, button);
    }

    private void setFilterName(ItemStack stack) {
        this.setFilterName(MekanismUtils.getModId(stack), true);
    }

    private void setFilterName(ResourceLocation registryName) {
        this.setFilterName(registryName.m_135827_(), true);
    }

    private boolean setFilterName(String name, boolean click) {
        boolean success = false;
        if (name.isEmpty()) {
            this.filterSaveFailed(this.getNoFilterSaveError(), new Object[0]);
        } else if (name.equals(((IModIDFilter)this.filter).getModID())) {
            this.filterSaveFailed(MekanismLang.MODID_FILTER_SAME_ID, new Object[0]);
        } else if (!this.hasMatchingTargets(name)) {
            this.filterSaveFailed(MekanismLang.TEXT_FILTER_NO_MATCHES, new Object[0]);
        } else {
            ((IModIDFilter)this.filter).setModID(name);
            this.slotDisplay.updateStackList();
            this.text.setText("");
            this.filterSaveSuccess();
            success = true;
        }
        if (click) {
            this.playClickSound();
        }
        return success;
    }

    protected boolean hasMatchingTargets(String name) {
        return !TagCache.getItemModIDStacks(name).isEmpty();
    }
}

