/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.IntSupplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollableElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiScrollBar
extends GuiScrollableElement {
    private static final ResourceLocation BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "scroll_bar.png");
    private static final int TEXTURE_WIDTH = 24;
    private static final int TEXTURE_HEIGHT = 15;
    private final IntSupplier maxElements;
    private final IntSupplier focusedElements;

    public GuiScrollBar(IGuiWrapper gui, int x, int y, int height, IntSupplier maxElements, IntSupplier focusedElements) {
        super(BAR, gui, x, y, 14, height, 1, 1, 12, 15, height - 2);
        this.maxElements = maxElements;
        this.focusedElements = focusedElements;
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        GuiUtils.renderBackgroundTexture(matrix, GuiElementHolder.HOLDER, 32, 32, this.getButtonX(), this.getButtonY(), this.barWidth + 2, this.getButtonHeight(), 256, 256);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GuiScrollBar.m_93133_((PoseStack)matrix, (int)this.barX, (int)(this.barY + this.getScroll()), (float)(this.needsScrollBars() ? 0.0f : (float)this.barWidth), (float)0.0f, (int)this.barWidth, (int)this.barHeight, (int)24, (int)15);
    }

    @Override
    protected int getMaxElements() {
        return this.maxElements.getAsInt();
    }

    @Override
    protected int getFocusedElements() {
        return this.focusedElements.getAsInt();
    }
}

