/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.to_server.PacketDropperUse;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class GuiTankGauge<T, TANK>
extends GuiGauge<T>
implements IJEIIngredientHelper {
    private final ITankInfoHandler<TANK> infoHandler;
    private final PacketDropperUse.TankType tankType;

    public GuiTankGauge(GaugeType type, IGuiWrapper gui, int x, int y, int sizeX, int sizeY, ITankInfoHandler<TANK> infoHandler, PacketDropperUse.TankType tankType) {
        super(type, gui, x, y, sizeX, sizeY);
        this.infoHandler = infoHandler;
        this.tankType = tankType;
    }

    public TANK getTank() {
        return this.infoHandler.getTank();
    }

    @Override
    protected GaugeInfo getGaugeColor() {
        IGuiWrapper iGuiWrapper = this.gui();
        if (iGuiWrapper instanceof GuiMekanismTile) {
            ISideConfiguration config;
            DataType dataType;
            Object tile;
            GuiMekanismTile gui = (GuiMekanismTile)iGuiWrapper;
            TANK tank = this.getTank();
            if (tank != null && (tile = ((MekanismTileContainer)gui.m_6262_()).getTileEntity()) instanceof ISideConfiguration && (dataType = (config = (ISideConfiguration)tile).getActiveDataType(tank)) != null) {
                return GaugeInfo.get(dataType);
            }
        }
        return super.getGaugeColor();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY) && this.tankType != null) {
            ItemStack stack = GuiTankGauge.minecraft.f_91074_.f_36096_.m_142621_();
            IGuiWrapper iGuiWrapper = this.gui();
            if (iGuiWrapper instanceof GuiMekanismTile) {
                GuiMekanismTile gui = (GuiMekanismTile)iGuiWrapper;
                if (!stack.m_41619_() && stack.m_41720_() instanceof ItemGaugeDropper) {
                    int index = this.infoHandler.getTankIndex();
                    if (index != -1) {
                        PacketDropperUse.DropperAction action = button == 0 ? (Screen.m_96638_() ? PacketDropperUse.DropperAction.DUMP_TANK : PacketDropperUse.DropperAction.FILL_DROPPER) : PacketDropperUse.DropperAction.DRAIN_DROPPER;
                        Mekanism.packetHandler().sendToServer(new PacketDropperUse(gui.getTileEntity().m_58899_(), action, this.tankType, index));
                    }
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public static interface ITankInfoHandler<TANK> {
        @Nullable
        public TANK getTank();

        public int getTankIndex();
    }
}

