/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class GuiDropdown<TYPE extends Enum<TYPE>>
extends GuiTexturedElement {
    private final Consumer<TYPE> handler;
    private final Supplier<TYPE> curType;
    private final TYPE[] options;
    private boolean isOpen;
    private boolean isHolding;

    public GuiDropdown(IGuiWrapper gui, int x, int y, int width, Class<TYPE> enumClass, Supplier<TYPE> curType, Consumer<TYPE> handler) {
        super(GuiInnerScreen.SCREEN, gui, x, y, width, 12);
        this.curType = curType;
        this.handler = handler;
        this.options = (Enum[])enumClass.getEnumConstants();
        this.f_93623_ = true;
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.isHolding = true;
        this.setOpen(!this.isOpen || mouseY > (double)(this.f_93621_ + 11));
        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        if (this.isHolding) {
            this.isHolding = false;
            if (this.isOpen && mouseY > (double)(this.f_93621_ + 11)) {
                this.handler.accept(this.options[this.getHoveredIndex(mouseX, mouseY)]);
                this.setOpen(false);
            }
        }
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        int maxWidth = this.f_93618_ - 11;
        Enum current = (Enum)this.curType.get();
        this.drawScaledTextScaledBound(matrix, ((GuiComponents.IDropdownEnum)((Object)current)).getShortName(), this.relativeX + 4, this.relativeY + 2, this.screenTextColor(), maxWidth, 0.8f);
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                this.drawScaledTextScaledBound(matrix, ((GuiComponents.IDropdownEnum)this.options[i]).getShortName(), this.relativeX + 4, this.relativeY + 11 + 2 + 10 * i, this.screenTextColor(), maxWidth, 0.8f);
            }
        }
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        Enum current;
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        matrix.m_85836_();
        matrix.m_85837_(0.0, 0.0, 1.0);
        this.renderBackgroundTexture(matrix, this.getResource(), GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1) {
            GuiUtils.drawOutline(matrix, this.f_93620_ + 1, this.f_93621_ + 12 + index * 10, this.f_93618_ - 2, 10, this.screenTextColor());
        }
        if (((GuiComponents.IDropdownEnum)((Object)(current = (Enum)this.curType.get()))).getIcon() != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)((GuiComponents.IDropdownEnum)((Object)current)).getIcon());
            GuiDropdown.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + this.f_93618_ - 9), (int)(this.f_93621_ + 3), (float)0.0f, (float)0.0f, (int)6, (int)6, (int)6, (int)6);
        }
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                ResourceLocation icon = ((GuiComponents.IDropdownEnum)this.options[i]).getIcon();
                if (icon == null) continue;
                RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
                GuiDropdown.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + this.f_93618_ - 9), (int)(this.f_93621_ + 12 + 2 + 10 * i), (float)0.0f, (float)0.0f, (int)6, (int)6, (int)6, (int)6);
            }
        }
        matrix.m_85849_();
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        Component text;
        super.m_7428_(matrix, mouseX, mouseY);
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1 && (text = ((GuiComponents.IDropdownEnum)this.options[index]).getTooltip()) != null) {
            this.displayTooltips(matrix, mouseX, mouseY, ((GuiComponents.IDropdownEnum)this.options[index]).getTooltip());
        }
    }

    private int getHoveredIndex(double mouseX, double mouseY) {
        if (this.isOpen && mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)(this.f_93621_ + 11) && mouseY < (double)(this.f_93621_ + this.f_93619_)) {
            return Math.max(0, Math.min(this.options.length - 1, (int)((mouseY - (double)this.f_93621_ - 11.0) / 10.0)));
        }
        return -1;
    }

    private void setOpen(boolean open) {
        if (this.isOpen != open) {
            this.f_93619_ = open ? (this.f_93619_ += this.options.length * 10 + 1) : (this.f_93619_ -= this.options.length * 10 + 1);
        }
        this.isOpen = open;
    }
}

