/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import mekanism.api.chemical.gas.EmptyGas;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.EmptyInfuseType;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.EmptyPigment;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.EmptySlurry;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.integration.jei.IMekanismJEIHelper;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.robit.RobitSkin;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class MekanismAPI {
    public static final String API_VERSION = "10.3.4";
    public static final String MEKANISM_MODID = "mekanism";
    public static boolean debug = false;
    public static final Logger logger = LogUtils.getLogger();
    @NotNull
    private static final Lazy<ResourceKey<? extends Registry<Gas>>> GAS_REGISTRY_NAME = MekanismAPI.registryKey(Gas.class, "gas");
    @NotNull
    private static final Lazy<ResourceKey<? extends Registry<InfuseType>>> INFUSE_TYPE_REGISTRY_NAME = MekanismAPI.registryKey(InfuseType.class, "infuse_type");
    @NotNull
    private static final Lazy<ResourceKey<? extends Registry<Pigment>>> PIGMENT_REGISTRY_NAME = MekanismAPI.registryKey(Pigment.class, "pigment");
    @NotNull
    private static final Lazy<ResourceKey<? extends Registry<Slurry>>> SLURRY_REGISTRY_NAME = MekanismAPI.registryKey(Slurry.class, "slurry");
    @NotNull
    private static final Lazy<ResourceKey<? extends Registry<ModuleData<?>>>> MODULE_REGISTRY_NAME = MekanismAPI.registryKey(ModuleData.class, "module");
    @NotNull
    private static final Lazy<ResourceKey<? extends Registry<RobitSkin>>> ROBIT_SKIN_REGISTRY_NAME = MekanismAPI.registryKey(RobitSkin.class, "robit_skin");
    private static IForgeRegistry<Gas> GAS_REGISTRY;
    private static IForgeRegistry<InfuseType> INFUSE_TYPE_REGISTRY;
    private static IForgeRegistry<Pigment> PIGMENT_REGISTRY;
    private static IForgeRegistry<Slurry> SLURRY_REGISTRY;
    private static IForgeRegistry<ModuleData<?>> MODULE_REGISTRY;
    private static IForgeRegistry<RobitSkin> ROBIT_SKIN_REGISTRY;
    private static IMekanismJEIHelper JEI_HELPER;
    private static IModuleHelper MODULE_HELPER;
    private static IRadialDataHelper RADIAL_DATA_HELPER;
    private static IRadiationManager RADIATION_MANAGER;
    private static ISecurityUtils SECURITY_UTILS;
    private static ITooltipHelper TOOLTIP_HELPER;
    @NotNull
    public static final Gas EMPTY_GAS;
    @NotNull
    public static final InfuseType EMPTY_INFUSE_TYPE;
    @NotNull
    public static final Pigment EMPTY_PIGMENT;
    @NotNull
    public static final Slurry EMPTY_SLURRY;

    private MekanismAPI() {
    }

    @NotNull
    private static <T> Lazy<ResourceKey<? extends Registry<T>>> registryKey(@NotNull Class<T> compileTimeTypeValidator, @NotNull String path) {
        return Lazy.of(() -> ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(MEKANISM_MODID, path)));
    }

    @NotNull
    public static ResourceKey<? extends Registry<Gas>> gasRegistryName() {
        return (ResourceKey)GAS_REGISTRY_NAME.get();
    }

    @NotNull
    public static ResourceKey<? extends Registry<InfuseType>> infuseTypeRegistryName() {
        return (ResourceKey)INFUSE_TYPE_REGISTRY_NAME.get();
    }

    @NotNull
    public static ResourceKey<? extends Registry<Pigment>> pigmentRegistryName() {
        return (ResourceKey)PIGMENT_REGISTRY_NAME.get();
    }

    @NotNull
    public static ResourceKey<? extends Registry<Slurry>> slurryRegistryName() {
        return (ResourceKey)SLURRY_REGISTRY_NAME.get();
    }

    @NotNull
    public static ResourceKey<? extends Registry<ModuleData<?>>> moduleRegistryName() {
        return (ResourceKey)MODULE_REGISTRY_NAME.get();
    }

    @NotNull
    public static ResourceKey<? extends Registry<RobitSkin>> robitSkinRegistryName() {
        return (ResourceKey)ROBIT_SKIN_REGISTRY_NAME.get();
    }

    @NotNull
    public static IForgeRegistry<Gas> gasRegistry() {
        if (GAS_REGISTRY == null) {
            GAS_REGISTRY = RegistryManager.ACTIVE.getRegistry(MekanismAPI.gasRegistryName());
        }
        return GAS_REGISTRY;
    }

    @NotNull
    public static IForgeRegistry<InfuseType> infuseTypeRegistry() {
        if (INFUSE_TYPE_REGISTRY == null) {
            INFUSE_TYPE_REGISTRY = RegistryManager.ACTIVE.getRegistry(MekanismAPI.infuseTypeRegistryName());
        }
        return INFUSE_TYPE_REGISTRY;
    }

    @NotNull
    public static IForgeRegistry<Pigment> pigmentRegistry() {
        if (PIGMENT_REGISTRY == null) {
            PIGMENT_REGISTRY = RegistryManager.ACTIVE.getRegistry(MekanismAPI.pigmentRegistryName());
        }
        return PIGMENT_REGISTRY;
    }

    @NotNull
    public static IForgeRegistry<Slurry> slurryRegistry() {
        if (SLURRY_REGISTRY == null) {
            SLURRY_REGISTRY = RegistryManager.ACTIVE.getRegistry(MekanismAPI.slurryRegistryName());
        }
        return SLURRY_REGISTRY;
    }

    @NotNull
    public static IForgeRegistry<ModuleData<?>> moduleRegistry() {
        if (MODULE_REGISTRY == null) {
            MODULE_REGISTRY = RegistryManager.ACTIVE.getRegistry(MekanismAPI.moduleRegistryName());
        }
        return MODULE_REGISTRY;
    }

    @NotNull
    public static IForgeRegistry<RobitSkin> robitSkinRegistry() {
        if (ROBIT_SKIN_REGISTRY == null) {
            ROBIT_SKIN_REGISTRY = RegistryManager.ACTIVE.getRegistry(MekanismAPI.robitSkinRegistryName());
        }
        return ROBIT_SKIN_REGISTRY;
    }

    public static IModuleHelper getModuleHelper() {
        if (MODULE_HELPER == null) {
            MekanismAPI.lookupInstance(IModuleHelper.class, "mekanism.common.content.gear.ModuleHelper", helper -> {
                MODULE_HELPER = helper;
            });
        }
        return MODULE_HELPER;
    }

    public static IRadialDataHelper getRadialDataHelper() {
        if (RADIAL_DATA_HELPER == null) {
            MekanismAPI.lookupInstance(IRadialDataHelper.class, "mekanism.common.lib.radial.data.RadialDataHelper", helper -> {
                RADIAL_DATA_HELPER = helper;
            });
        }
        return RADIAL_DATA_HELPER;
    }

    public static IRadiationManager getRadiationManager() {
        if (RADIATION_MANAGER == null) {
            MekanismAPI.lookupInstance(IRadiationManager.class, "mekanism.common.lib.radiation.RadiationManager", manager -> {
                RADIATION_MANAGER = manager;
            });
        }
        return RADIATION_MANAGER;
    }

    public static ITooltipHelper getTooltipHelper() {
        if (TOOLTIP_HELPER == null) {
            MekanismAPI.lookupInstance(ITooltipHelper.class, "mekanism.common.util.text.TooltipHelper", helper -> {
                TOOLTIP_HELPER = helper;
            });
        }
        return TOOLTIP_HELPER;
    }

    public static ISecurityUtils getSecurityUtils() {
        if (SECURITY_UTILS == null) {
            MekanismAPI.lookupInstance(ISecurityUtils.class, "mekanism.common.util.SecurityUtils", utils -> {
                SECURITY_UTILS = utils;
            });
        }
        return SECURITY_UTILS;
    }

    public static IMekanismJEIHelper getJeiHelper() {
        if (!ModList.get().isLoaded("jei")) {
            throw new IllegalStateException("JEI is not loaded.");
        }
        if (JEI_HELPER == null) {
            MekanismAPI.lookupInstance(IMekanismJEIHelper.class, "mekanism.client.jei.MekanismJEIHelper", helper -> {
                JEI_HELPER = helper;
            });
        }
        return JEI_HELPER;
    }

    private static <TYPE> void lookupInstance(Class<TYPE> type, String className, Consumer<TYPE> setter) {
        try {
            Class<?> clazz = Class.forName(className);
            setter.accept(type.cast(clazz.getField("INSTANCE").get(null)));
        }
        catch (ReflectiveOperationException ex) {
            logger.error(LogUtils.FATAL_MARKER, "Error retrieving {}, Mekanism may be absent, damaged, or outdated.", (Object)className);
        }
    }

    static {
        EMPTY_GAS = new EmptyGas();
        EMPTY_INFUSE_TYPE = new EmptyInfuseType();
        EMPTY_PIGMENT = new EmptyPigment();
        EMPTY_SLURRY = new EmptySlurry();
    }
}

