/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeAccessModifier;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class UpgradeHandler
extends ItemStackHandler {
    public static final String UPGRADE_INVENTORY_TAG = "upgradeInventory";
    private final IStorageWrapper storageWrapper;
    private final Runnable contentsSaveHandler;
    private final Runnable onInvalidateUpgradeCaches;
    private final CompoundTag contentsNbt;
    @Nullable
    private Runnable refreshCallBack = null;
    private final Map<Integer, IUpgradeWrapper> slotWrappers = new LinkedHashMap<Integer, IUpgradeWrapper>();
    private final Map<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>> typeWrappers = new HashMap<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>>();
    private boolean justSavingNbtChange = false;
    private boolean wrappersInitialized = false;
    private boolean typeWrappersInitialized = false;
    @Nullable
    private IUpgradeWrapperAccessor wrapperAccessor = null;
    private boolean persistent = true;

    public UpgradeHandler(int numberOfUpgradeSlots, IStorageWrapper storageWrapper, CompoundTag contentsNbt, Runnable contentsSaveHandler, Runnable onInvalidateUpgradeCaches) {
        super(numberOfUpgradeSlots);
        this.contentsNbt = contentsNbt;
        this.storageWrapper = storageWrapper;
        this.contentsSaveHandler = contentsSaveHandler;
        this.onInvalidateUpgradeCaches = onInvalidateUpgradeCaches;
        this.deserializeNBT(contentsNbt.m_128469_(UPGRADE_INVENTORY_TAG));
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.m_41619_() || stack.m_41720_() instanceof IUpgradeItem;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.persistent) {
            this.saveInventory();
            this.contentsSaveHandler.run();
        }
        if (!this.justSavingNbtChange) {
            this.refreshUpgradeWrappers();
        }
    }

    public void setSize(int size) {
        super.setSize(this.stacks.size());
    }

    public void saveInventory() {
        this.contentsNbt.m_128365_(UPGRADE_INVENTORY_TAG, (Tag)this.serializeNBT());
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setRefreshCallBack(Runnable refreshCallBack) {
        this.refreshCallBack = refreshCallBack;
    }

    public void removeRefreshCallback() {
        this.refreshCallBack = null;
    }

    private void initializeWrappers() {
        if (this.wrappersInitialized) {
            return;
        }
        this.wrappersInitialized = true;
        this.slotWrappers.clear();
        this.typeWrappers.clear();
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.clearCache();
        }
        InventoryHelper.iterate((IItemHandler)this, (slot, upgrade) -> {
            if (upgrade.m_41619_() || !(upgrade.m_41720_() instanceof IUpgradeItem)) {
                return;
            }
            UpgradeType type = ((IUpgradeItem)upgrade.m_41720_()).getType();
            Object wrapper = type.create(this.storageWrapper, (ItemStack)upgrade, upgradeStack -> {
                this.justSavingNbtChange = true;
                this.setStackInSlot((int)slot, (ItemStack)upgradeStack);
                this.justSavingNbtChange = false;
            });
            this.slotWrappers.put((Integer)slot, (IUpgradeWrapper)wrapper);
        });
        this.initRenderInfoCallbacks(false);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        Map<Integer, IUpgradeWrapper> wrappers;
        ItemStack slotStack = this.getStackInSlot(slot);
        if (this.persistent && !slotStack.m_41619_() && amount == 1 && (wrappers = this.getSlotWrappers()).containsKey(slot)) {
            wrappers.get(slot).onBeforeRemoved();
        }
        return super.extractItem(slot, amount, simulate);
    }

    private void initializeTypeWrappers() {
        if (this.typeWrappersInitialized) {
            return;
        }
        this.initializeWrappers();
        this.typeWrappersInitialized = true;
        this.typeWrappers.clear();
        this.slotWrappers.values().forEach(wrapper -> {
            Item patt4225$temp = wrapper.getUpgradeStack().m_41720_();
            if (patt4225$temp instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)patt4225$temp;
                UpgradeType type = upgradeItem.getType();
                if (wrapper.isEnabled()) {
                    this.addTypeWrapper(type, wrapper);
                }
            }
        });
        this.initRenderInfoCallbacks(false);
    }

    private <T extends IUpgradeWrapper> void addTypeWrapper(UpgradeType<?> type, T wrapper) {
        this.typeWrappers.computeIfAbsent(type, t -> new ArrayList()).add(wrapper);
    }

    public <T extends IUpgradeWrapper> List<T> getTypeWrappers(UpgradeType<T> type) {
        this.initializeTypeWrappers();
        return this.typeWrappers.getOrDefault(type, Collections.emptyList());
    }

    public <T extends IUpgradeWrapper> boolean hasUpgrade(UpgradeType<T> type) {
        return !this.getTypeWrappers(type).isEmpty();
    }

    public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplement(upgradeClass);
    }

    private IUpgradeWrapperAccessor getWrapperAccessor() {
        if (this.wrapperAccessor == null) {
            IUpgradeWrapperAccessor accessor = new Accessor(this);
            for (IUpgradeAccessModifier upgrade : this.getListOfWrappersThatImplement(IUpgradeAccessModifier.class)) {
                accessor = upgrade.wrapAccessor(accessor);
            }
            this.wrapperAccessor = accessor;
        }
        return this.wrapperAccessor;
    }

    public <T> List<T> getWrappersThatImplementFromMainStorage(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplementFromMainStorage(upgradeClass);
    }

    public <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<IUpgradeWrapper> ret = new ArrayList<IUpgradeWrapper>();
        for (IUpgradeWrapper wrapper : this.slotWrappers.values()) {
            if (!wrapper.isEnabled() || !uc.isInstance(wrapper)) continue;
            ret.add(wrapper);
        }
        return ret;
    }

    public Map<Integer, IUpgradeWrapper> getSlotWrappers() {
        this.initializeWrappers();
        return this.slotWrappers;
    }

    public void copyTo(UpgradeHandler otherHandler) {
        InventoryHelper.copyTo((IItemHandlerModifiable)this, (IItemHandlerModifiable)otherHandler);
    }

    public void refreshWrappersThatImplementAndTypeWrappers() {
        this.typeWrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.clearCache();
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
    }

    public void refreshUpgradeWrappers() {
        this.wrappersInitialized = false;
        this.typeWrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.onBeforeDeconstruct();
            this.wrapperAccessor = null;
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
        this.onInvalidateUpgradeCaches.run();
        this.initRenderInfoCallbacks(true);
    }

    private void initRenderInfoCallbacks(boolean forceUpdateRenderInfo) {
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        if (forceUpdateRenderInfo) {
            renderInfo.resetUpgradeInfo(true);
        }
        this.initTankRenderInfoCallbacks(forceUpdateRenderInfo, renderInfo);
        this.initBatteryRenderInfoCallbacks(forceUpdateRenderInfo, renderInfo);
    }

    private void initBatteryRenderInfoCallbacks(boolean forceUpdateRenderInfo, RenderInfo renderInfo) {
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedBatteryUpgrade) {
                IRenderedBatteryUpgrade batteryWrapper = (IRenderedBatteryUpgrade)((Object)wrapper);
                batteryWrapper.setBatteryRenderInfoUpdateCallback(renderInfo::setBatteryRenderInfo);
                if (forceUpdateRenderInfo) {
                    batteryWrapper.forceUpdateBatteryRenderInfo();
                }
            }
        });
    }

    private void initTankRenderInfoCallbacks(boolean forceUpdateRenderInfo, RenderInfo renderInfo) {
        AtomicBoolean singleTankRight = new AtomicBoolean(false);
        ArrayList tankRenderWrappers = new ArrayList();
        int minRightSlot = this.getSlots() / 2;
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedTankUpgrade) {
                IRenderedTankUpgrade tankUpgrade = (IRenderedTankUpgrade)((Object)wrapper);
                tankRenderWrappers.add(tankUpgrade);
                if (slot >= minRightSlot) {
                    singleTankRight.set(true);
                }
            }
        });
        TankPosition currentTankPos = tankRenderWrappers.size() == 1 && singleTankRight.get() ? TankPosition.RIGHT : TankPosition.LEFT;
        for (IRenderedTankUpgrade tankRenderWrapper : tankRenderWrappers) {
            TankPosition finalCurrentTankPos = currentTankPos;
            tankRenderWrapper.setTankRenderInfoUpdateCallback(tankRenderInfo -> renderInfo.setTankRenderInfo(finalCurrentTankPos, (IRenderedTankUpgrade.TankRenderInfo)tankRenderInfo));
            if (forceUpdateRenderInfo) {
                tankRenderWrapper.forceUpdateTankRenderInfo();
            }
            currentTankPos = TankPosition.RIGHT;
        }
    }

    public void increaseSize(int diff) {
        NonNullList previousStacks = this.stacks;
        this.stacks = NonNullList.m_122780_((int)(previousStacks.size() + diff), (Object)ItemStack.f_41583_);
        for (int slot = 0; slot < previousStacks.size(); ++slot) {
            this.stacks.set(slot, (Object)((ItemStack)previousStacks.get(slot)));
        }
        this.saveInventory();
    }

    private static class Accessor
    implements IUpgradeWrapperAccessor {
        private final Map<Class<?>, List<?>> interfaceWrappers = new HashMap();
        private final UpgradeHandler upgradeHandler;

        public Accessor(UpgradeHandler upgradeHandler) {
            this.upgradeHandler = upgradeHandler;
        }

        @Override
        public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public <T> List<T> getWrappersThatImplementFromMainStorage(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public void clearCache() {
            this.interfaceWrappers.clear();
        }
    }
}

