/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.util.inventory_change_listening;

import com.abdelaziz.canary.api.inventory.CanaryInventory;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeEmitter;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import com.abdelaziz.canary.common.hopper.CanaryStackList;
import com.abdelaziz.canary.common.hopper.InventoryHelper;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import net.minecraft.world.Container;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={RandomizableContainerBlockEntity.class})
public abstract class RandomizableContainerBlockEntityMixin
implements InventoryChangeEmitter,
Container {
    ReferenceArraySet<InventoryChangeListener> inventoryChangeListeners = null;
    ReferenceArraySet<InventoryChangeListener> inventoryHandlingTypeListeners = null;

    @Override
    public void emitContentModified() {
        ReferenceArraySet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null) {
            for (InventoryChangeListener inventoryChangeListener : inventoryChangeListeners) {
                inventoryChangeListener.handleInventoryContentModified(this);
            }
            inventoryChangeListeners.clear();
        }
    }

    @Override
    public void emitStackListReplaced() {
        RandomizableContainerBlockEntityMixin randomizableContainerBlockEntityMixin;
        ReferenceArraySet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            for (InventoryChangeListener inventoryChangeListener : listeners) {
                inventoryChangeListener.handleStackListReplaced(this);
            }
            listeners.clear();
        }
        if ((randomizableContainerBlockEntityMixin = this) instanceof InventoryChangeListener) {
            InventoryChangeListener listener = (InventoryChangeListener)((Object)randomizableContainerBlockEntityMixin);
            listener.handleStackListReplaced(this);
        }
        this.invalidateChangeListening();
    }

    @Override
    public void emitRemoved() {
        RandomizableContainerBlockEntityMixin randomizableContainerBlockEntityMixin;
        ReferenceArraySet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            for (InventoryChangeListener listener : listeners) {
                listener.handleInventoryRemoved(this);
            }
            listeners.clear();
        }
        if ((randomizableContainerBlockEntityMixin = this) instanceof InventoryChangeListener) {
            InventoryChangeListener listener = (InventoryChangeListener)((Object)randomizableContainerBlockEntityMixin);
            listener.handleInventoryRemoved(this);
        }
        this.invalidateChangeListening();
    }

    private void invalidateChangeListening() {
        RandomizableContainerBlockEntityMixin randomizableContainerBlockEntityMixin;
        CanaryStackList canaryStackList;
        if (this.inventoryChangeListeners != null) {
            this.inventoryChangeListeners.clear();
        }
        CanaryStackList canaryStackList2 = canaryStackList = this instanceof CanaryInventory ? InventoryHelper.getCanaryStackListOrNull((CanaryInventory)((Object)this)) : null;
        if (canaryStackList != null && (randomizableContainerBlockEntityMixin = this) instanceof InventoryChangeTracker) {
            InventoryChangeTracker inventoryChangeTracker = (InventoryChangeTracker)((Object)randomizableContainerBlockEntityMixin);
            canaryStackList.removeInventoryModificationCallback(inventoryChangeTracker);
        }
    }

    @Override
    public void emitFirstComparatorAdded() {
        ReferenceArraySet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null && !inventoryChangeListeners.isEmpty()) {
            inventoryChangeListeners.removeIf(inventoryChangeListener -> inventoryChangeListener.handleComparatorAdded(this));
        }
    }

    @Override
    public void forwardContentChangeOnce(InventoryChangeListener inventoryChangeListener, CanaryStackList stackList, InventoryChangeTracker thisTracker) {
        if (this.inventoryChangeListeners == null) {
            this.inventoryChangeListeners = new ReferenceArraySet(1);
        }
        stackList.setInventoryModificationCallback(thisTracker);
        this.inventoryChangeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void forwardMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = new ReferenceArraySet(1);
        }
        this.inventoryHandlingTypeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void stopForwardingMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners != null) {
            this.inventoryHandlingTypeListeners.remove((Object)inventoryChangeListener);
        }
    }
}

