/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.util.entity_movement_tracking;

import com.abdelaziz.canary.common.entity.PositionedEntityTrackingSection;
import com.abdelaziz.canary.common.entity.movement_tracker.EntityMovementTrackerSection;
import com.abdelaziz.canary.common.entity.movement_tracker.MovementTrackerHelper;
import com.abdelaziz.canary.common.entity.movement_tracker.SectionedEntityMovementTracker;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntitySection.class})
public abstract class EntitySectionMixin<T extends EntityAccess>
implements EntityMovementTrackerSection,
PositionedEntityTrackingSection {
    @Shadow
    private Visibility f_156828_;
    private final ReferenceOpenHashSet<SectionedEntityMovementTracker<?, ?>> sectionVisibilityListeners = new ReferenceOpenHashSet(0);
    private final ArrayList<SectionedEntityMovementTracker<?, ?>>[] entityMovementListenersByType = new ArrayList[MovementTrackerHelper.NUM_MOVEMENT_NOTIFYING_CLASSES];
    private final long[] lastEntityMovementByType = new long[MovementTrackerHelper.NUM_MOVEMENT_NOTIFYING_CLASSES];

    @Shadow
    public abstract boolean m_156833_();

    @Override
    public void addListener(SectionedEntityMovementTracker<?, ?> listener) {
        this.sectionVisibilityListeners.add(listener);
        if (this.f_156828_.m_157694_()) {
            listener.onSectionEnteredRange(this);
        }
    }

    @Override
    public void removeListener(EntitySectionStorage<?> sectionedEntityCache, SectionedEntityMovementTracker<?, ?> listener) {
        boolean removed = this.sectionVisibilityListeners.remove(listener);
        if (this.f_156828_.m_157694_() && removed) {
            listener.onSectionLeftRange(this);
        }
        if (this.m_156833_()) {
            sectionedEntityCache.m_156897_(this.getPos());
        }
    }

    @Override
    public void trackEntityMovement(int notificationMask, long time) {
        long[] lastEntityMovementByType = this.lastEntityMovementByType;
        int size = lastEntityMovementByType.length;
        int entityClassIndex = Integer.numberOfTrailingZeros(notificationMask);
        while (entityClassIndex < size) {
            lastEntityMovementByType[entityClassIndex] = time;
            ArrayList<SectionedEntityMovementTracker<?, ?>> entityMovementListeners = this.entityMovementListenersByType[entityClassIndex];
            if (entityMovementListeners != null) {
                for (int listIndex = entityMovementListeners.size() - 1; listIndex >= 0; --listIndex) {
                    SectionedEntityMovementTracker<?, ?> sectionedEntityMovementTracker = entityMovementListeners.remove(listIndex);
                    sectionedEntityMovementTracker.emitEntityMovement(notificationMask, this);
                }
            }
            int mask = -2 << entityClassIndex;
            entityClassIndex = Integer.numberOfTrailingZeros(notificationMask & mask);
        }
    }

    @Override
    public long getChangeTime(int trackedClass) {
        return this.lastEntityMovementByType[trackedClass];
    }

    @Inject(method={"isEmpty()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> cir) {
        if (!this.sectionVisibilityListeners.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"updateChunkStatus(Lnet/minecraft/world/level/entity/Visibility;)Lnet/minecraft/world/level/entity/Visibility;"}, at=@At(value="HEAD"), argsOnly=true)
    public Visibility swapStatus(Visibility newStatus) {
        block3: {
            block4: {
                if (this.f_156828_.m_157694_() == newStatus.m_157694_()) break block3;
                if (newStatus.m_157694_()) break block4;
                if (this.sectionVisibilityListeners.isEmpty()) break block3;
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionLeftRange(this);
                }
                break block3;
            }
            if (!this.sectionVisibilityListeners.isEmpty()) {
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionEnteredRange(this);
                }
            }
        }
        return newStatus;
    }

    @Override
    public <S, E extends EntityAccess> void listenToMovementOnce(SectionedEntityMovementTracker<E, S> listener, int trackedClass) {
        if (this.entityMovementListenersByType[trackedClass] == null) {
            this.entityMovementListenersByType[trackedClass] = new ArrayList();
        }
        this.entityMovementListenersByType[trackedClass].add(listener);
    }

    @Override
    public <S, E extends EntityAccess> void removeListenToMovementOnce(SectionedEntityMovementTracker<E, S> listener, int trackedClass) {
        if (this.entityMovementListenersByType[trackedClass] != null) {
            this.entityMovementListenersByType[trackedClass].remove(listener);
        }
    }
}

