/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.mixin.ai.nearby_entity_tracking;

import com.abdelaziz.canary.common.entity.PositionedEntityTrackingSection;
import com.abdelaziz.canary.common.entity.nearby_tracker.NearbyEntityListener;
import com.abdelaziz.canary.common.entity.nearby_tracker.NearbyEntityListenerSection;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntitySection.class})
public abstract class EntitySectionMixin<T extends EntityAccess>
implements NearbyEntityListenerSection,
PositionedEntityTrackingSection {
    @Shadow
    private Visibility f_156828_;
    @Shadow
    @Final
    private ClassInstanceMultiMap<T> f_156827_;
    private final ReferenceOpenHashSet<NearbyEntityListener> nearbyEntityListeners = new ReferenceOpenHashSet(0);

    @Shadow
    public abstract boolean m_156833_();

    @Override
    public void addListener(NearbyEntityListener listener) {
        this.nearbyEntityListeners.add((Object)listener);
        if (this.f_156828_.m_157694_()) {
            listener.onSectionEnteredRange(this, this.f_156827_);
        }
    }

    @Override
    public void removeListener(EntitySectionStorage<?> sectionedEntityCache, NearbyEntityListener listener) {
        boolean removed = this.nearbyEntityListeners.remove((Object)listener);
        if (this.f_156828_.m_157694_() && removed) {
            listener.onSectionLeftRange(this, this.f_156827_);
        }
        if (this.m_156833_()) {
            sectionedEntityCache.m_156897_(this.getPos());
        }
    }

    @Inject(method={"isEmpty()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void isEmpty(CallbackInfoReturnable<Boolean> cir) {
        if (!this.nearbyEntityListeners.isEmpty()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/level/entity/EntityAccess;)V"}, at={@At(value="RETURN")})
    private void onEntityAdded(T entityLike, CallbackInfo ci) {
        if (!this.f_156828_.m_157694_() || this.nearbyEntityListeners.isEmpty()) {
            return;
        }
        if (entityLike instanceof Entity) {
            Entity entity = (Entity)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityEnteredRange(entity);
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/world/level/entity/EntityAccess;)Z"}, at={@At(value="RETURN")})
    private void onEntityRemoved(T entityLike, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_156828_.m_157694_() && !this.nearbyEntityListeners.isEmpty() && entityLike instanceof Entity) {
            Entity entity = (Entity)entityLike;
            for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                nearbyEntityListener.onEntityLeftRange(entity);
            }
        }
    }

    @ModifyVariable(method={"updateChunkStatus(Lnet/minecraft/world/level/entity/Visibility;)Lnet/minecraft/world/level/entity/Visibility;"}, at=@At(value="HEAD"), argsOnly=true)
    public Visibility swapStatus(Visibility newStatus) {
        block3: {
            block4: {
                if (this.f_156828_.m_157694_() == newStatus.m_157694_()) break block3;
                if (newStatus.m_157694_()) break block4;
                if (this.nearbyEntityListeners.isEmpty()) break block3;
                for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                    nearbyEntityListener.onSectionLeftRange(this, this.f_156827_);
                }
                break block3;
            }
            if (!this.nearbyEntityListeners.isEmpty()) {
                for (NearbyEntityListener nearbyEntityListener : this.nearbyEntityListeners) {
                    nearbyEntityListener.onSectionEnteredRange(this, this.f_156827_);
                }
            }
        }
        return newStatus;
    }
}

