/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.data.GlobalVariables;
import com.natamus.collective_common_fabric.functions.CommandFunctions;
import com.natamus.collective_common_fabric.functions.CompareBlockFunctions;
import com.natamus.collective_common_fabric.functions.NumberFunctions;
import com.natamus.collective_common_fabric.functions.RayTraceFunctions;
import com.natamus.collective_common_fabric.functions.WorldFunctions;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3614;
import net.minecraft.class_6885;

public class BlockPosFunctions {
    private static final HashMap<class_2338, Integer> rgnbcount = new HashMap();
    private static final HashMap<class_2338, Integer> rgnbmcount = new HashMap();

    public static List<class_2338> getBlocksAround(class_2338 pos, boolean down) {
        ArrayList<class_2338> around = new ArrayList<class_2338>();
        around.add(pos.method_10095());
        around.add(pos.method_10078());
        around.add(pos.method_10072());
        around.add(pos.method_10067());
        around.add(pos.method_10084());
        if (down) {
            around.add(pos.method_10074());
        }
        return around;
    }

    public static List<class_2338> getBlocksNextToEachOther(class_1937 world, class_2338 startpos, List<class_2248> possibleblocks) {
        return BlockPosFunctions.getBlocksNextToEachOther(world, startpos, possibleblocks, 50);
    }

    public static List<class_2338> getBlocksNextToEachOther(class_1937 world, class_2338 startpos, List<class_2248> possibleblocks, int maxDistance) {
        ArrayList<class_2338> checkedblocks = new ArrayList<class_2338>();
        ArrayList<class_2338> theblocksaround = new ArrayList<class_2338>();
        if (possibleblocks.contains(world.method_8320(startpos).method_26204())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbcount.put(startpos.method_10062(), 0);
        BlockPosFunctions.recursiveGetNextBlocks(world, startpos, startpos, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocks(class_1937 world, class_2338 startpos, class_2338 pos, List<class_2248> possibleblocks, List<class_2338> theblocksaround, List<class_2338> checkedblocks, int maxDistance) {
        int rgnbc = rgnbcount.get(startpos);
        if (rgnbc > 100) {
            return;
        }
        rgnbcount.put(startpos, rgnbc + 1);
        List<class_2338> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (class_2338 pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possibleblocks.contains(world.method_8320(pba).method_26204()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocks(world, startpos, pba, possibleblocks, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static List<class_2338> getBlocksNextToEachOtherMaterial(class_1937 world, class_2338 startpos, List<class_3614> possiblematerials) {
        return BlockPosFunctions.getBlocksNextToEachOtherMaterial(world, startpos, possiblematerials, 50);
    }

    public static List<class_2338> getBlocksNextToEachOtherMaterial(class_1937 world, class_2338 startpos, List<class_3614> possiblematerials, int maxDistance) {
        ArrayList<class_2338> checkedblocks = new ArrayList<class_2338>();
        ArrayList<class_2338> theblocksaround = new ArrayList<class_2338>();
        if (possiblematerials.contains(world.method_8320(startpos).method_26207())) {
            theblocksaround.add(startpos);
            checkedblocks.add(startpos);
        }
        rgnbmcount.put(startpos.method_10062(), 0);
        BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, startpos, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        return theblocksaround;
    }

    private static void recursiveGetNextBlocksMaterial(class_1937 world, class_2338 startpos, class_2338 pos, List<class_3614> possiblematerials, List<class_2338> theblocksaround, List<class_2338> checkedblocks, int maxDistance) {
        int rgnbmc = rgnbmcount.get(startpos);
        if (rgnbmc > 100) {
            return;
        }
        rgnbmcount.put(startpos, rgnbmc + 1);
        List<class_2338> possibleblocksaround = BlockPosFunctions.getBlocksAround(pos, true);
        for (class_2338 pba : possibleblocksaround) {
            if (checkedblocks.contains(pba)) continue;
            checkedblocks.add(pba);
            if (!possiblematerials.contains(world.method_8320(pba).method_26207()) || theblocksaround.contains(pba)) continue;
            theblocksaround.add(pba);
            if (!BlockPosFunctions.withinDistance(startpos, pba, maxDistance).booleanValue()) continue;
            BlockPosFunctions.recursiveGetNextBlocksMaterial(world, startpos, pba, possiblematerials, theblocksaround, checkedblocks, maxDistance);
        }
    }

    public static class_2338 getSurfaceBlockPos(class_3218 serverLevel, int x, int z) {
        return BlockPosFunctions.getSurfaceBlockPos(serverLevel, x, z, false);
    }

    public static class_2338 getSurfaceBlockPos(class_3218 serverLevel, int x, int z, boolean ignoreTrees) {
        int height = serverLevel.method_31605();
        int lowestY = serverLevel.method_31607();
        class_2338 returnpos = new class_2338(x, height - 1, z);
        if (!WorldFunctions.isNether((class_1937)serverLevel)) {
            class_2338 pos = new class_2338(x, height, z);
            for (int y = height; y > lowestY; --y) {
                class_2248 block;
                boolean continueCycle = false;
                class_2680 blockState = serverLevel.method_8320(pos);
                if (ignoreTrees && (CompareBlockFunctions.isTreeLeaf(block = blockState.method_26204()) || CompareBlockFunctions.isTreeLog(block))) {
                    continueCycle = true;
                }
                if (!continueCycle) {
                    class_3614 material = blockState.method_26207();
                    if (blockState.method_26193((class_1922)serverLevel, pos) >= 15 || GlobalVariables.surfacematerials.contains(material)) {
                        returnpos = pos.method_10084().method_10062();
                        break;
                    }
                }
                pos = pos.method_10074();
            }
        } else {
            int maxheight = 128;
            class_2338 pos = new class_2338(x, lowestY, z);
            for (int y = lowestY; y < maxheight; ++y) {
                class_2680 upstate;
                class_2680 blockstate = serverLevel.method_8320(pos);
                if (blockstate.method_26204().equals(class_2246.field_10124) && (upstate = serverLevel.method_8320(pos.method_10084())).method_26204().equals(class_2246.field_10124)) {
                    returnpos = pos.method_10062();
                    break;
                }
                pos = pos.method_10084();
            }
        }
        return returnpos;
    }

    public static class_2338 getCenterNearbyVillage(class_3218 serverLevel) {
        return BlockPosFunctions.getNearbyVillage(serverLevel, new class_2338(0, 0, 0));
    }

    public static class_2338 getNearbyVillage(class_3218 serverLevel, class_2338 nearPos) {
        class_2338 closestvillage = null;
        if (!serverLevel.method_8503().method_27728().method_28057().method_28029()) {
            return null;
        }
        String rawOutput = CommandFunctions.getRawCommandOutput(serverLevel, class_243.method_24955((class_2382)nearPos), "/locate structure #minecraft:village");
        if (rawOutput.contains("[") && rawOutput.contains("]") && rawOutput.contains(", ")) {
            String[] coords;
            try {
                if (rawOutput.contains(":")) {
                    rawOutput = rawOutput.split(":", 2)[1];
                }
                String rawcoords = rawOutput.split("\\[")[1].split("]")[0];
                coords = rawcoords.split(", ");
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
            if (coords.length == 3) {
                String sx = coords[0];
                String sz = coords[2];
                if (NumberFunctions.isNumeric(sx) && NumberFunctions.isNumeric(sz)) {
                    return BlockPosFunctions.getSurfaceBlockPos(serverLevel, Integer.parseInt(sx), Integer.parseInt(sz));
                }
            }
        }
        return closestvillage;
    }

    public static class_2338 getCenterNearbyBiome(class_3218 serverLevel, String biome) {
        return BlockPosFunctions.getNearbyBiome(serverLevel, new class_2338(0, 0, 0), biome);
    }

    public static class_2338 getNearbyBiome(class_3218 serverLevel, class_2338 nearPos, String biome) {
        String rawOutput = CommandFunctions.getRawCommandOutput(serverLevel, class_243.method_24955((class_2382)nearPos), "/locate biome " + biome);
        if (rawOutput.contains("[") && rawOutput.contains("]") && rawOutput.contains(", ")) {
            String[] coords;
            try {
                if (rawOutput.contains(":")) {
                    rawOutput = rawOutput.split(":", 2)[1];
                }
                String rawcoords = rawOutput.split("\\[")[1].split("]")[0];
                coords = rawcoords.split(", ");
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
            if (coords.length == 3) {
                String sx = coords[0];
                String sz = coords[2];
                if (NumberFunctions.isNumeric(sx) && NumberFunctions.isNumeric(sz)) {
                    return BlockPosFunctions.getSurfaceBlockPos(serverLevel, Integer.parseInt(sx), Integer.parseInt(sz));
                }
            }
        }
        return null;
    }

    public static class_2338 getCenterNearbyStructure(class_3218 serverworld, class_6885<class_3195> structure) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, new class_2338(0, 0, 0));
    }

    public static class_2338 getNearbyStructure(class_3218 serverworld, class_6885<class_3195> structure, class_2338 nearpos) {
        return BlockPosFunctions.getNearbyStructure(serverworld, structure, nearpos, 9999);
    }

    public static class_2338 getNearbyStructure(class_3218 serverworld, class_6885<class_3195> structure, class_2338 nearpos, int radius) {
        Pair pair = serverworld.method_14178().method_12129().method_12103(serverworld, structure, nearpos, radius, false);
        if (pair == null) {
            return null;
        }
        class_2338 villagepos = (class_2338)pair.getFirst();
        if (villagepos == null) {
            return null;
        }
        class_2338 spawnpos = null;
        for (int y = serverworld.method_31605() - 1; y > 0; --y) {
            class_2338 checkpos = new class_2338(villagepos.method_10263(), y, villagepos.method_10260());
            if (serverworld.method_8320(checkpos).method_26204().equals(class_2246.field_10124)) continue;
            spawnpos = checkpos.method_10084().method_10062();
            break;
        }
        return spawnpos;
    }

    public static class_2338 getBlockPlayerIsLookingAt(class_1937 world, class_1657 player, boolean stopOnLiquid) {
        class_239 raytraceresult = RayTraceFunctions.rayTrace(world, player, stopOnLiquid);
        double posX = raytraceresult.method_17784().field_1352;
        double posY = Math.floor(raytraceresult.method_17784().field_1351);
        double posZ = raytraceresult.method_17784().field_1350;
        return new class_2338(posX, posY, posZ);
    }

    public static class_2338 getRandomCoordinatesInNearestUngeneratedChunk(class_3218 serverLevel, class_2338 aroundPosition) {
        int outputRegionZ;
        int outputRegionX;
        ArrayList<String> regionList = new ArrayList<String>();
        try {
            File[] listOfRegionFiles;
            File regionFolder = new File(WorldFunctions.getWorldPath(serverLevel) + File.separator + "region");
            for (File regionFile : listOfRegionFiles = regionFolder.listFiles()) {
                if (!regionFile.isFile()) continue;
                regionList.add(regionFile.getName().replaceAll("r.", "").replaceAll(".mca", ""));
            }
        }
        catch (NullPointerException ignored) {
            return null;
        }
        class_1923 chunkPos = serverLevel.method_8500(aroundPosition).method_12004();
        int curRegionX = chunkPos.method_17885();
        int curRegionZ = chunkPos.method_17886();
        int currentRange = 1;
        int loops = 0;
        Object closestUngeneratedRegionString = "";
        while (((String)closestUngeneratedRegionString).equals("")) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int regionX = curRegionX + x * currentRange;
                    int regionZ = curRegionZ + z * currentRange;
                    String regionString = regionX + "." + regionZ;
                    if (regionList.contains(regionString)) continue;
                    closestUngeneratedRegionString = regionString;
                    break;
                }
                if (!((String)closestUngeneratedRegionString).equals("")) break;
            }
            ++currentRange;
            if (++loops <= 50) continue;
            return null;
        }
        String[] cursspl = ((String)closestUngeneratedRegionString).split("\\.");
        try {
            outputRegionX = Integer.parseInt(cursspl[0]);
            outputRegionZ = Integer.parseInt(cursspl[1]);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        int minXRange = outputRegionX * 512 - 256;
        int maxXRange = outputRegionX * 512 + 256;
        int minZRange = outputRegionZ * 512 - 256;
        int maxZRange = outputRegionZ * 512 + 256;
        int randomXCoord = ThreadLocalRandom.current().nextInt(minXRange, maxXRange + 1);
        int randomZCoord = ThreadLocalRandom.current().nextInt(minZRange, maxZRange + 1);
        int randomYCoord = BlockPosFunctions.getSurfaceBlockPos(serverLevel, randomXCoord, randomZCoord).method_10264();
        return new class_2338(randomXCoord, randomYCoord, randomZCoord);
    }

    public static Boolean isOnSurface(class_1937 world, class_2338 pos) {
        return world.method_8311(pos);
    }

    public static Boolean isOnSurface(class_1937 world, class_243 vecpos) {
        return BlockPosFunctions.isOnSurface(world, new class_2338(vecpos.field_1352, vecpos.field_1351, vecpos.field_1350));
    }

    public static Boolean withinDistance(class_2338 start, class_2338 end, int distance) {
        return BlockPosFunctions.withinDistance(start, end, (double)distance);
    }

    public static Boolean withinDistance(class_2338 start, class_2338 end, double distance) {
        return start.method_19771((class_2382)end, distance);
    }

    public static class_2338 getBlockPosFromHitResult(class_239 hitresult) {
        class_243 vec = hitresult.method_17784();
        return new class_2338(vec.field_1352, vec.field_1351, vec.field_1350);
    }
}

