/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.DeathManager;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RestoreCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"restore").requires(commandSource -> commandSource.m_6761_(2));
        Command add = commandSource -> {
            UUID deathID = UuidArgument.m_113853_((CommandContext)commandSource, (String)"death_id");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)commandSource, (String)"target");
            Death death = DeathManager.getDeath(player.m_9236_(), deathID);
            if (death == null) {
                ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)Component.m_237110_((String)"message.gravestone.death_id_not_found", (Object[])new Object[]{deathID.toString()}));
                return 0;
            }
            for (ItemStack stack : death.getAllItems()) {
                if (player.m_150109_().m_36054_(stack)) continue;
                player.m_36176_(stack, false);
            }
            ((CommandSourceStack)commandSource.getSource()).m_81354_((Component)Component.m_237110_((String)"message.gravestone.restore.success", (Object[])new Object[]{player.m_5446_()}), true);
            return 1;
        };
        Command replace = commandSource -> {
            UUID deathID = UuidArgument.m_113853_((CommandContext)commandSource, (String)"death_id");
            ServerPlayer player = EntityArgument.m_91474_((CommandContext)commandSource, (String)"target");
            Death death = DeathManager.getDeath(player.m_9236_(), deathID);
            if (death == null) {
                ((CommandSourceStack)commandSource.getSource()).m_81352_((Component)Component.m_237110_((String)"message.gravestone.death_id_not_found", (Object[])new Object[]{deathID.toString()}));
                return 0;
            }
            player.m_150109_().m_6211_();
            NonNullList<ItemStack> itemStacks = ((GraveStoneBlock)Main.GRAVESTONE.get()).fillPlayerInventory((Player)player, death);
            for (ItemStack stack : itemStacks) {
                player.m_36176_(stack, false);
            }
            ((CommandSourceStack)commandSource.getSource()).m_81354_((Component)Component.m_237110_((String)"message.gravestone.restore.success", (Object[])new Object[]{player.m_5446_()}), true);
            return 1;
        };
        literalBuilder.then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"death_id", (ArgumentType)UuidArgument.m_113850_()).then(Commands.m_82127_((String)"replace").executes(replace))).then(Commands.m_82127_((String)"add").executes(add))));
        dispatcher.register(literalBuilder);
    }
}

