/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;

public class LanguageHelper {
    private static final Map<TranslationKey, String> preprocessed = new HashMap<TranslationKey, String>();
    private static final Map<String, String> globals = new HashMap<String, String>();

    private LanguageHelper() {
    }

    public static String getLocalization(String key, Object ... parameters) {
        Object localization = String.format(Language.m_128107_().m_6834_(key), parameters);
        TranslationKey translationKey = new TranslationKey(key, parameters);
        if (preprocessed.containsKey(translationKey)) {
            return preprocessed.get(translationKey);
        }
        if (((String)localization).contains("{{!")) {
            while (((String)localization).contains("{{!")) {
                int startingIndex = ((String)localization).indexOf("{{!");
                int endingIndex = ((String)localization).indexOf("}}", startingIndex);
                String fragment = ((String)localization).substring(startingIndex + 3, endingIndex);
                try {
                    String replacement = globals.get(fragment.toLowerCase());
                    localization = ((String)localization).substring(0, startingIndex) + replacement + ((String)localization).substring(endingIndex + 2);
                }
                catch (Exception e) {
                    localization = ((String)localization).substring(0, startingIndex) + ((String)localization).substring(endingIndex + 2);
                }
            }
            preprocessed.put(translationKey, (String)localization);
        }
        return localization;
    }

    public static void formatTooltip(String langName, List<Component> list) {
        LanguageHelper.formatTooltip(langName, Map.of(), list);
    }

    public static void formatTooltip(String langName, @Nullable Map<String, String> toFormat, List<Component> list) {
        String langTooltip = LanguageHelper.getLocalization(langName, new Object[0]);
        if (langTooltip.equals(langName)) {
            return;
        }
        if (toFormat != null) {
            for (Map.Entry entry : toFormat.entrySet()) {
                langTooltip = langTooltip.replace("{{" + (String)entry.getKey() + "}}", (CharSequence)entry.getValue());
            }
        }
        for (String descriptionLine : langTooltip.split(";")) {
            if (descriptionLine == null || descriptionLine.length() <= 0) continue;
            list.add((Component)Component.m_237113_((String)descriptionLine));
        }
    }

    public static boolean localizationExists(String langName) {
        return Language.m_128107_().m_6722_(langName);
    }

    static {
        globals.put("colors.black", "\u00a70");
        globals.put("colors.navy", "\u00a71");
        globals.put("colors.green", "\u00a72");
        globals.put("colors.blue", "\u00a73");
        globals.put("colors.red", "\u00a74");
        globals.put("colors.purple", "\u00a75");
        globals.put("colors.gold", "\u00a76");
        globals.put("colors.light_gray", "\u00a77");
        globals.put("colors.gray", "\u00a78");
        globals.put("colors.dark_purple", "\u00a79");
        globals.put("colors.light_green", "\u00a7a");
        globals.put("colors.light_blue", "\u00a7b");
        globals.put("colors.rose", "\u00a7c");
        globals.put("colors.light_purple", "\u00a7d");
        globals.put("colors.yellow", "\u00a7e");
        globals.put("colors.white", "\u00a7f");
        globals.put("colors.reset", ChatFormatting.RESET.toString());
    }

    private static class TranslationKey {
        private final String key;
        private final Object[] parameters;

        private TranslationKey(String key, Object[] parameters) {
            this.key = key;
            this.parameters = parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TranslationKey that = (TranslationKey)o;
            return this.key.equals(that.key) && Arrays.equals(this.parameters, that.parameters);
        }

        public int hashCode() {
            int result = Objects.hash(this.key);
            result = 31 * result + Arrays.hashCode(this.parameters);
            return result;
        }
    }
}

