/*
 * Decompiled with CFR 0.152.
 */
package reliquary.reference;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import reliquary.client.gui.hud.HUDPosition;
import reliquary.util.RegistryHelper;

public class Settings {
    private static final int ITEM_CAP = 9999;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    private Settings() {
    }

    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Settings.COMMON.items.infernalTear.resetCache();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final DisableSettings disable;
        public final PotionSettings potions;
        public final ItemSettings items;
        public final BlockSettings blocks;
        public final ForgeConfigSpec.BooleanValue chestLootEnabled;
        public final ForgeConfigSpec.BooleanValue dropCraftingRecipesEnabled;
        public final ForgeConfigSpec.BooleanValue mobDropsEnabled;

        Common(ForgeConfigSpec.Builder builder) {
            this.chestLootEnabled = builder.comment("Determines whether Reliquary items will be generated in chest loot (mostly mob drops, very rarely some lower level items)").worldRestart().define("chestLootEnabled", true);
            this.dropCraftingRecipesEnabled = builder.comment("Determines wheter Reliquary mob drops have crafting recipes").define("dropCraftingRecipesEnabled", false);
            this.mobDropsEnabled = builder.comment("Whether mobs drop the Reliquary mob drops. This won't remove mob drop items from registry and replace them with something else, but allows to turn off the additional drops when mobs are killed by player. If this is turned off the mob drop crafting recipes turned on by the other setting can be used.").worldRestart().define("mobDropsEnabled", true);
            this.disable = new DisableSettings(builder);
            this.potions = new PotionSettings(builder);
            this.items = new ItemSettings(builder);
            this.blocks = new BlockSettings(builder);
        }

        public static class DisableSettings {
            public final ForgeConfigSpec.BooleanValue disableAlkahestry;
            public final ForgeConfigSpec.BooleanValue disableHandgun;
            public final ForgeConfigSpec.BooleanValue disablePotions;
            public final ForgeConfigSpec.BooleanValue disablePedestal;
            public final ForgeConfigSpec.BooleanValue disablePassivePedestal;
            public final ForgeConfigSpec.BooleanValue disableSpawnEggRecipes;

            DisableSettings(ForgeConfigSpec.Builder builder) {
                builder.comment("Disable sections of the mod").push("disable");
                this.disableAlkahestry = builder.comment("Disable Alkahestry tome and its recipes").worldRestart().define("alkahestryTome", false);
                this.disableHandgun = builder.comment("Disable the HANDGUN, bullets, magazines, and gun parts").worldRestart().define("handgun", false);
                this.disablePotions = builder.comment("Disable the POTION system including mortar, altar, potions, tipped arrows, and powder").worldRestart().define("potion", false);
                this.disablePedestal = builder.comment("Disable all pedestals").worldRestart().define("pedestal", false);
                this.disablePassivePedestal = builder.comment("Disable all display-only pedestals").worldRestart().define("passivePedestal", false);
                this.disableSpawnEggRecipes = builder.comment("Disable recipes to craft spawn eggs from fragments").worldRestart().define("disableSpawnEggRecipes", false);
                builder.pop();
            }
        }

        public static class PotionSettings {
            public final ForgeConfigSpec.ConfigValue<List<String>> potionMap;
            public final ForgeConfigSpec.IntValue maxEffectCount;
            public final ForgeConfigSpec.BooleanValue threeIngredients;
            public final ForgeConfigSpec.BooleanValue differentDurations;
            public final ForgeConfigSpec.BooleanValue redstoneAndGlowstone;

            PotionSettings(ForgeConfigSpec.Builder builder) {
                builder.comment("Potions related settings").push("potions");
                this.potionMap = builder.comment("Map of POTION ingredients and their effects").define("potionMap", new ArrayList());
                this.maxEffectCount = builder.comment("Maximum number of effects a POTION can have to appear in creative tabs / JEI").defineInRange("maxEffectCount", 1, 1, 6);
                this.threeIngredients = builder.comment("Whether potions that are made out of three base ingredients appear in creative tabs / JEI").define("threeIngredients", false);
                this.differentDurations = builder.comment("Whether potions with the same effect combination, but different duration appear in creative tabs / JEI").define("differentDurations", false);
                this.redstoneAndGlowstone = builder.comment("Whether potions augmented with Redstone and Glowstone appear in creative tabs / JEI").define("redstoneAndGlowstone", false);
                builder.pop();
            }
        }

        public static class ItemSettings {
            public final AlkahestryTomeSettings alkahestryTome;
            public final MobCharmFragmentSettings mobCharmFragment;
            public final AngelicFeatherSettings angelicFeather;
            public final AngelHeartVialSettings angelHeartVial;
            public final DestructionCatalystSettings destructionCatalyst;
            public final EmperorChaliceSettings emperorChalice;
            public final EnderStaffSettings enderStaff;
            public final FortuneCoinSettings fortuneCoin;
            public final GlacialStaffSettings glacialStaff;
            public final HandgunSettings handgun;
            public final HarvestRodSettings harvestRod;
            public final HeroMedallionSettings heroMedallion;
            public final IceMagusRodSettings iceMagusRod;
            public final InfernalChaliceSettings infernalChalice;
            public final InfernalClawsSettings infernalClaws;
            public final InfernalTearSettings infernalTear;
            public final KrakenShellSettings krakenShell;
            public final LanternOfParanoiaSettings lanternOfParanoia;
            public final MidasTouchstoneSettings midasTouchstone;
            public final MobCharmSettings mobCharm;
            public final PhoenixDownSettings phoenixDown;
            public final PyromancerStaffSettings pyromancerStaff;
            public final RendingGaleSettings rendingGale;
            public final RodOfLyssaSettings rodOfLyssa;
            public final SeekerShotSettings seekerShot;
            public final SojournerStaffSettings sojournerStaff;
            public final TwilightCloakSettings twilightCloak;
            public final VoidTearSettings voidTear;

            ItemSettings(ForgeConfigSpec.Builder builder) {
                builder.push("items");
                this.alkahestryTome = new AlkahestryTomeSettings(builder);
                this.angelicFeather = new AngelicFeatherSettings(builder);
                this.angelHeartVial = new AngelHeartVialSettings(builder);
                this.destructionCatalyst = new DestructionCatalystSettings(builder);
                this.emperorChalice = new EmperorChaliceSettings(builder);
                this.enderStaff = new EnderStaffSettings(builder);
                this.fortuneCoin = new FortuneCoinSettings(builder);
                this.glacialStaff = new GlacialStaffSettings(builder);
                this.handgun = new HandgunSettings(builder);
                this.harvestRod = new HarvestRodSettings(builder);
                this.heroMedallion = new HeroMedallionSettings(builder);
                this.iceMagusRod = new IceMagusRodSettings(builder);
                this.infernalChalice = new InfernalChaliceSettings(builder);
                this.infernalClaws = new InfernalClawsSettings(builder);
                this.infernalTear = new InfernalTearSettings(builder);
                this.krakenShell = new KrakenShellSettings(builder);
                this.lanternOfParanoia = new LanternOfParanoiaSettings(builder);
                this.midasTouchstone = new MidasTouchstoneSettings(builder);
                this.mobCharm = new MobCharmSettings(builder);
                this.mobCharmFragment = new MobCharmFragmentSettings(builder);
                this.phoenixDown = new PhoenixDownSettings(builder);
                this.pyromancerStaff = new PyromancerStaffSettings(builder);
                this.rendingGale = new RendingGaleSettings(builder);
                this.rodOfLyssa = new RodOfLyssaSettings(builder);
                this.seekerShot = new SeekerShotSettings(builder);
                this.sojournerStaff = new SojournerStaffSettings(builder);
                this.twilightCloak = new TwilightCloakSettings(builder);
                this.voidTear = new VoidTearSettings(builder);
                builder.pop();
            }

            public static class AlkahestryTomeSettings {
                public final ForgeConfigSpec.IntValue chargeLimit;

                AlkahestryTomeSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Alkahestry Tome settings").push("alkahestryTome");
                    this.chargeLimit = builder.comment("Charge limit of the tome").defineInRange("chargeLimit", 1000, 0, 9999);
                    builder.pop();
                }
            }

            public static class AngelicFeatherSettings {
                public final ForgeConfigSpec.IntValue hungerCostPercent;
                public final ForgeConfigSpec.IntValue leapingPotency;

                AngelicFeatherSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Angelic Feather settings").push("angelicFeather");
                    this.hungerCostPercent = builder.comment("Percent hunger used to heal player per 1 damage that would be taken otherwise.").defineInRange("hungerCostPercent", 50, 0, 100);
                    this.leapingPotency = builder.comment("Potency of the leaping effect").defineInRange("leapingPotency", 1, 0, 5);
                    builder.pop();
                }
            }

            public static class AngelHeartVialSettings {
                public final ForgeConfigSpec.IntValue healPercentageOfMaxLife;
                public final ForgeConfigSpec.BooleanValue removeNegativeStatus;

                AngelHeartVialSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Angelheart Vial settings").push("angelheartVial");
                    this.healPercentageOfMaxLife = builder.comment("Percent of life that gets healed when the player would die").defineInRange("healPercentageOfMaxLife", 25, 0, 100);
                    this.removeNegativeStatus = builder.comment("Whether the player gets negative statuses removed").define("removeNegativeStatus", true);
                    builder.pop();
                }
            }

            public static class DestructionCatalystSettings {
                public final ForgeConfigSpec.ConfigValue<List<String>> mundaneBlocks;
                public final ForgeConfigSpec.IntValue gunpowderCost;
                public final ForgeConfigSpec.IntValue gunpowderWorth;
                public final ForgeConfigSpec.IntValue gunpowderLimit;
                public final ForgeConfigSpec.IntValue explosionRadius;
                public final ForgeConfigSpec.BooleanValue centeredExplosion;
                public final ForgeConfigSpec.BooleanValue perfectCube;

                DestructionCatalystSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Destruction Catalyst settings").push("destructionCatalyst");
                    this.mundaneBlocks = builder.comment("List of mundane blocks the catalyst will break").define("mundaneBlocks", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:dirt", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:mycelium", "minecraft:grass_block", "minecraft:gravel", "minecraft:cobblestone", "minecraft:stone", "minecraft:granite", "minecraft:diorite", "minecraft:andesite", "minecraft:sand", "minecraft:sandstone", "minecraft:snow", "minecraft:soul_sand", "minecraft:netherrack", "minecraft:end_stone"}));
                    this.gunpowderCost = builder.comment("Number of gunpowder it costs per catalyst use").defineInRange("gunpowderCost", 3, 0, 10);
                    this.gunpowderWorth = builder.comment("Number of gunpowder that gets added to catalyst per one that's consumed from players inventory").defineInRange("gunpowderWorth", 1, 1, 3);
                    this.gunpowderLimit = builder.comment("Number of gunpowder that can be stored in destruction catalyst").defineInRange("gunpowderLimit", 250, 0, 9999);
                    this.explosionRadius = builder.comment("Radius of the explosion").defineInRange("explosionRadius", 1, 1, 5);
                    this.centeredExplosion = builder.comment("Whether the explosion is centered on the block that gets clicked").define("centeredExplosion", false);
                    this.perfectCube = builder.comment("Whether the explosion makes a perfect cube hole").define("perfectCube", true);
                    builder.pop();
                }
            }

            public static class EmperorChaliceSettings {
                public final ForgeConfigSpec.IntValue hungerSatiationMultiplier;

                EmperorChaliceSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Emperor Chalice settings").push("emperorChalice");
                    this.hungerSatiationMultiplier = builder.comment("How much saturation is added in addition to filling the hunger").defineInRange("hungerSatiationMultiplier", 4, 0, 10);
                    builder.pop();
                }
            }

            public static class EnderStaffSettings {
                public final ForgeConfigSpec.IntValue enderPearlCastCost;
                public final ForgeConfigSpec.IntValue enderPearlNodeWarpCost;
                public final ForgeConfigSpec.IntValue enderPearlWorth;
                public final ForgeConfigSpec.IntValue enderPearlLimit;
                public final ForgeConfigSpec.IntValue nodeWarpCastTime;

                EnderStaffSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Ender Staff settings").push("enderStaff");
                    this.enderPearlCastCost = builder.comment("Number of ender pearls per use").defineInRange("enderPearlCastCost", 1, 0, 3);
                    this.enderPearlNodeWarpCost = builder.comment("Number of ender pearls per teleportation to the wraith node").defineInRange("enderPearlNodeWarpCost", 1, 0, 3);
                    this.enderPearlWorth = builder.comment("Number of ender pearls that get added to the staff per one that's consumed from players inventory").defineInRange("enderPearlWorth", 1, 1, 10);
                    this.enderPearlLimit = builder.comment("Number of ender pearls that the ender staff can store").defineInRange("enderPearlLimit", 250, 0, 9999);
                    this.nodeWarpCastTime = builder.comment("Time it takes to teleport to the wraith node").defineInRange("nodeWarpCastTime", 60, 10, 120);
                    builder.pop();
                }
            }

            public static class FortuneCoinSettings {
                public final ForgeConfigSpec.IntValue standardPullDistance;
                public final ForgeConfigSpec.IntValue longRangePullDistance;

                FortuneCoinSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Fortune Coin settings").push("fortuneCoin");
                    this.standardPullDistance = builder.comment("The distance that it pulls from when activated").defineInRange("standardPullDistance", 5, 3, 10);
                    this.longRangePullDistance = builder.comment("The distance that it pulls from when right click is held").defineInRange("longRangePullDistance", 15, 9, 30);
                    builder.pop();
                }
            }

            public static class GlacialStaffSettings {
                public final ForgeConfigSpec.IntValue snowballLimit;
                public final ForgeConfigSpec.IntValue snowballCost;
                public final ForgeConfigSpec.IntValue snowballWorth;
                public final ForgeConfigSpec.IntValue snowballDamage;
                public final ForgeConfigSpec.IntValue snowballDamageBonusFireImmune;
                public final ForgeConfigSpec.IntValue snowballDamageBonusBlaze;

                GlacialStaffSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Glacial Staff settings").push("glacialStaff");
                    this.snowballLimit = builder.comment("Number of snowballs the staff can hold").defineInRange("snowballLimit", 250, 0, 9999);
                    this.snowballCost = builder.comment("Number of snowballs it costs when the staff is used").defineInRange("snowballCost", 1, 0, 3);
                    this.snowballWorth = builder.comment("Number of snowballs that get added to the staff per one that's consumed from player's inventory").defineInRange("snowballWorth", 1, 1, 3);
                    this.snowballDamage = builder.comment("The damage that snowballs cause").defineInRange("snowballDamage", 3, 0, 6);
                    this.snowballDamageBonusFireImmune = builder.comment("The damage bonus against entities that are immune to fire").defineInRange("snowballDamageBonusFireImmune", 3, 0, 6);
                    this.snowballDamageBonusBlaze = builder.comment("The damage bonus against blaze").defineInRange("snowballDamageBonusBlaze", 6, 0, 12);
                    builder.pop();
                }
            }

            public static class HandgunSettings {
                public final ForgeConfigSpec.IntValue maxSkillLevel;

                public HandgunSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Handgun settings").push("handgun");
                    this.maxSkillLevel = builder.comment("Experience level at which handgun has the fastest reload time and shortes cooldown between shots").defineInRange("maxSkillLevel", 20, 0, 100);
                    builder.pop();
                }
            }

            public static class HarvestRodSettings {
                public final ForgeConfigSpec.IntValue boneMealLimit;
                public final ForgeConfigSpec.IntValue boneMealCost;
                public final ForgeConfigSpec.IntValue boneMealWorth;
                public final ForgeConfigSpec.IntValue boneMealLuckPercentChance;
                public final ForgeConfigSpec.IntValue boneMealLuckRolls;
                public final ForgeConfigSpec.IntValue aoeRadius;
                public final ForgeConfigSpec.IntValue aoeCooldown;
                public final ForgeConfigSpec.IntValue maxCapacityPerPlantable;
                public final ForgeConfigSpec.IntValue pedestalRange;
                public final ForgeConfigSpec.IntValue pedestalCooldown;

                HarvestRodSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Harvest Rod settings").push("harvestRod");
                    this.boneMealLimit = builder.comment("Number of bonemeal the rod can hold").defineInRange("boneMealLimit", 250, 0, 9999);
                    this.boneMealCost = builder.comment("Number of bonemeal consumed per use").defineInRange("boneMealCost", 1, 0, 3);
                    this.boneMealWorth = builder.comment("Number of bonemeal that gets added to the rod per one that's consumed from player's inventory").defineInRange("boneMealWorth", 1, 1, 3);
                    this.boneMealLuckPercentChance = builder.comment("Percent chance that a bonemeal will get applied during a luck roll").defineInRange("boneMealLuckPercentChance", 33, 1, 100);
                    this.boneMealLuckRolls = builder.comment("Number of times that a rod may apply additional luck based bonemeal").defineInRange("boneMealLuckRolls", 2, 0, 7);
                    this.aoeRadius = builder.comment("Radius in which harvest rod breaks crops, bonemeals/plants/hoes blocks").defineInRange("aoeRadius", 2, 0, 5);
                    this.aoeCooldown = builder.comment("Ticks in between bonemealing/planting/hoeing blocks when player is using one of these AOE actions").defineInRange("aoeCooldown", 3, 1, 20);
                    this.maxCapacityPerPlantable = builder.comment("Maximum number of units harvest rod can hold per plantable item").defineInRange("maxCapacityPerPlantable", 250, 0, 9999);
                    this.pedestalRange = builder.comment("Range at which harvest rod will automatically hoe/plant/bonemeal/break crops around pedestals").defineInRange("pedestalRange", 4, 1, 20);
                    this.pedestalCooldown = builder.comment("Ticks in between harvest rod actions when in pedestals").defineInRange("pedestalCooldown", 5, 1, 20);
                    builder.pop();
                }
            }

            public static class HeroMedallionSettings {
                public final ForgeConfigSpec.IntValue pedestalCoolDown;
                public final ForgeConfigSpec.IntValue pedestalRange;
                public final ForgeConfigSpec.IntValue pedestalRepairStepXP;

                HeroMedallionSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Hero Medallion settings").push("heroMedallion");
                    this.pedestalCoolDown = builder.comment("Cooldown between hero medallion tries to fix mending items in nearby pedestals").defineInRange("pedestalCoolDown", 20, 1, 100);
                    this.pedestalRange = builder.comment("Range in which pedestals are checked for items with mending enchant that need fixing").defineInRange("pedestalRange", 5, 1, 20);
                    this.pedestalRepairStepXP = builder.comment("Maximum amount of xp that is used each time medallion repairs items").defineInRange("pedestalRepairStepXP", 5, 1, 20);
                    builder.pop();
                }
            }

            public static class IceMagusRodSettings {
                public final ForgeConfigSpec.IntValue snowballLimit;
                public final ForgeConfigSpec.IntValue snowballCost;
                public final ForgeConfigSpec.IntValue snowballWorth;
                public final ForgeConfigSpec.IntValue snowballDamage;
                public final ForgeConfigSpec.IntValue snowballDamageBonusFireImmune;
                public final ForgeConfigSpec.IntValue snowballDamageBonusBlaze;

                IceMagusRodSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Ice Magus Rod settings").push("iceMagusRod");
                    this.snowballLimit = builder.comment("Number of snowballs the rod can hold").defineInRange("snowballLimit", 250, 0, 9999);
                    this.snowballCost = builder.comment("Number of snowballs it costs when the rod is used").defineInRange("snowballCost", 1, 0, 3);
                    this.snowballWorth = builder.comment("Number of snowballs that get added to the rod per one that's consumed from player's inventory").defineInRange("snowballWorth", 1, 1, 3);
                    this.snowballDamage = builder.comment("The damage that snowballs cause").defineInRange("snowballDamage", 2, 0, 4);
                    this.snowballDamageBonusFireImmune = builder.comment("Damage bonus against fire immune mobs").defineInRange("snowballDamageBonusFireImmune", 2, 0, 4);
                    this.snowballDamageBonusBlaze = builder.comment("Damage bonus against blaze").defineInRange("snowballDamageBonusBlaze", 4, 0, 8);
                    builder.pop();
                }
            }

            public static class InfernalChaliceSettings {
                public final ForgeConfigSpec.IntValue hungerCostPercent;
                public final ForgeConfigSpec.IntValue fluidLimit;

                InfernalChaliceSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Infernal Chalice settings").push("infernalChalice");
                    this.hungerCostPercent = builder.comment("Percent hunger used to heal player per 1 damage that would be taken otherwise.").defineInRange("hungerCostPercent", 1, 0, 10);
                    this.fluidLimit = builder.comment("Millibuckets of lava that the chalice can hold").defineInRange("fluidLimit", 500000, 0, Integer.MAX_VALUE);
                    builder.pop();
                }
            }

            public static class InfernalClawsSettings {
                public final ForgeConfigSpec.IntValue hungerCostPercent;

                InfernalClawsSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Infernal Claws settings").push("infernalClaws");
                    this.hungerCostPercent = builder.comment("Percent hunger used to heal player per 1 damage that would be taken otherwise.").defineInRange("hungerCostPercent", 5, 0, 30);
                    builder.pop();
                }
            }

            public static class InfernalTearSettings {
                private static final String ITEM_EXPERIENCE_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)\\|\\d+";
                public final ForgeConfigSpec.BooleanValue absorbWhenCreated;
                public final ForgeConfigSpec.ConfigValue<List<? extends String>> itemExperienceList;
                @Nullable
                private Map<String, Integer> itemExperience = null;

                InfernalTearSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Infernal Tear settings").push("infernalTear");
                    this.absorbWhenCreated = builder.comment("Whether the infernal tear starts absorbing immediately after it is set to item type").define("absorbWhenCreated", false);
                    this.itemExperienceList = builder.comment("List of items that can be consumed by infernal tear with their experience point value").defineList("entityLootTableList", this::getDefaultInfernalTearMappings, mapping -> ((String)mapping).matches(ITEM_EXPERIENCE_MATCHER));
                    builder.pop();
                }

                private List<String> getDefaultInfernalTearMappings() {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("minecraft:emerald|63");
                    ret.add("minecraft:sandstone|1");
                    ret.add("minecraft:gravel|1");
                    ret.add("minecraft:diamond|125");
                    ret.add("minecraft:gunpowder|8");
                    ret.add("minecraft:nether_star|500");
                    ret.add("minecraft:iron_ingot|63");
                    ret.add("minecraft:charcoal|2");
                    ret.add("minecraft:soul_sand|2");
                    ret.add("minecraft:lapis_lazuli|8");
                    ret.add("minecraft:obsidian|4");
                    ret.add("minecraft:end_stone|1");
                    ret.add("minecraft:gold_ingot|63");
                    ret.add("minecraft:netherrack|1");
                    ret.add("minecraft:flint|2");
                    ret.add("minecraft:clay|4");
                    ret.add("minecraft:chorus_fruit|2");
                    ret.add("minecraft:quartz|16");
                    ret.add("minecraft:honeycomb|4");
                    ret.add("minecraft:netherite_scrap|250");
                    return ret;
                }

                public Optional<Integer> getItemExperience(String itemRegistryName) {
                    return Optional.ofNullable(this.getItemExperiences().get(itemRegistryName));
                }

                public Map<String, Integer> getItemExperiences() {
                    if (this.itemExperience == null) {
                        this.itemExperience = new HashMap<String, Integer>();
                        for (String itemAndExperience : (List)this.itemExperienceList.get()) {
                            String[] split = itemAndExperience.split("\\|");
                            this.itemExperience.put(split[0], Integer.valueOf(split[1]));
                        }
                    }
                    return this.itemExperience;
                }

                public void resetCache() {
                    this.itemExperience = null;
                }
            }

            public static class KrakenShellSettings {
                public final ForgeConfigSpec.IntValue hungerCostPercent;

                KrakenShellSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Kraken Shell settings").push("krakenShell");
                    this.hungerCostPercent = builder.comment("Percent hunger used to heal player per 1 damage that would be taken otherwise.").defineInRange("hungerCostPercent", 25, 0, 50);
                    builder.pop();
                }
            }

            public static class LanternOfParanoiaSettings {
                public final ForgeConfigSpec.ConfigValue<List<String>> torches;
                public final ForgeConfigSpec.IntValue minLightLevel;
                public final ForgeConfigSpec.IntValue placementScanRadius;

                LanternOfParanoiaSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Lantern of Paranoia settings").push("lanternOfParanoia");
                    this.torches = builder.comment("List of torches that are supported by the lantern").define("torches", (Object)Lists.newArrayList((Object[])new String[]{RegistryHelper.getItemRegistryName(Items.f_42000_)}));
                    this.minLightLevel = builder.comment("Minimum light level below which the lantern will place torches").defineInRange("minLightLevel", 1, 0, 15);
                    this.placementScanRadius = builder.comment("Radius in which the lantern checks for light levels and places torches").defineInRange("placementScanRadius", 6, 1, 15);
                    builder.pop();
                }
            }

            public static class MidasTouchstoneSettings {
                public final ForgeConfigSpec.ConfigValue<List<String>> goldItems;
                public final ForgeConfigSpec.IntValue glowstoneCost;
                public final ForgeConfigSpec.IntValue glowstoneWorth;
                public final ForgeConfigSpec.IntValue glowstoneLimit;

                MidasTouchstoneSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Midas Touchstone settings").push("midasTouchstone");
                    this.goldItems = builder.comment("Gold items that can be repaired by the touchstone").define("goldItems", new ArrayList());
                    this.glowstoneCost = builder.comment("Number of glowstone that the repair costs").defineInRange("glowstoneCost", 1, 0, 3);
                    this.glowstoneWorth = builder.comment("Number of glowstone that gets added to the touchstone per one in player's inventory").defineInRange("glowstoneWorth", 4, 1, 12);
                    this.glowstoneLimit = builder.comment("Number of glowstone the touchstone can hold").defineInRange("glowstoneLimit", 250, 0, 9999);
                    builder.pop();
                }
            }

            public static class MobCharmSettings {
                private static final String REGISTRY_NAME_MATCHER = "([a-z1-9_.-]+:[a-z1-9_/.-]+)";
                public final ForgeConfigSpec.IntValue durability;
                public final ForgeConfigSpec.IntValue damagePerKill;
                public final ForgeConfigSpec.IntValue dropDurabilityRepair;
                public final ForgeConfigSpec.IntValue maxCharmsToDisplay;
                public final ForgeConfigSpec.IntValue pedestalRange;
                public final ForgeConfigSpec.BooleanValue keepAlmostDestroyedDisplayed;
                public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlockList;

                MobCharmSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Mob Charm settings").push("mobCharm");
                    this.durability = builder.comment("Total durability of Mob Charm").defineInRange("durability", 80, 20, 1000);
                    this.damagePerKill = builder.comment("Damage that Mob Charm takes when player kills mob it protects them from").defineInRange("damagePerKill", 1, 0, 40);
                    this.dropDurabilityRepair = builder.comment("Sets how much durability of Mob Charm gets repaired per special drop").defineInRange("dropDurabilityRepair", 20, 1, 200);
                    this.maxCharmsToDisplay = builder.comment("Maximum charms that will get displayed in HUD").defineInRange("maxCharmsToDisplay", 6, 1, 20);
                    this.pedestalRange = builder.comment("Range in which mob charm or belt in pedestals will keep monsters from attacking players").defineInRange("pedestalRange", 21, 10, 100);
                    this.keepAlmostDestroyedDisplayed = builder.comment("Determines if almost destroyed charms stay displayed in the hud").define("keepAlmostDestroyedDisplayed", true);
                    this.entityBlockList = builder.comment("List of hostile entities that are not supposed to have mob charms registered for them").defineList("entityBlockList", this::getDefaultEntityBlockList, entityName -> ((String)entityName).matches(REGISTRY_NAME_MATCHER));
                    builder.pop();
                }

                private List<String> getDefaultEntityBlockList() {
                    ArrayList<String> ret = new ArrayList<String>();
                    ret.add("minecraft:ender_dragon");
                    ret.add("minecraft:wither");
                    return ret;
                }
            }

            public static class MobCharmFragmentSettings {
                public final ForgeConfigSpec.DoubleValue dropChance;
                public final ForgeConfigSpec.DoubleValue lootingMultiplier;

                MobCharmFragmentSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Mob Charm Fragment Settings").push("mobCharmFragment");
                    this.dropChance = builder.comment("Chance of fragment droping from mobs that don't have fragment that can be crafted").defineInRange("dropChance", 0.01666666753590107, 0.0, 1.0);
                    this.lootingMultiplier = builder.comment("Additional chance per level of looting").defineInRange("lootingMultiplier", 0.008333333767950535, 0.0, 1.0);
                    builder.pop();
                }
            }

            public static class PhoenixDownSettings {
                public final ForgeConfigSpec.IntValue hungerCostPercent;
                public final ForgeConfigSpec.IntValue leapingPotency;
                public final ForgeConfigSpec.IntValue healPercentageOfMaxLife;
                public final ForgeConfigSpec.BooleanValue removeNegativeStatus;
                public final ForgeConfigSpec.BooleanValue giveTemporaryDamageResistance;
                public final ForgeConfigSpec.BooleanValue giveTemporaryRegeneration;
                public final ForgeConfigSpec.BooleanValue giveTemporaryFireResistanceIfFireDamageKilledYou;
                public final ForgeConfigSpec.BooleanValue giveTemporaryWaterBreathingIfDrowningKilledYou;

                PhoenixDownSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Phoenix Down settings").push("PhoenixDown");
                    this.hungerCostPercent = builder.comment("Percent hunger used to heal player per 1 damage that would be taken otherwise").defineInRange("hungerCostPercent", 25, 0, 50);
                    this.leapingPotency = builder.comment("Potency of the leaping effect").defineInRange("leapingPotency", 1, 0, 5);
                    this.healPercentageOfMaxLife = builder.comment("Percent of life that gets healed when the player would die").defineInRange("healPercentageOfMaxLife", 100, 0, 100);
                    this.removeNegativeStatus = builder.comment("Whether the player gets negative statuses removed when they were saved by Phoenix Down").define("removeNegativeStatus", true);
                    this.giveTemporaryDamageResistance = builder.comment("Whether to give temporary damage resistance when the player would die").define("giveTemporaryDamageResistance", true);
                    this.giveTemporaryRegeneration = builder.comment("Whether to give temporary regeneration when the player would die").define("giveTemporaryRegeneration", true);
                    this.giveTemporaryFireResistanceIfFireDamageKilledYou = builder.comment("Whether to give temporary fire resistance when the player would die. Applies only when the player is being hurt by fire damage.").define("giveTemporaryFireResistanceIfFireDamageKilledYou", true);
                    this.giveTemporaryWaterBreathingIfDrowningKilledYou = builder.comment("Whether to give temporary damage resistance when the player would die. Applies only when the player is drowning.").define("giveTemporaryWaterBreathingIfDrowningKilledYou", true);
                    builder.pop();
                }
            }

            public static class PyromancerStaffSettings {
                public final ForgeConfigSpec.IntValue fireChargeLimit;
                public final ForgeConfigSpec.IntValue fireChargeCost;
                public final ForgeConfigSpec.IntValue fireChargeWorth;
                public final ForgeConfigSpec.IntValue ghastAbsorbWorth;
                public final ForgeConfigSpec.IntValue blazePowderLimit;
                public final ForgeConfigSpec.IntValue blazePowderCost;
                public final ForgeConfigSpec.IntValue blazePowderWorth;
                public final ForgeConfigSpec.IntValue blazeAbsorbWorth;

                PyromancerStaffSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Pyromancer Staff settings").push("pyromancerStaff");
                    this.fireChargeLimit = builder.comment("Number of fire charges the staff can hold").defineInRange("fireChargeLimit", 250, 0, 9999);
                    this.fireChargeCost = builder.comment("Number of fire charges used when the staff is fired").defineInRange("fireChargeCost", 1, 0, 3);
                    this.fireChargeWorth = builder.comment("Number of fire charges that get added to the staff per one that's consumed from player's inventory").defineInRange("fireChargeWorth", 1, 1, 3);
                    this.ghastAbsorbWorth = builder.comment("Number of fire charges added to the staff per one that was shot by ghast and gets absorbed by the staff").defineInRange("ghastAbsorbWorth", 1, 0, 3);
                    this.blazePowderLimit = builder.comment("Number of blaze powder the staff can hold").defineInRange("blazePowderLimit", 250, 0, 9999);
                    this.blazePowderCost = builder.comment("Number of blaze powder used when staff is fired").defineInRange("blazePowderCost", 1, 0, 3);
                    this.blazePowderWorth = builder.comment("Number of blaze powder that gets added to the staff per one that's consumed from player's inventory").defineInRange("blazePowderWorth", 1, 1, 3);
                    this.blazeAbsorbWorth = builder.comment("Number of blaze powder added to the staff per one fireball that was shot by blaze and gets absorbed by the staff").defineInRange("blazeAbsorbWorth", 1, 0, 3);
                    builder.pop();
                }
            }

            public static class RendingGaleSettings {
                public final ForgeConfigSpec.IntValue chargeLimit;
                public final ForgeConfigSpec.IntValue castChargeCost;
                public final ForgeConfigSpec.IntValue boltChargeCost;
                public final ForgeConfigSpec.IntValue chargeFeatherWorth;
                public final ForgeConfigSpec.IntValue blockTargetRange;
                public final ForgeConfigSpec.IntValue pushPullRadius;
                public final ForgeConfigSpec.BooleanValue canPushProjectiles;
                public final ForgeConfigSpec.IntValue pedestalFlightRange;
                public final ForgeConfigSpec.IntValue pedestalCostPerSecond;
                public final ForgeConfigSpec.ConfigValue<List<String>> pushableEntitiesBlacklist;
                public final ForgeConfigSpec.ConfigValue<List<String>> pushableProjectilesBlacklist;

                RendingGaleSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Rending Gale settings").push("rendingGale");
                    this.chargeLimit = builder.comment("Number of feathers the rending gale can hold").defineInRange("chargeLimit", 30000, 0, Integer.MAX_VALUE);
                    this.castChargeCost = builder.comment("Number of feathers used when the rending gale is cast in flight mode").defineInRange("castChargeCost", 1, 0, 3);
                    this.boltChargeCost = builder.comment("Number of feathers used to cast a lightning bolt").defineInRange("boltChargeCost", 100, 0, 250);
                    this.chargeFeatherWorth = builder.comment("Number of feathers that get added to the rending gale per one that's consumed from player's inventory").defineInRange("chargeFeatherWorth", 100, 1, 250);
                    this.blockTargetRange = builder.comment("How far a lightning block can be cast").defineInRange("blockTargetRange", 12, 5, 15);
                    this.pushPullRadius = builder.comment("Radius in which entities can be pushed/pulled").defineInRange("pushPullRadius", 10, 1, 20);
                    this.canPushProjectiles = builder.comment("Whether the rending gale can push projectiles").define("canPushProjectiles", true);
                    this.pedestalFlightRange = builder.comment("Range from pedestals at which players will get buffed with flight").defineInRange("pedestalFlightRange", 30, 10, 100);
                    this.pedestalCostPerSecond = builder.comment("Cost per second of buffing players with flight").defineInRange("pedestalCostPerSecond", 5, 1, 20);
                    this.pushableEntitiesBlacklist = builder.comment("List of entities that are banned from being pushed by the Rending Gale").define("pushableEntitiesBlacklist", new ArrayList());
                    this.pushableProjectilesBlacklist = builder.comment("List of projectiles that are banned from being pushed by the Rending Gale").define("pushableProjectilesBlacklist", new ArrayList());
                    builder.pop();
                }
            }

            public static class RodOfLyssaSettings {
                public final ForgeConfigSpec.BooleanValue useLeveledFailureRate;
                public final ForgeConfigSpec.IntValue levelCapForLeveledFormula;
                public final ForgeConfigSpec.IntValue flatStealFailurePercentRate;
                public final ForgeConfigSpec.BooleanValue stealFromVacantSlots;
                public final ForgeConfigSpec.BooleanValue failStealFromVacantSlots;
                public final ForgeConfigSpec.BooleanValue angerOnStealFailure;
                public final ForgeConfigSpec.BooleanValue stealFromPlayers;
                private static final String ENTITY_NAME_MATCHER = "[a-z1-9_.-]+:[a-z1-9_/.-]+";
                public final ForgeConfigSpec.ConfigValue<List<? extends String>> entityBlockList;
                @Nullable
                private Set<EntityType<?>> blockedEntities = null;

                RodOfLyssaSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Rod of Lyssa settings").push("rodOfLyssa");
                    this.useLeveledFailureRate = builder.comment("Whether level influences stealing failure rate of the rod").define("useLeveledFailureRate", true);
                    this.levelCapForLeveledFormula = builder.comment("The experience level cap after which the failure rate is at a minimum and doesn't get better").defineInRange("levelCapForLeveledFormula", 100, 1, 900);
                    this.flatStealFailurePercentRate = builder.comment("The flat failure rate in case failure rate isn't influenced by player's level").defineInRange("flatStealFailurePercentRate", 10, 0, 100);
                    this.stealFromVacantSlots = builder.comment("If set to false it goes through additional 4 accessible slots and looks for items in case the one selected randomly was empty").define("stealFromVacantSlots", true);
                    this.failStealFromVacantSlots = builder.comment("Whether stealing from an empty slot triggers failure even if otherwise it would be successful").define("failStealFromVacantSlots", false);
                    this.angerOnStealFailure = builder.comment("Whether entities get angry at player if stealing fails").define("angerOnStealFailure", true);
                    this.stealFromPlayers = builder.comment("Allows switching stealing from player on and off").define("stealFromPlayers", true);
                    this.entityBlockList = builder.comment("List of entities on which lyssa rod doesn't work - full registry name is required here").defineList("entityBlockList", new ArrayList(), mapping -> ((String)mapping).matches(ENTITY_NAME_MATCHER));
                    builder.pop();
                }

                public boolean canStealFromEntity(Entity entity) {
                    if (this.blockedEntities == null) {
                        this.initBlockedEntityTypes();
                    }
                    return !this.blockedEntities.contains(entity.m_6095_());
                }

                private void initBlockedEntityTypes() {
                    this.blockedEntities = new HashSet();
                    for (String entityName : (List)this.entityBlockList.get()) {
                        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(entityName));
                        if (entityType == null) continue;
                        this.blockedEntities.add(entityType);
                    }
                }
            }

            public static class SeekerShotSettings {
                public final ForgeConfigSpec.ConfigValue<List<String>> huntableEntitiesBlacklist;

                SeekerShotSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Seeker Shot settings").push("seekerShot");
                    this.huntableEntitiesBlacklist = builder.comment("Entities that are banned from being tracked by seeker shot").define("huntableEntitiesBlacklist", new ArrayList());
                    builder.pop();
                }
            }

            public static class SojournerStaffSettings {
                public final ForgeConfigSpec.ConfigValue<List<String>> torches;
                public final ForgeConfigSpec.IntValue maxCapacityPerItemType;
                public final ForgeConfigSpec.IntValue maxRange;
                public final ForgeConfigSpec.IntValue tilePerCostMultiplier;

                SojournerStaffSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Sojourner Staff settings").push("sojournerStaff");
                    this.torches = builder.comment("List of torches that are supported by the staff").define("torches", this.getDefaultTorches());
                    this.maxCapacityPerItemType = builder.comment("Number of items the staff can store per item type").defineInRange("maxCapacityPerItemType", 1500, 1, 9999);
                    this.maxRange = builder.comment("Maximum range at which torches can be placed").defineInRange("maxRange", 30, 1, 30);
                    this.tilePerCostMultiplier = builder.comment("Distance after which there is an additional cost for torch placement. The additional cost is the number of times this distance fits in the distance at which the torch is being placed.").defineInRange("tilePerCostMultiplier", 6, 6, 30);
                    builder.pop();
                }

                private ArrayList<String> getDefaultTorches() {
                    return Lists.newArrayList((Object[])new String[]{RegistryHelper.getItemRegistryName(Items.f_42000_), RegistryHelper.getItemRegistryName(Items.f_42053_), RegistryHelper.getItemRegistryName(Items.f_42778_), RegistryHelper.getItemRegistryName(Items.f_42055_), RegistryHelper.getItemRegistryName(Items.f_42251_), RegistryHelper.getItemRegistryName(Items.f_42779_), RegistryHelper.getItemRegistryName(Items.f_42783_), RegistryHelper.getItemRegistryName(Items.f_42054_), RegistryHelper.getItemRegistryName(Items.f_42001_)});
                }
            }

            public static class TwilightCloakSettings {
                public final ForgeConfigSpec.IntValue maxLightLevel;

                TwilightCloakSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Twilight Cloak settings").push("twilightCloak");
                    this.maxLightLevel = builder.comment("Maximum light level at which the player is still invisible to the mobs").defineInRange("maxLightLevel", 4, 0, 15);
                    builder.pop();
                }
            }

            public static class VoidTearSettings {
                public final ForgeConfigSpec.IntValue itemLimit;
                public final ForgeConfigSpec.BooleanValue absorbWhenCreated;

                VoidTearSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Void Tear settings").push("voidTear");
                    this.itemLimit = builder.comment("Number of items the tear can hold of the item type it is set to").defineInRange("itemLimit", 2000000000, 0, Integer.MAX_VALUE);
                    this.absorbWhenCreated = builder.comment("Whether the void tear starts absorbing immediately after it is set to item type").define("absorbWhenCreated", true);
                    builder.pop();
                }
            }
        }

        public static class BlockSettings {
            public final AltarSettings altar;
            public final ApothecaryCauldronSettings apothecaryCauldron;
            public final FertileLilypadSettings fertileLilypad;
            public final InterdictionTorchSettings interdictionTorch;
            public final PedestalSettings pedestal;

            BlockSettings(ForgeConfigSpec.Builder builder) {
                builder.push("blocks");
                this.altar = new AltarSettings(builder);
                this.apothecaryCauldron = new ApothecaryCauldronSettings(builder);
                this.fertileLilypad = new FertileLilypadSettings(builder);
                this.interdictionTorch = new InterdictionTorchSettings(builder);
                this.pedestal = new PedestalSettings(builder);
                builder.pop();
            }

            public static class AltarSettings {
                public final ForgeConfigSpec.IntValue redstoneCost;
                public final ForgeConfigSpec.IntValue timeInMinutes;
                public final ForgeConfigSpec.IntValue maximumTimeVarianceInMinutes;
                public final ForgeConfigSpec.IntValue outputLightLevelWhileActive;

                AltarSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Altar of Light settings").push("altar");
                    this.redstoneCost = builder.comment("Number of redstone it costs to activate altar").defineInRange("redstoneCost", 3, 0, 10);
                    this.timeInMinutes = builder.comment("Time in minutes it takes for the altar to create glowstone block").defineInRange("timeInMinutes", 20, 0, 60);
                    this.maximumTimeVarianceInMinutes = builder.comment("Maximum time variance in minutes. A random part of it gets added to the Time in minutes.").defineInRange("maximumTimeVarianceInMinutes", 5, 0, 15);
                    this.outputLightLevelWhileActive = builder.comment("Light level that the altar outputs while active").defineInRange("outputLightLevelWhileActive", 16, 0, 16);
                    builder.pop();
                }
            }

            public static class ApothecaryCauldronSettings {
                public final ForgeConfigSpec.IntValue redstoneLimit;
                public final ForgeConfigSpec.IntValue cookTime;
                public final ForgeConfigSpec.ConfigValue<List<String>> heatSources;
                public final ForgeConfigSpec.IntValue glowstoneLimit;

                ApothecaryCauldronSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Apothecary Cauldron settings").push("apothecaryCauldron");
                    this.redstoneLimit = builder.comment("Limit of redstone that can be used in cauldron to make POTION last longer").defineInRange("redstoneLimit", 3, 0, 5);
                    this.cookTime = builder.comment("Time it takes to cook POTION").defineInRange("cookTime", 160, 20, 32000);
                    this.heatSources = builder.comment("List of acceptable heat sources").define("heatSources", new ArrayList());
                    this.glowstoneLimit = builder.comment("Limit of glowstone that can be used in cauldron to make POTION more potent").defineInRange("glowstoneLimit", 2, 0, 4);
                    builder.pop();
                }
            }

            public static class FertileLilypadSettings {
                public final ForgeConfigSpec.IntValue secondsBetweenGrowthTicks;
                public final ForgeConfigSpec.IntValue tileRange;
                public final ForgeConfigSpec.IntValue fullPotencyRange;

                FertileLilypadSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Lilypad of Fertility settings").push("fertileLilypad");
                    this.secondsBetweenGrowthTicks = builder.comment("Interval in seconds at which the lilypad causes growth tick updates").defineInRange("secondsBetweenGrowthTicks", 10, 1, 150);
                    this.tileRange = builder.comment("Radius in which lilypad causes growh ticks").defineInRange("tileRange", 4, 1, 15);
                    this.fullPotencyRange = builder.comment("Radius around lilypad where the growth ticks occur the most often").defineInRange("fullPotencyRange", 1, 1, 15);
                    builder.pop();
                }
            }

            public static class InterdictionTorchSettings {
                public final ForgeConfigSpec.IntValue pushRadius;
                public final ForgeConfigSpec.BooleanValue canPushProjectiles;
                public final ForgeConfigSpec.ConfigValue<List<String>> pushableEntitiesBlacklist;
                public final ForgeConfigSpec.ConfigValue<List<String>> pushableProjectilesBlacklist;

                InterdictionTorchSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Interdiction Torch settings").push("interdictionTorch");
                    this.pushRadius = builder.comment("Radius in which the torch can push out mobs").defineInRange("pushRadius", 5, 1, 15);
                    this.canPushProjectiles = builder.comment("Whether the torch can push projectiles").define("canPushProjectiles", false);
                    this.pushableEntitiesBlacklist = builder.comment("List of entities that are banned from being pushed by the torch").define("pushableEntitiesBlacklist", new ArrayList());
                    this.pushableProjectilesBlacklist = builder.comment("List of projectiles that are banned from being pushed by the torch").define("pushableProjectilesBlacklist", new ArrayList());
                    builder.pop();
                }
            }

            public static class PedestalSettings {
                public final ForgeConfigSpec.IntValue meleeWrapperRange;
                public final ForgeConfigSpec.IntValue meleeWrapperCooldown;
                public final ForgeConfigSpec.IntValue bucketWrapperRange;
                public final ForgeConfigSpec.IntValue bucketWrapperCooldown;
                public final ForgeConfigSpec.IntValue shearsWrapperRange;
                public final ForgeConfigSpec.IntValue shearsWrapperCooldown;
                public final ForgeConfigSpec.IntValue redstoneWrapperRange;
                public final ForgeConfigSpec.IntValue fishingWrapperSuccessRate;
                public final ForgeConfigSpec.IntValue fishingWrapperRetractDelay;

                PedestalSettings(ForgeConfigSpec.Builder builder) {
                    builder.comment("Pedestal related settings").push("pedestal");
                    this.meleeWrapperRange = builder.comment("Range of the melee weapons in which these will attack when in pedestals").defineInRange("meleeWrapperRange", 5, 1, 10);
                    this.meleeWrapperCooldown = builder.comment("How long it takes after a melee weapon swing before it can swing again (in ticks)").defineInRange("meleeWrapperCooldown", 5, 1, 200);
                    this.bucketWrapperRange = builder.comment("Range at which bucket will pickup liquid blocks or milk cows").defineInRange("bucketWrapperRange", 4, 1, 10);
                    this.bucketWrapperCooldown = builder.comment("How long it takes in between bucket actions (in ticks)").defineInRange("bucketWrapperCooldown", 40, 1, 200);
                    this.shearsWrapperRange = builder.comment("How long it takes between shearing actions (in ticks)").defineInRange("shearsWrapperRange", 4, 1, 10);
                    this.shearsWrapperCooldown = builder.comment("Range at which shears will shear sheep or shearable blocks").defineInRange("shearsWrapperCooldown", 10, 1, 200);
                    this.redstoneWrapperRange = builder.comment("Range at which pedestals will get turned on if either redstone block gets put in or redstone dust and transmitting pedestals is powered").defineInRange("redstoneWrapperRange", 10, 1, 200);
                    this.fishingWrapperSuccessRate = builder.comment("Success rate of fishing in percent. When unsuccessful it will pull the hook too late to catch a fish.").defineInRange("fishingWrapperSuccessRate", 80, 0, 100);
                    this.fishingWrapperRetractDelay = builder.comment("Delay in seconds before it would start fishing again after retracting the hook.").defineInRange("fishingWrapperRetractDelay", 2, 1, 20);
                    builder.pop();
                }
            }
        }
    }

    public static class Client {
        public final HudPos hudPositions;
        public final ForgeConfigSpec.BooleanValue wailaShiftForInfo;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client Settings").push("client");
            this.hudPositions = new HudPos(builder);
            this.wailaShiftForInfo = builder.comment("Whether player has to sneak to see additional info in waila").define("waila_shift_for_info", false);
            builder.pop();
        }

        public static class HudPos {
            public final ForgeConfigSpec.EnumValue<HUDPosition> sojournerStaff;
            public final ForgeConfigSpec.EnumValue<HUDPosition> handgun;
            public final ForgeConfigSpec.EnumValue<HUDPosition> alkahestryTome;
            public final ForgeConfigSpec.EnumValue<HUDPosition> destructionCatalyst;
            public final ForgeConfigSpec.EnumValue<HUDPosition> enderStaff;
            public final ForgeConfigSpec.EnumValue<HUDPosition> iceMagusRod;
            public final ForgeConfigSpec.EnumValue<HUDPosition> glacialStaff;
            public final ForgeConfigSpec.EnumValue<HUDPosition> voidTear;
            public final ForgeConfigSpec.EnumValue<HUDPosition> midasTouchstone;
            public final ForgeConfigSpec.EnumValue<HUDPosition> harvestRod;
            public final ForgeConfigSpec.EnumValue<HUDPosition> infernalChalice;
            public final ForgeConfigSpec.EnumValue<HUDPosition> heroMedallion;
            public final ForgeConfigSpec.EnumValue<HUDPosition> pyromancerStaff;
            public final ForgeConfigSpec.EnumValue<HUDPosition> rendingGale;
            public final ForgeConfigSpec.EnumValue<HUDPosition> mobCharm;

            HudPos(ForgeConfigSpec.Builder builder) {
                builder.comment("Position of mode and/or item display on the screen - used by some of the tools and weapons.").push("hudPositions");
                this.sojournerStaff = builder.comment("Position of Sojouner Staff HUD").defineEnum("sojournerStaff", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.handgun = builder.comment("Position of Handgun HUD").defineEnum("handgun", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.alkahestryTome = builder.comment("Position of Alkahestry Tome HUD").defineEnum("alkahestryTome", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.destructionCatalyst = builder.comment("Position of Destruction Catalyst HUD").defineEnum("destructionCatalyst", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.enderStaff = builder.comment("Position of Ender Staff HUD").defineEnum("enderStaff", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.iceMagusRod = builder.comment("Position of Ice Magus Rod HUD").defineEnum("iceMagusRod", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.glacialStaff = builder.comment("Position of Glacial Staff HUD").defineEnum("glacialStaff", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.voidTear = builder.comment("Position of Void Tear HUD").defineEnum("voidTear", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.midasTouchstone = builder.comment("Position of Midas Touchstone HUD").defineEnum("midasTouchstone", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.harvestRod = builder.comment("Position of Infernal Chalice HUD").defineEnum("harvestRod", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.infernalChalice = builder.comment("Position of Ender Staff HUD").defineEnum("infernalChalice", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.heroMedallion = builder.comment("Position of Hero Medallion HUD").defineEnum("heroMedallion", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.pyromancerStaff = builder.comment("Position of Pyromancer Staff HUD").defineEnum("pyromancerStaff", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.rendingGale = builder.comment("Position of Rending Gale HUD").defineEnum("rendingGale", (Enum)HUDPosition.BOTTOM_RIGHT);
                this.mobCharm = builder.comment("Position of Mob Charm HUD").defineEnum("mobCharm", (Enum)HUDPosition.RIGHT);
                builder.pop();
            }
        }
    }
}

