/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import reliquary.compat.curios.CuriosCompat;
import reliquary.init.ModItems;
import reliquary.items.FortuneCoinItem;
import reliquary.items.util.ICuriosItem;

public class PacketFortuneCoinTogglePressed {
    private final InventoryType inventoryType;
    private final int slot;

    public PacketFortuneCoinTogglePressed(InventoryType inventoryType, int slot) {
        this.inventoryType = inventoryType;
        this.slot = slot;
    }

    static void encode(PacketFortuneCoinTogglePressed msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeByte(msg.inventoryType.ordinal());
        packetBuffer.writeInt(msg.slot);
    }

    static PacketFortuneCoinTogglePressed decode(FriendlyByteBuf packetBuffer) {
        return new PacketFortuneCoinTogglePressed(InventoryType.values()[packetBuffer.readByte()], packetBuffer.readInt());
    }

    static void onMessage(PacketFortuneCoinTogglePressed msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketFortuneCoinTogglePressed.handleMessage(msg, context.getSender()));
        context.setPacketHandled(true);
    }

    private static void handleMessage(PacketFortuneCoinTogglePressed message, @Nullable ServerPlayer player) {
        if (player == null) {
            return;
        }
        switch (message.inventoryType) {
            case MAIN: {
                ItemStack stack2 = (ItemStack)player.m_150109_().f_35974_.get(message.slot);
                if (stack2.m_41720_() != ModItems.FORTUNE_COIN.get()) break;
                ((FortuneCoinItem)ModItems.FORTUNE_COIN.get()).toggle(stack2);
                PacketFortuneCoinTogglePressed.showMessage(player, stack2);
                break;
            }
            case OFF_HAND: {
                ItemStack stack1 = (ItemStack)player.m_150109_().f_35976_.get(0);
                if (stack1.m_41720_() != ModItems.FORTUNE_COIN.get()) break;
                ((FortuneCoinItem)ModItems.FORTUNE_COIN.get()).toggle(stack1);
                PacketFortuneCoinTogglePressed.showMessage(player, stack1);
                break;
            }
            case CURIOS: {
                PacketFortuneCoinTogglePressed.run(() -> () -> CuriosCompat.getStackInSlot((LivingEntity)player, ICuriosItem.Type.NECKLACE.getIdentifier(), message.slot).ifPresent(stack -> {
                    if (stack.m_41720_() == ModItems.FORTUNE_COIN.get()) {
                        ((FortuneCoinItem)ModItems.FORTUNE_COIN.get()).toggle((ItemStack)stack);
                        PacketFortuneCoinTogglePressed.showMessage(player, stack);
                        CuriosCompat.setStackInSlot((LivingEntity)player, ICuriosItem.Type.NECKLACE.getIdentifier(), message.slot, stack);
                    }
                }));
            }
        }
    }

    private static void showMessage(ServerPlayer player, ItemStack fortuneCoin) {
        player.m_5661_((Component)Component.m_237110_((String)"chat.reliquary.fortune_coin.toggle", (Object[])new Object[]{FortuneCoinItem.isEnabled(fortuneCoin) ? Component.m_237115_((String)"chat.reliquary.fortune_coin.on").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"chat.reliquary.fortune_coin.off").m_130940_(ChatFormatting.RED)}), true);
    }

    private static void run(Supplier<Runnable> toRun) {
        toRun.get().run();
    }

    public static enum InventoryType {
        MAIN,
        OFF_HAND,
        CURIOS;

    }
}

