/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reliquary.blocks.PedestalBlock;
import reliquary.items.ToggleableItem;
import reliquary.items.util.IScrollableItem;
import reliquary.items.util.VoidTearItemStackHandler;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.LanguageHelper;
import reliquary.util.NBTHelper;
import reliquary.util.NoPlayerBlockItemUseContext;
import reliquary.util.RandHelper;
import reliquary.util.TranslationHelper;
import reliquary.util.WorldHelper;

public class VoidTearItem
extends ToggleableItem
implements IScrollableItem {
    private static final String CONTENTS_TAG = "contents";
    private static final String TOOLTIP_PREFIX = "tooltip.";

    public VoidTearItem() {
        super(new Item.Properties());
        MinecraftForge.EVENT_BUS.addListener(this::onItemPickup);
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.isEmpty(stack) ? 16 : 1;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilitySerializable<CompoundTag>(){
            final VoidTearItemStackHandler itemHandler = new VoidTearItemStackHandler();

            public CompoundTag serializeNBT() {
                return this.itemHandler.serializeNBT();
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.itemHandler.deserializeNBT(nbt);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this.itemHandler));
            }
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return !Minecraft.m_91087_().f_91066_.f_92090_.m_90857_() && super.m_5812_(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack voidTear, @Nullable Level world, List<Component> tooltip) {
        ItemStack contents = VoidTearItem.getTearContents(voidTear, true);
        if (VoidTearItem.isEmpty(voidTear, true)) {
            return;
        }
        if (this.isEnabled(voidTear)) {
            LanguageHelper.formatTooltip("tooltip.reliquary.absorb_active", Map.of("item", ChatFormatting.YELLOW + contents.m_41786_().getString()), tooltip);
            tooltip.add((Component)Component.m_237110_((String)(TranslationHelper.translTooltip(this) + ".mode"), (Object[])new Object[]{Component.m_237115_((String)(TranslationHelper.transl(this) + ".mode." + this.getMode(voidTear).m_7912_().toLowerCase())).m_130940_(ChatFormatting.YELLOW), Component.m_237115_((String)(TranslationHelper.translTooltip(this) + ".mode." + this.getMode(voidTear).m_7912_().toLowerCase())), Component.m_237115_((String)(TranslationHelper.translTooltip(this) + ".mode_change")).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.AQUA)}));
        }
        LanguageHelper.formatTooltip("tooltip.reliquary.tear_quantity", Map.of("item", contents.m_41786_().getString(), "amount", Integer.toString(contents.m_41613_())), tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return !VoidTearItem.isEmpty(stack, true);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack voidTear = player.m_21120_(hand);
        if (!world.f_46443_) {
            BlockHitResult rayTraceResult = VoidTearItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (rayTraceResult != null && rayTraceResult.m_6662_() == HitResult.Type.BLOCK && (InventoryHelper.hasItemHandler(world, rayTraceResult.m_82425_()) && player.m_6144_() || this.hasPlaceableBlock(voidTear))) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)voidTear);
            }
            if (this.isEmpty(voidTear)) {
                return this.rightClickEmpty(voidTear, player);
            }
            if (this.getItemQuantity(voidTear) == 0) {
                this.setEmpty(voidTear);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)voidTear);
            }
            if (player.m_6144_()) {
                return super.m_7203_(world, player, hand);
            }
            if (Boolean.TRUE.equals(InventoryHelper.getItemHandlerFrom(player).map(h -> this.attemptToEmptyIntoInventory(voidTear, player, (IItemHandler)h)).orElse(false))) {
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
                this.setEmpty(voidTear);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)voidTear);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)voidTear);
    }

    private boolean hasPlaceableBlock(ItemStack voidTear) {
        return !this.isEmpty(voidTear) && VoidTearItem.getTearContents(voidTear, false).m_41720_() instanceof BlockItem;
    }

    private InteractionResultHolder<ItemStack> rightClickEmpty(ItemStack emptyVoidTear, Player player) {
        return InventoryHelper.getItemHandlerFrom(player).map(playerInventory -> {
            ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, playerInventory);
            if (!target.m_41619_()) {
                ItemStack filledTear;
                if (emptyVoidTear.m_41613_() > 1) {
                    emptyVoidTear.m_41774_(1);
                    filledTear = new ItemStack((ItemLike)this);
                } else {
                    filledTear = emptyVoidTear;
                }
                this.buildTear(filledTear, target, player, (IItemHandler)playerInventory, true);
                player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
                if (emptyVoidTear.m_41613_() == 1) {
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)filledTear);
                }
                InventoryHelper.addItemToPlayerInventory(player, filledTear);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)emptyVoidTear);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)emptyVoidTear);
        }).orElse(new InteractionResultHolder(InteractionResult.PASS, (Object)emptyVoidTear));
    }

    private void buildTear(ItemStack voidTear, ItemStack target, Player player, IItemHandler inventory, boolean isPlayerInventory) {
        int quantity = InventoryHelper.getItemQuantity(target, inventory);
        if (isPlayerInventory) {
            if (quantity - target.m_41741_() > 0) {
                InventoryHelper.consumeItem(target, player, target.m_41741_(), quantity - target.m_41741_());
                quantity -= target.m_41741_();
            } else {
                InventoryHelper.consumeItem(target, player, 0, 1);
                quantity = 1;
            }
        } else {
            quantity = InventoryHelper.tryToRemoveFromInventory(target, inventory, (Integer)Settings.COMMON.items.voidTear.itemLimit.get());
        }
        this.setItemStack(voidTear, target);
        this.setItemQuantity(voidTear, quantity);
        NBTHelper.putBoolean("enabled", voidTear, (Boolean)Settings.COMMON.items.voidTear.absorbWhenCreated.get());
    }

    public void m_6883_(ItemStack voidTear, Level world, Entity entity, int slotNumber, boolean isSelected) {
        if (!world.f_46443_ && world.m_46467_() % 5L != 0L) {
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            if (this.isEnabled(voidTear)) {
                if (this.isEmpty(voidTear)) {
                    this.setEmpty(voidTear);
                    return;
                }
                ItemStack contents = this.getTearContents(voidTear);
                if (!contents.m_41619_()) {
                    this.fillTear(voidTear, player, contents);
                } else {
                    this.setEmpty(voidTear);
                }
            }
        }
    }

    private void fillTear(ItemStack voidTear, Player player, ItemStack contents) {
        int itemQuantity = InventoryHelper.getItemHandlerFrom(player).map(h -> InventoryHelper.getItemQuantity(contents, h)).orElse(9);
        if (this.getItemQuantity(voidTear) <= (Integer)Settings.COMMON.items.voidTear.itemLimit.get() && itemQuantity > this.getKeepQuantity(voidTear) && InventoryHelper.consumeItem(contents, player, this.getKeepQuantity(voidTear), itemQuantity - this.getKeepQuantity(voidTear)) && !player.m_7500_()) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) + itemQuantity - this.getKeepQuantity(voidTear));
        }
        if (this.getMode(voidTear) != Mode.NO_REFILL) {
            this.attemptToReplenish(player, voidTear);
        }
    }

    private void attemptToReplenish(Player player, ItemStack voidTear) {
        int slot;
        if (Boolean.TRUE.equals(InventoryHelper.getItemHandlerFrom(player).map(h -> this.fillFirstFirstStackFound(voidTear, (IItemHandler)h)).orElse(false))) {
            return;
        }
        while (this.getItemQuantity(voidTear) > 1 && (slot = player.m_150109_().m_36062_()) != -1) {
            ItemStack newStack = this.getTearContents(voidTear).m_41777_();
            int quantityToDecrease = Math.min(newStack.m_41741_(), this.getItemQuantity(voidTear) - 1);
            newStack.m_41764_(quantityToDecrease);
            player.m_150109_().m_6836_(slot, newStack);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return;
        }
    }

    private boolean fillFirstFirstStackFound(ItemStack voidTear, IItemHandler h) {
        for (int slot = 0; slot < h.getSlots(); ++slot) {
            ItemStack stackFound = h.getStackInSlot(slot);
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackFound, (ItemStack)this.getTearContents(voidTear))) continue;
            int quantityToDecrease = Math.min(stackFound.m_41741_() - stackFound.m_41613_(), this.getItemQuantity(voidTear) - 1);
            stackFound.m_41769_(quantityToDecrease);
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - quantityToDecrease);
            if (this.getMode(voidTear) == Mode.FULL_INVENTORY) continue;
            return true;
        }
        return false;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Direction face;
        ItemStack containerItem;
        BlockItem itemBlock;
        NoPlayerBlockItemUseContext noPlayerBlockItemUseContext;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack voidTear = player.m_21120_(hand);
        if (world.m_8055_(pos).m_60734_() instanceof PedestalBlock) {
            return InteractionResult.PASS;
        }
        LazyOptional handler = WorldHelper.getBlockEntity((BlockGetter)world, pos).map(InventoryHelper::getItemHandlerFrom).orElse(LazyOptional.empty());
        if (handler.isPresent()) {
            return handler.map(h -> this.processItemHandlerInteraction(player, hand, world, voidTear, (IItemHandler)h)).orElse(InteractionResult.FAIL);
        }
        if (!world.f_46443_ && this.hasPlaceableBlock(voidTear) && this.getItemQuantity(voidTear) > 0 && (noPlayerBlockItemUseContext = new NoPlayerBlockItemUseContext(world, pos, new ItemStack((ItemLike)(itemBlock = (BlockItem)(containerItem = this.getTearContents(voidTear)).m_41720_())), face = context.m_43719_())).m_7059_()) {
            this.setItemQuantity(voidTear, this.getItemQuantity(voidTear) - 1);
            itemBlock.m_40576_((BlockPlaceContext)noPlayerBlockItemUseContext);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult processItemHandlerInteraction(Player player, InteractionHand hand, Level world, ItemStack voidTear, IItemHandler itemHandler) {
        if (!world.f_46443_) {
            if (this.isEmpty(voidTear)) {
                return this.onItemUseFirstEmpty(voidTear, itemHandler, player, hand);
            }
            if (this.isEnabled(voidTear)) {
                this.drainInventory(voidTear, player, itemHandler);
            } else {
                this.emptyIntoInventory(player, hand, voidTear, itemHandler);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void emptyIntoInventory(Player player, InteractionHand hand, ItemStack voidTear, IItemHandler itemHandler) {
        this.attemptToEmptyIntoInventory(voidTear, player, itemHandler);
        if (this.getItemQuantity(voidTear) <= 0) {
            this.setEmpty(voidTear);
            player.m_21008_(hand, voidTear);
        }
    }

    private InteractionResult onItemUseFirstEmpty(ItemStack emptyVoidTear, IItemHandler inventory, Player player, InteractionHand hand) {
        ItemStack target = InventoryHelper.getTargetItem(emptyVoidTear, inventory);
        if (!target.m_41619_()) {
            ItemStack filledTear;
            if (emptyVoidTear.m_41613_() > 1) {
                emptyVoidTear.m_41774_(1);
                filledTear = new ItemStack((ItemLike)this);
            } else {
                filledTear = emptyVoidTear;
            }
            this.buildTear(filledTear, target, player, inventory, false);
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
            if (emptyVoidTear.m_41613_() == 1) {
                player.m_21008_(hand, filledTear);
            } else {
                InventoryHelper.addItemToPlayerInventory(player, filledTear);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean attemptToEmptyIntoInventory(ItemStack stack, Player player, IItemHandler inventory) {
        ItemStack contents = this.getTearContents(stack).m_41777_();
        contents.m_41764_(1);
        int quantity = this.getItemQuantity(stack);
        int maxNumberToEmpty = player.m_6144_() ? quantity : Math.min(contents.m_41741_(), quantity);
        this.setItemQuantity(stack, quantity -= InventoryHelper.tryToAddToInventory(contents, inventory, maxNumberToEmpty));
        if (quantity == 0) {
            player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.8f));
            return true;
        }
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
        return false;
    }

    private void drainInventory(ItemStack stack, Player player, IItemHandler inventory) {
        ItemStack contents = this.getTearContents(stack);
        int quantity = this.getItemQuantity(stack);
        int quantityDrained = InventoryHelper.tryToRemoveFromInventory(contents, inventory, (Integer)Settings.COMMON.items.voidTear.itemLimit.get() - quantity);
        if (quantityDrained <= 0) {
            return;
        }
        player.f_19853_.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.f_19853_.f_46441_) * 0.7f + 1.2f));
        this.setItemQuantity(stack, quantity + quantityDrained);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack voidTear) {
        CompoundTag nbt = super.getShareTag(voidTear);
        if (this.isEmpty(voidTear)) {
            return nbt;
        }
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("count", this.getItemQuantity(voidTear));
        nbt.m_128365_(CONTENTS_TAG, (Tag)this.getTearContents(voidTear).m_41739_(new CompoundTag()));
        return nbt;
    }

    public ItemStack getTearContents(ItemStack voidTear) {
        return VoidTearItem.getTearContents(voidTear, false);
    }

    public static ItemStack getTearContents(ItemStack voidTear, boolean isClient) {
        if (isClient) {
            CompoundTag nbt = voidTear.m_41783_();
            if (nbt == null || !nbt.m_128441_(CONTENTS_TAG)) {
                return ItemStack.f_41583_;
            }
            ItemStack contents = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(CONTENTS_TAG));
            contents.m_41764_(nbt.m_128451_("count"));
            return contents;
        }
        return VoidTearItem.getFromHandler(voidTear, VoidTearItemStackHandler::getTotalAmountStack).orElse(ItemStack.f_41583_);
    }

    private static <T> Optional<T> getFromHandler(ItemStack voidTear, Function<VoidTearItemStackHandler, T> get) {
        return InventoryHelper.getFromHandler(voidTear, get, VoidTearItemStackHandler.class);
    }

    private void runOnHandler(ItemStack voidTear, Consumer<VoidTearItemStackHandler> run) {
        InventoryHelper.runOnItemHandler(voidTear, run, VoidTearItemStackHandler.class);
    }

    private void setItemStack(ItemStack voidTear, ItemStack stack) {
        this.runOnHandler(voidTear, h -> h.setContainedStack(stack));
    }

    private void setItemQuantity(ItemStack voidTear, int quantity) {
        this.runOnHandler(voidTear, h -> h.setContainedStackAmount(quantity));
    }

    private int getItemQuantity(ItemStack voidTear) {
        return VoidTearItem.getFromHandler(voidTear, VoidTearItemStackHandler::getContainedAmount).orElse(0);
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack voidTear, Player player, double scrollDelta) {
        if (player.f_19853_.f_46443_) {
            return InteractionResult.PASS;
        }
        this.cycleMode(voidTear, scrollDelta > 0.0);
        return InteractionResult.SUCCESS;
    }

    public Mode getMode(ItemStack voidTear) {
        if (NBTHelper.getString("mode", voidTear).isEmpty()) {
            this.setMode(voidTear, Mode.ONE_STACK);
        }
        return Mode.valueOf(NBTHelper.getString("mode", voidTear));
    }

    private void setMode(ItemStack voidTear, Mode mode) {
        NBTHelper.putString("mode", voidTear, mode.toString());
    }

    private void cycleMode(ItemStack voidTear, boolean next) {
        if (this.isEmpty(voidTear)) {
            return;
        }
        if (next) {
            this.setMode(voidTear, this.getMode(voidTear).next());
        } else {
            this.setMode(voidTear, this.getMode(voidTear).previous());
        }
    }

    private int getKeepQuantity(ItemStack voidTear) {
        Mode mode = this.getMode(voidTear);
        if (mode == Mode.NO_REFILL) {
            return 0;
        }
        if (mode == Mode.ONE_STACK) {
            return this.getTearContents(voidTear).m_41741_();
        }
        return Integer.MAX_VALUE;
    }

    private void onItemPickup(EntityItemPickupEvent event) {
        ItemStack tearStack;
        ItemStack pickedUpStack = event.getItem().m_32055_();
        Player player = event.getEntity();
        ItemEntity itemEntity = event.getItem();
        for (int slot = 0; !(slot >= player.m_150109_().m_6643_() || (tearStack = player.m_150109_().m_8020_(slot)).m_41720_() == this && this.isEnabled(tearStack) && this.tryToPickupWithTear(event, pickedUpStack, player, itemEntity, tearStack)); ++slot) {
        }
    }

    private boolean tryToPickupWithTear(EntityItemPickupEvent event, ItemStack pickedUpStack, Player player, ItemEntity itemEntity, ItemStack tearStack) {
        int playerItemQuantity;
        int tearItemQuantity = this.getItemQuantity(tearStack);
        if (this.canAbsorbStack(pickedUpStack, tearStack) && ((playerItemQuantity = InventoryHelper.getItemHandlerFrom(player).map(h -> InventoryHelper.getItemQuantity(pickedUpStack, h)).orElse(0).intValue()) + pickedUpStack.m_41613_() >= this.getKeepQuantity(tearStack) || player.m_150109_().m_36062_() == -1)) {
            this.setItemQuantity(tearStack, tearItemQuantity + pickedUpStack.m_41613_());
            if (!itemEntity.m_20067_()) {
                RandomSource rand = itemEntity.f_19853_.f_46441_;
                itemEntity.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne(rand) * 0.7f + 1.0f) * 2.0f);
            }
            itemEntity.m_146870_();
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    boolean canAbsorbStack(ItemStack pickedUpStack, ItemStack tearStack) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.getTearContents(tearStack), (ItemStack)pickedUpStack) && this.getItemQuantity(tearStack) + pickedUpStack.m_41613_() <= (Integer)Settings.COMMON.items.voidTear.itemLimit.get();
    }

    public boolean isEmpty(ItemStack voidTear) {
        return VoidTearItem.isEmpty(voidTear, false);
    }

    public static boolean isEmpty(ItemStack voidTear, boolean isClient) {
        if (isClient) {
            return VoidTearItem.getTearContents(voidTear, true).m_41619_();
        }
        return !VoidTearItem.hasEnabledTag(voidTear) || VoidTearItem.getFromHandler(voidTear, h -> h.getStackSlots() <= 0 || h.getContainedAmount() <= 0).orElse(true) != false;
    }

    private void setEmpty(ItemStack voidTear) {
        voidTear.m_41751_(null);
        this.setItemStack(voidTear, ItemStack.f_41583_);
        this.setItemQuantity(voidTear, 0);
    }

    public static enum Mode implements StringRepresentable
    {
        ONE_STACK,
        FULL_INVENTORY,
        NO_REFILL;

        private static final Mode[] VALUES;

        public String m_7912_() {
            return this.name();
        }

        public Mode next() {
            return VALUES[(this.ordinal() + 1) % VALUES.length];
        }

        public Mode previous() {
            return VALUES[Math.floorMod(this.ordinal() - 1, VALUES.length)];
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode value : Mode.values()) {
                builder.put((Object)value.m_7912_(), (Object)value);
            }
            VALUES = Mode.values();
        }
    }
}

